/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.TemplateMetadataSerializer;
import com.google.template.soy.soytree.CompilationUnit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.Option;

final class SoyHeaderCompiler
extends AbstractSoyCompiler {
    @Option(name="--output", required=true, usage="[Required] The file name of the output file to be written.  Each compiler invocation will produce exactly one file containing all the TemplateMetadata")
    private File output;

    SoyHeaderCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyHeaderCompiler() {
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        SoyFileSetParser.ParseResult result = sfsBuilder.build().compileMinimallyForHeaders();
        CompilationUnit unit = TemplateMetadataSerializer.compilationUnitFromFileSet(result.fileSet(), result.registry());
        try (GZIPOutputStream os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.output), 65536);){
            unit.writeTo(os);
        }
    }

    public static void main(String[] args) throws IOException {
        new SoyHeaderCompiler().runMain(args);
    }
}

