/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.CommandLineError;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.conformance.ConformanceConfig;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Option;

public final class SoyConformanceChecker
extends AbstractSoyCompiler {
    @Option(name="--conformanceConfig", aliases={"--conformanceConfigs"}, usage="Location of conformance config protos in text proto format.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> conformanceConfigs = new ArrayList<File>();

    SoyConformanceChecker(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyConformanceChecker() {
    }

    public static void main(String[] args) throws IOException {
        new SoyConformanceChecker().runMain(args);
    }

    @Override
    void validateFlags() {
        if (this.conformanceConfigs.isEmpty()) {
            SoyConformanceChecker.exitWithError("Must set --conformanceConfig");
        }
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) {
        ValidatedConformanceConfig conformanceConfig = this.parseConformanceConfig();
        sfsBuilder.setConformanceConfig(conformanceConfig).build().checkConformance();
    }

    private ValidatedConformanceConfig parseConformanceConfig() {
        ValidatedConformanceConfig config = ValidatedConformanceConfig.EMPTY;
        for (File conformanceConfig : this.conformanceConfigs) {
            try {
                InputStreamReader stream = new InputStreamReader((InputStream)new FileInputStream(conformanceConfig), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    ConformanceConfig.Builder builder = ConformanceConfig.newBuilder();
                    TextFormat.getParser().merge((Readable)stream, (Message.Builder)builder);
                    config = config.concat(ValidatedConformanceConfig.create(builder.build()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineError("Error parsing conformance proto: " + conformanceConfig + ": " + e.getMessage());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CommandLineError("Invalid conformance proto: " + conformanceConfig + ": " + e.getMessage());
            }
            catch (IOException e) {
                throw new CommandLineError("Unable to read conformance proto: " + conformanceConfig + ": " + e.getMessage());
            }
        }
        return config;
    }
}

