/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.CharSource;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.SoyCompilerFileReader;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.SoyUtils;
import com.google.template.soy.base.internal.FixedIdGenerator;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.StableSoyFileSupplier;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.logging.LoggingConfig;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;

final class CacheLoaders {
    static final SoyInputCache.CacheLoader<LoggingConfig> LOGGING_CONFIG_LOADER = new SoyInputCache.CacheLoader<LoggingConfig>(){

        @Override
        public LoggingConfig read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            try (InputStream stream = reader.read(file).openStream();){
                LoggingConfig loggingConfig = LoggingConfig.parseFrom(stream);
                return loggingConfig;
            }
        }
    };
    static final SoyInputCache.CacheLoader<ImmutableMap<String, PrimitiveData>> GLOBALS_LOADER = new SoyInputCache.CacheLoader<ImmutableMap<String, PrimitiveData>>(){

        @Override
        public ImmutableMap<String, PrimitiveData> read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            return SoyUtils.parseCompileTimeGlobals(reader.read(file).asCharSource(StandardCharsets.UTF_8));
        }
    };
    static final SoyInputCache.CacheLoader<CachedDescriptorSet> CACHED_DESCRIPTOR_SET_LOADER = new SoyInputCache.CacheLoader<CachedDescriptorSet>(){

        @Override
        public CachedDescriptorSet read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            try (InputStream stream = reader.read(file).openStream();){
                CachedDescriptorSet cachedDescriptorSet = new CachedDescriptorSet(file, DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)stream, (ExtensionRegistryLite)ProtoUtils.REGISTRY));
                return cachedDescriptorSet;
            }
        }
    };
    static final SoyInputCache.CacheLoader<CompilationUnit> COMPILATION_UNIT_LOADER = new SoyInputCache.CacheLoader<CompilationUnit>(){

        @Override
        public CompilationUnit read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            try (GZIPInputStream is = new GZIPInputStream(reader.read(file).openStream(), 32768);){
                CompilationUnit compilationUnit = CompilationUnit.parseFrom(is);
                return compilationUnit;
            }
        }
    };
    static final SoyInputCache.CacheLoader<CachedSoyFileSupplier> SOY_FILE_LOADER = new SoyInputCache.CacheLoader<CachedSoyFileSupplier>(){
        private final FixedIdGenerator idGenerator = new FixedIdGenerator(-1);

        @Override
        public CachedSoyFileSupplier read(File file, SoyCompilerFileReader reader, SoyInputCache cache) throws IOException {
            SoyFileNode fileNode;
            CharSource source = reader.read(file).asCharSource(StandardCharsets.UTF_8);
            StableSoyFileSupplier delegate = new StableSoyFileSupplier(source, file.getPath());
            ErrorReporter errors = ErrorReporter.create((Map<String, SoyFileSupplier>)ImmutableMap.of());
            try (Reader charReader = source.openStream();){
                fileNode = new SoyFileParser(this.idGenerator, charReader, file.getPath(), errors).parseSoyFile();
            }
            return new CachedSoyFileSupplier(delegate, errors, fileNode);
        }
    };

    CacheLoaders() {
    }

    private static final class CachedSoyFileSupplier
    implements SoyFileSupplier,
    SoyFileSetParser.HasAstOrErrors {
        private final SoyFileSupplier delegate;
        private final ErrorReporter errors;
        @Nullable
        private final SoyFileNode file;

        CachedSoyFileSupplier(SoyFileSupplier delegate, ErrorReporter errors, SoyFileNode file) {
            this.delegate = (SoyFileSupplier)Preconditions.checkNotNull((Object)delegate);
            this.errors = (ErrorReporter)Preconditions.checkNotNull((Object)errors);
            this.file = file;
            if (file == null) {
                Preconditions.checkArgument((boolean)errors.hasErrors());
            }
        }

        @Override
        public SoyFileNode getAst(IdGenerator nodeIdGen, ErrorReporter other) {
            this.errors.copyTo(other);
            if (this.file != null) {
                return SoyTreeUtils.cloneWithNewIds(this.file, nodeIdGen);
            }
            return null;
        }

        @Override
        public boolean hasChangedSince(SoyFileSupplier.Version version) {
            return this.delegate.hasChangedSince(version);
        }

        @Override
        public String getFilePath() {
            return this.delegate.getFilePath();
        }

        @Override
        public CharSource asCharSource() {
            return this.delegate.asCharSource();
        }

        @Override
        public Reader open() throws IOException {
            return this.delegate.open();
        }

        @Override
        public SoyFileSupplier.Version getVersion() {
            return this.delegate.getVersion();
        }
    }

    static final class CachedDescriptorSet {
        private final File file;
        private final Map<String, DescriptorProtos.FileDescriptorProto> protosByFileName;
        private final Map<String, Descriptors.FileDescriptor> fileNameToDescriptors = new LinkedHashMap<String, Descriptors.FileDescriptor>();

        CachedDescriptorSet(File file, DescriptorProtos.FileDescriptorSet proto) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
            ImmutableMap.Builder protosByFileNameBuilder = ImmutableMap.builder();
            for (DescriptorProtos.FileDescriptorProto fileProto : proto.getFileList()) {
                protosByFileNameBuilder.put((Object)fileProto.getName(), (Object)fileProto);
            }
            this.protosByFileName = protosByFileNameBuilder.build();
        }

        File getFile() {
            return this.file;
        }

        Set<String> getProtoFileNames() {
            return this.protosByFileName.keySet();
        }

        Collection<Descriptors.FileDescriptor> getFileDescriptors(SetMultimap<String, CachedDescriptorSet> protoFileToDescriptor, SoyInputCache cache) throws Descriptors.DescriptorValidationException {
            if (this.fileNameToDescriptors.size() == this.protosByFileName.size()) {
                return this.fileNameToDescriptors.values();
            }
            for (DescriptorProtos.FileDescriptorProto fileProto : this.protosByFileName.values()) {
                this.buildDescriptor(fileProto, protoFileToDescriptor, cache);
            }
            return this.fileNameToDescriptors.values();
        }

        private Descriptors.FileDescriptor buildDescriptor(DescriptorProtos.FileDescriptorProto fileProto, SetMultimap<String, CachedDescriptorSet> protoFileToDescriptor, SoyInputCache cache) throws Descriptors.DescriptorValidationException {
            Descriptors.FileDescriptor descriptor = this.fileNameToDescriptors.get(fileProto.getName());
            if (descriptor != null) {
                return descriptor;
            }
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[fileProto.getDependencyCount()];
            for (int i = 0; i < fileProto.getDependencyCount(); ++i) {
                String depName = fileProto.getDependency(i);
                Set depDescriptorSets = protoFileToDescriptor.get((Object)depName);
                if (depDescriptorSets.isEmpty()) {
                    throw new IllegalStateException("Cannot find proto descriptor for " + depName + " which is a dependency of " + fileProto.getName());
                }
                for (CachedDescriptorSet dep : depDescriptorSets) {
                    if (dep == this) continue;
                    cache.declareDependency(this.getFile(), dep.getFile());
                }
                CachedDescriptorSet dep = (CachedDescriptorSet)depDescriptorSets.iterator().next();
                DescriptorProtos.FileDescriptorProto depProto = dep.protosByFileName.get(depName);
                if (depProto == null) {
                    throw new IllegalStateException("Cannot find proto for: " + depName + " which is a dependency of " + fileProto.getName());
                }
                deps[i] = dep.buildDescriptor(depProto, protoFileToDescriptor, cache);
            }
            descriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileProto, (Descriptors.FileDescriptor[])deps);
            this.fileNameToDescriptors.put(fileProto.getName(), descriptor);
            return descriptor;
        }
    }
}

