/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.types.ast.AutoValue_GenericTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;

@AutoValue
public abstract class GenericTypeNode
extends TypeNode {
    GenericTypeNode() {
    }

    public static GenericTypeNode create(SourceLocation sourceLocation, Identifier name, Iterable<? extends TypeNode> arguments) {
        return new AutoValue_GenericTypeNode(sourceLocation, name, (ImmutableList<TypeNode>)ImmutableList.copyOf(arguments));
    }

    abstract Identifier identifier();

    public String name() {
        return this.identifier().identifier();
    }

    public SourceLocation nameLocation() {
        return this.identifier().location();
    }

    public abstract ImmutableList<TypeNode> arguments();

    @Override
    public final String toString() {
        return this.name() + "<" + Joiner.on((String)", ").join(this.arguments()) + ">";
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public GenericTypeNode copy() {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (TypeNode arg : this.arguments()) {
            newArguments.add((Object)arg.copy());
        }
        GenericTypeNode copy = GenericTypeNode.create(this.sourceLocation(), this.identifier(), (Iterable<? extends TypeNode>)newArguments.build());
        copy.copyResolvedTypeFrom(this);
        return copy;
    }
}

