/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Ascii;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.PrimitiveType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;

public abstract class SanitizedType
extends PrimitiveType {
    public abstract SanitizedContentKind getContentKind();

    @Override
    public String toString() {
        return Ascii.toLowerCase((String)this.getContentKind().toString());
    }

    public static SoyType getTypeForContentKind(SanitizedContentKind contentKind) {
        switch (contentKind) {
            case ATTRIBUTES: {
                return AttributesType.getInstance();
            }
            case CSS: {
                return StyleType.getInstance();
            }
            case HTML: {
                return HtmlType.getInstance();
            }
            case JS: {
                return JsType.getInstance();
            }
            case URI: {
                return UriType.getInstance();
            }
            case TRUSTED_RESOURCE_URI: {
                return TrustedResourceUriType.getInstance();
            }
            case TEXT: {
                return StringType.getInstance();
            }
        }
        throw new AssertionError((Object)contentKind);
    }

    public static final class JsType
    extends SanitizedType {
        private static final JsType INSTANCE = new JsType();

        private JsType() {
        }

        @Override
        public SoyType.Kind getKind() {
            return SoyType.Kind.JS;
        }

        @Override
        public SanitizedContentKind getContentKind() {
            return SanitizedContentKind.JS;
        }

        @Override
        void doToProto(SoyTypeP.Builder builder) {
            builder.setPrimitive(SoyTypeP.PrimitiveTypeP.JS);
        }

        public static JsType getInstance() {
            return INSTANCE;
        }
    }

    public static final class StyleType
    extends SanitizedType {
        private static final StyleType INSTANCE = new StyleType();

        private StyleType() {
        }

        @Override
        public SoyType.Kind getKind() {
            return SoyType.Kind.CSS;
        }

        @Override
        public SanitizedContentKind getContentKind() {
            return SanitizedContentKind.CSS;
        }

        @Override
        void doToProto(SoyTypeP.Builder builder) {
            builder.setPrimitive(SoyTypeP.PrimitiveTypeP.CSS);
        }

        public static StyleType getInstance() {
            return INSTANCE;
        }
    }

    public static final class TrustedResourceUriType
    extends SanitizedType {
        private static final TrustedResourceUriType INSTANCE = new TrustedResourceUriType();

        private TrustedResourceUriType() {
        }

        @Override
        public SoyType.Kind getKind() {
            return SoyType.Kind.TRUSTED_RESOURCE_URI;
        }

        @Override
        public SanitizedContentKind getContentKind() {
            return SanitizedContentKind.TRUSTED_RESOURCE_URI;
        }

        @Override
        void doToProto(SoyTypeP.Builder builder) {
            builder.setPrimitive(SoyTypeP.PrimitiveTypeP.TRUSTED_RESOURCE_URI);
        }

        public static TrustedResourceUriType getInstance() {
            return INSTANCE;
        }
    }

    public static final class UriType
    extends SanitizedType {
        private static final UriType INSTANCE = new UriType();

        private UriType() {
        }

        @Override
        public SoyType.Kind getKind() {
            return SoyType.Kind.URI;
        }

        @Override
        public SanitizedContentKind getContentKind() {
            return SanitizedContentKind.URI;
        }

        @Override
        void doToProto(SoyTypeP.Builder builder) {
            builder.setPrimitive(SoyTypeP.PrimitiveTypeP.URI);
        }

        public static UriType getInstance() {
            return INSTANCE;
        }
    }

    public static final class AttributesType
    extends SanitizedType {
        private static final AttributesType INSTANCE = new AttributesType();

        private AttributesType() {
        }

        @Override
        public SoyType.Kind getKind() {
            return SoyType.Kind.ATTRIBUTES;
        }

        @Override
        public SanitizedContentKind getContentKind() {
            return SanitizedContentKind.ATTRIBUTES;
        }

        @Override
        void doToProto(SoyTypeP.Builder builder) {
            builder.setPrimitive(SoyTypeP.PrimitiveTypeP.ATTRIBUTES);
        }

        public static AttributesType getInstance() {
            return INSTANCE;
        }
    }

    public static final class HtmlType
    extends SanitizedType {
        private static final HtmlType INSTANCE = new HtmlType();

        private HtmlType() {
        }

        @Override
        public SoyType.Kind getKind() {
            return SoyType.Kind.HTML;
        }

        @Override
        public SanitizedContentKind getContentKind() {
            return SanitizedContentKind.HTML;
        }

        @Override
        void doToProto(SoyTypeP.Builder builder) {
            builder.setPrimitive(SoyTypeP.PrimitiveTypeP.HTML);
        }

        public static HtmlType getInstance() {
            return INSTANCE;
        }
    }
}

