/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.AbstractVarDefn;
import com.google.template.soy.types.SoyType;

public class LocalVar
extends AbstractVarDefn {
    private final SoyNode.LocalVarNode declaringNode;

    private static String checkAndFixName(String name) {
        Preconditions.checkArgument((name.charAt(0) == '$' ? 1 : 0) != 0);
        return name.substring(1);
    }

    public LocalVar(String name, SourceLocation nameLocation, SoyNode.LocalVarNode declaringNode, SoyType type) {
        super(LocalVar.checkAndFixName(name), nameLocation, type);
        this.declaringNode = declaringNode;
    }

    public LocalVar(LocalVar localVar, SoyNode.LocalVarNode declaringNode) {
        super(localVar);
        Preconditions.checkArgument((localVar.declaringNode != declaringNode ? 1 : 0) != 0);
        this.declaringNode = declaringNode;
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.LOCAL_VAR;
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    public SoyNode.LocalVarNode declaringNode() {
        return this.declaringNode;
    }

    @Override
    public boolean isInjected() {
        return false;
    }
}

