/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import javax.annotation.Nullable;

public final class TemplateElementNode
extends TemplateNode
implements SoyNode.ExprHolderNode {
    private final ImmutableList<TemplateStateVar> stateVars;

    TemplateElementNode(TemplateElementNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, @Nullable ImmutableList<TemplateParam> params, ImmutableList<TemplateStateVar> stateVars) {
        super(nodeBuilder, "element", soyFileHeaderInfo, Visibility.PUBLIC, params);
        this.stateVars = stateVars;
    }

    private TemplateElementNode(TemplateElementNode orig, CopyState copyState) {
        super(orig, copyState);
        this.stateVars = TemplateElementNode.copyState(orig.stateVars, copyState);
    }

    private static ImmutableList<TemplateStateVar> copyState(ImmutableList<TemplateStateVar> orig, CopyState copyState) {
        ImmutableList.Builder newParams = ImmutableList.builder();
        for (TemplateStateVar prev : orig) {
            TemplateStateVar next = prev.copy();
            newParams.add((Object)next);
            copyState.updateRefs(prev, next);
        }
        return newParams.build();
    }

    public ImmutableList<TemplateStateVar> getStateVars() {
        return this.stateVars;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(super.getExprList());
        for (TemplateStateVar state : this.getStateVars()) {
            builder.add((Object)state.defaultValue());
        }
        return builder.build();
    }

    @Override
    protected ImmutableList<? extends TemplateHeaderVarDefn> getHeaderParamsForSourceString() {
        return new ImmutableList.Builder().addAll(super.getHeaderParamsForSourceString()).addAll(this.stateVars).build();
    }

    @Override
    protected ImmutableMap<Class<?>, String> getDeclNameMap() {
        return ImmutableMap.of(TemplateParam.class, (Object)"@param", InjectedParam.class, (Object)"@inject", TemplateStateVar.class, (Object)"@state");
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_ELEMENT_NODE;
    }

    @Override
    public TemplateElementNode copy(CopyState copyState) {
        return new TemplateElementNode(this, copyState);
    }
}

