/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;

public final class MessagePlaceholders {
    public static final String PHNAME_ATTR = "phname";
    public static final String PHEX_ATTR = "phex";
    private static final SoyErrorKind INVALID_PHNAME_ATTRIBUTE = SoyErrorKind.of("''phname'' is not a valid identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PHNAME_EXAMPLE = SoyErrorKind.of("Placeholder examples must be non-empty.", new SoyErrorKind.StyleAllowance[0]);

    static String validatePlaceholderName(String placeholderName, SourceLocation location, ErrorReporter reporter) {
        if (BaseUtils.isIdentifier(placeholderName)) {
            return placeholderName;
        }
        reporter.report(location, INVALID_PHNAME_ATTRIBUTE, new Object[0]);
        return null;
    }

    static String validatePlaceholderExample(String example, SourceLocation location, ErrorReporter reporter) {
        if (!example.isEmpty()) {
            return example;
        }
        reporter.report(location, INVALID_PHNAME_EXAMPLE, new Object[0]);
        return null;
    }
}

