/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.WhitespaceMode;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class CommandTagAttribute {
    private static final SoyErrorKind DUPLICATE_ATTRIBUTE = SoyErrorKind.of("Attribute ''{0}'' was already specified.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_ATTRIBUTE = SoyErrorKind.of("Invalid value for attribute ''{0}'', expected {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_ATTRIBUTE_LIST = SoyErrorKind.of("Invalid value for attribute ''{0}'', expected one of {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_CSS_BASE_NAMESPACE_NAME = SoyErrorKind.of("Invalid CSS base namespace name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_REQUIRE_CSS_ATTRIBUTE = SoyErrorKind.of("Invalid required CSS namespace name ''{0}'', expected an identifier.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind MISSING_ATTRIBUTE = SoyErrorKind.of("Missing required attribute ''{0}'' in ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind UNSUPPORTED_ATTRIBUTE_KEY = SoyErrorKind.of("Unsupported attribute ''{0}'' for ''{1}'' tag, expected one of {2}.", new SoyErrorKind.StyleAllowance[0]);
    public static final SoyErrorKind UNSUPPORTED_ATTRIBUTE_KEY_SINGLE = SoyErrorKind.of("Unsupported attribute ''{0}'' for ''{1}'' tag, expected ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPECTED_A_SINGLE_EXPRESSION = SoyErrorKind.of("Expected a single expression for a {0} attribute.", new SoyErrorKind.StyleAllowance[0]);
    static final SoyErrorKind NAMESPACE_STRICTHTML_ATTRIBUTE = SoyErrorKind.of("''stricthtml=\"false\"'' can only be set on individual templates.", new SoyErrorKind.StyleAllowance[0]);
    static final SoyErrorKind NAMESPACE_AUTOESCAPE_ATTRIBUTE = SoyErrorKind.of("''autoescape'' can only be set on individual templates.", new SoyErrorKind.StyleAllowance[0]);
    static final SoyErrorKind EXPLICIT_DEFAULT_ATTRIBUTE = SoyErrorKind.of("''{0}=\"{1}\"'' is the default, no need to set it.", new SoyErrorKind.StyleAllowance[0]);
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults();
    private final Identifier key;
    private final SourceLocation valueLocation;
    private final QuoteStyle quoteStyle;
    @Nullable
    private final String value;
    @Nullable
    private final ImmutableList<ExprNode> valueExprList;

    public static void removeDuplicatesAndReportErrors(Iterable<CommandTagAttribute> attrs, ErrorReporter errorReporter) {
        HashSet<String> seenAttributes = new HashSet<String>();
        Iterator<CommandTagAttribute> iterator = attrs.iterator();
        while (iterator.hasNext()) {
            CommandTagAttribute attr = iterator.next();
            Identifier name = attr.getName();
            if (seenAttributes.add(name.identifier())) continue;
            errorReporter.report(name.location(), DUPLICATE_ATTRIBUTE, name.identifier());
            iterator.remove();
        }
    }

    public CommandTagAttribute(Identifier key, QuoteStyle quoteStyle, String value, SourceLocation valueLocation) {
        Preconditions.checkArgument((key.type() == Identifier.Type.SINGLE_IDENT ? 1 : 0) != 0, (String)"expected a single identifier, got: %s", (Object)key);
        this.key = (Identifier)Preconditions.checkNotNull((Object)key);
        this.quoteStyle = (QuoteStyle)((Object)Preconditions.checkNotNull((Object)((Object)quoteStyle)));
        this.valueLocation = (SourceLocation)Preconditions.checkNotNull((Object)valueLocation);
        this.value = (String)Preconditions.checkNotNull((Object)value);
        this.valueExprList = null;
    }

    public CommandTagAttribute(Identifier key, QuoteStyle quoteStyle, ImmutableList<ExprNode> valueExprList) {
        Preconditions.checkArgument((key.type() == Identifier.Type.SINGLE_IDENT ? 1 : 0) != 0, (String)"expected a single identifier, got: %s", (Object)key);
        Preconditions.checkArgument((valueExprList.size() >= 1 ? 1 : 0) != 0);
        this.key = (Identifier)Preconditions.checkNotNull((Object)key);
        this.quoteStyle = (QuoteStyle)((Object)Preconditions.checkNotNull((Object)((Object)quoteStyle)));
        this.valueLocation = ((ExprNode)valueExprList.get(0)).getSourceLocation().extend(((ExprNode)Iterables.getLast(valueExprList)).getSourceLocation());
        this.value = null;
        this.valueExprList = valueExprList;
    }

    public Identifier getName() {
        return this.key;
    }

    public boolean hasName(String name) {
        return this.key.identifier().equals(name);
    }

    public String getValue() {
        return (String)Preconditions.checkNotNull((Object)this.value);
    }

    public SourceLocation getValueLocation() {
        return this.valueLocation;
    }

    public QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public int valueAsInteger(ErrorReporter errorReporter, int defaultValue) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), "an integer");
            return defaultValue;
        }
    }

    boolean valueAsEnabled(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        if ("true".equals(this.value)) {
            return true;
        }
        if ("false".equals(this.value)) {
            errorReporter.report(this.valueLocation, EXPLICIT_DEFAULT_ATTRIBUTE, this.key.identifier(), "false");
        } else {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), "true");
        }
        return false;
    }

    boolean valueAsDisabled(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        if ("false".equals(this.value)) {
            return true;
        }
        if ("true".equals(this.value)) {
            errorReporter.report(this.valueLocation, EXPLICIT_DEFAULT_ATTRIBUTE, this.key.identifier(), "true");
        } else {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), "false");
        }
        return false;
    }

    ImmutableList<String> valueAsRequireCss(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        Iterable namespaces = SPLITTER.split((CharSequence)this.value);
        boolean hasError = false;
        for (String namespace : namespaces) {
            if (BaseUtils.isDottedIdentifier(namespace)) continue;
            errorReporter.report(this.valueLocation, INVALID_REQUIRE_CSS_ATTRIBUTE, namespace);
            hasError = true;
        }
        return hasError ? ImmutableList.of() : ImmutableList.copyOf((Iterable)namespaces);
    }

    AutoescapeMode valueAsAutoescapeMode(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        AutoescapeMode mode = AutoescapeMode.forAttributeValue(this.value);
        if (mode == AutoescapeMode.STRICT) {
            errorReporter.report(this.valueLocation, EXPLICIT_DEFAULT_ATTRIBUTE, "autoescape", "strict");
        } else if (mode == null) {
            mode = AutoescapeMode.STRICT;
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), AutoescapeMode.CONTEXTUAL.getAttributeValue());
        }
        return mode;
    }

    @Nullable
    Visibility valueAsVisibility(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        Visibility visibility = Visibility.forAttributeValue(this.value);
        if (visibility == Visibility.PUBLIC) {
            errorReporter.report(this.valueLocation, EXPLICIT_DEFAULT_ATTRIBUTE, this.key.identifier(), Visibility.PUBLIC.getAttributeValue());
        } else if (visibility == null) {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), Visibility.PRIVATE.getAttributeValue());
        }
        return visibility;
    }

    @Nullable
    WhitespaceMode valueAsWhitespaceMode(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        WhitespaceMode whitespaceMode = WhitespaceMode.forAttributeValue(this.value);
        if (whitespaceMode == WhitespaceMode.JOIN) {
            errorReporter.report(this.valueLocation, EXPLICIT_DEFAULT_ATTRIBUTE, this.key.identifier(), WhitespaceMode.JOIN.getAttributeValue());
        } else if (whitespaceMode == null) {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE_LIST, this.key.identifier(), WhitespaceMode.getAttributeValues());
        }
        return whitespaceMode;
    }

    @Nullable
    public SanitizedContentKind valueAsContentKind(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        Optional<SanitizedContentKind> contentKind = SanitizedContentKind.fromAttributeValue(this.value);
        if (!contentKind.isPresent()) {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE_LIST, this.key.identifier(), SanitizedContentKind.attributeValues().asList());
        }
        return (SanitizedContentKind)((Object)contentKind.orNull());
    }

    String valueAsCssBase(ErrorReporter errorReporter) {
        Preconditions.checkState((this.valueExprList == null ? 1 : 0) != 0);
        if (!BaseUtils.isDottedIdentifier(this.value)) {
            errorReporter.report(this.valueLocation, INVALID_CSS_BASE_NAMESPACE_NAME, this.value);
        }
        return this.value;
    }

    public ExprNode valueAsExpr(ErrorReporter reporter) {
        Preconditions.checkState((this.value == null ? 1 : 0) != 0);
        if (this.valueExprList.size() > 1) {
            reporter.report(((ExprNode)this.valueExprList.get(1)).getSourceLocation(), EXPECTED_A_SINGLE_EXPRESSION, this.key.identifier());
            return (ExprNode)this.valueExprList.get(0);
        }
        return (ExprNode)Iterables.getOnlyElement(this.valueExprList);
    }

    public ImmutableList<ExprNode> valueAsExprList() {
        Preconditions.checkState((this.value == null ? 1 : 0) != 0);
        return (ImmutableList)Preconditions.checkNotNull(this.valueExprList);
    }

    public String toString() {
        String valueStr = this.value != null ? BaseUtils.escapeToSoyString(this.value, false, this.quoteStyle) : this.quoteStyle.getQuoteChar() + SoyTreeUtils.toSourceString(this.valueExprList) + this.quoteStyle.getQuoteChar();
        return this.key.identifier() + "=" + valueStr;
    }
}

