/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class CallBasicNode
extends CallNode {
    private final String fullCalleeName;
    private final Identifier sourceCalleeName;
    @Nullable
    private Predicate<String> paramsToRuntimeTypeCheck = null;

    public CallBasicNode(int id, SourceLocation location, Identifier sourceCalleeName, String fullCalleeName, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, "call", attributes, errorReporter);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(fullCalleeName));
        this.sourceCalleeName = sourceCalleeName;
        this.fullCalleeName = fullCalleeName;
        block9: for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": 
                case "key": 
                case "phname": 
                case "phex": {
                    continue block9;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, "call", ImmutableList.of((Object)"data", (Object)"phname", (Object)"phex"));
        }
    }

    private CallBasicNode(CallBasicNode orig, CopyState copyState) {
        super(orig, copyState);
        this.sourceCalleeName = orig.sourceCalleeName;
        this.fullCalleeName = orig.fullCalleeName;
        this.paramsToRuntimeTypeCheck = orig.paramsToRuntimeTypeCheck;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public String getSourceCalleeName() {
        return this.sourceCalleeName.identifier();
    }

    @Override
    public SourceLocation getSourceCalleeLocation() {
        return this.sourceCalleeName.location();
    }

    public String getCalleeName() {
        return this.fullCalleeName;
    }

    public void setParamsToRuntimeCheck(Predicate<String> paramNames) {
        Preconditions.checkState((this.paramsToRuntimeTypeCheck == null ? 1 : 0) != 0);
        this.paramsToRuntimeTypeCheck = (Predicate)Preconditions.checkNotNull(paramNames);
    }

    @Override
    public Predicate<String> getParamsToRuntimeCheck(String calleeTemplateName) {
        return this.paramsToRuntimeTypeCheck == null ? arg -> true : this.paramsToRuntimeTypeCheck;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder(this.getSourceCalleeName());
        if (this.isPassingAllData()) {
            commandText.append(" data=\"all\"");
        } else if (this.getDataExpr() != null) {
            commandText.append(" data=\"").append(this.getDataExpr().toSourceString()).append('\"');
        }
        if (this.getUserSuppliedPhName() != null) {
            commandText.append(" phname=\"").append(this.getUserSuppliedPhName()).append('\"');
        }
        if (this.getUserSuppliedPhExample() != null) {
            commandText.append(" phex=\"").append(this.getUserSuppliedPhExample()).append('\"');
        }
        return commandText.toString();
    }

    @Override
    public CallBasicNode copy(CopyState copyState) {
        return new CallBasicNode(this, copyState);
    }
}

