/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.MixinParentNode;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

abstract class AbstractParentCommandNode<N extends SoyNode>
extends AbstractCommandNode
implements SoyNode.ParentSoyNode<N> {
    private final MixinParentNode<N> parentMixin;

    public AbstractParentCommandNode(int id, SourceLocation sourceLocation, String commandName) {
        super(id, sourceLocation, commandName);
        this.parentMixin = new MixinParentNode(this);
    }

    protected AbstractParentCommandNode(AbstractParentCommandNode<N> orig, CopyState copyState) {
        super(orig, copyState);
        this.parentMixin = new MixinParentNode<N>(orig.parentMixin, this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        sb.append("{/").append(this.getCommandName()).append('}');
        return sb.toString();
    }

    @Override
    public int numChildren() {
        return this.parentMixin.numChildren();
    }

    @Override
    public N getChild(int index) {
        return (N)((SoyNode)this.parentMixin.getChild(index));
    }

    @Override
    public int getChildIndex(Node child) {
        return this.parentMixin.getChildIndex(child);
    }

    @Override
    public List<N> getChildren() {
        return this.parentMixin.getChildren();
    }

    @Override
    public void addChild(N child) {
        this.parentMixin.addChild(child);
    }

    @Override
    public void addChild(int index, N child) {
        this.parentMixin.addChild(index, child);
    }

    @Override
    public void removeChild(int index) {
        this.parentMixin.removeChild(index);
    }

    @Override
    public void removeChild(N child) {
        this.parentMixin.removeChild(child);
    }

    @Override
    public void replaceChild(int index, N newChild) {
        this.parentMixin.replaceChild(index, (int)newChild);
    }

    @Override
    public void replaceChild(N currChild, N newChild) {
        this.parentMixin.replaceChild(currChild, newChild);
    }

    @Override
    public void clearChildren() {
        this.parentMixin.clearChildren();
    }

    @Override
    public void addChildren(List<? extends N> children) {
        this.parentMixin.addChildren(children);
    }

    @Override
    public void addChildren(int index, List<? extends N> children) {
        this.parentMixin.addChildren(index, children);
    }

    @Override
    public void appendSourceStringForChildren(StringBuilder sb) {
        this.parentMixin.appendSourceStringForChildren(sb);
    }

    @Nullable
    public SoyNode firstChildThatMatches(Predicate<SoyNode> condition) {
        int firstChildIndex;
        for (firstChildIndex = 0; firstChildIndex < this.numChildren() && !condition.test((SoyNode)this.getChild(firstChildIndex)); ++firstChildIndex) {
        }
        if (firstChildIndex < this.numChildren()) {
            return this.getChild(firstChildIndex);
        }
        return null;
    }

    @Nullable
    public SoyNode lastChildThatMatches(Predicate<SoyNode> condition) {
        int lastChildIndex;
        for (lastChildIndex = this.numChildren() - 1; lastChildIndex >= 0 && !condition.test((SoyNode)this.getChild(lastChildIndex)); --lastChildIndex) {
        }
        if (lastChildIndex >= 0) {
            return this.getChild(lastChildIndex);
        }
        return null;
    }
}

