/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.TofuPluginContext;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.sharedpasses.render.TofuValueFactory;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class EvalVisitor
extends AbstractReturningExprNodeVisitor<SoyValue> {
    private final Environment env;
    @Nullable
    private final SoyRecord ijData;
    @Nullable
    private final SoyMsgBundle msgBundle;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final boolean debugSoyTemplateInfo;
    private final TofuPluginContext context;
    private final ImmutableMap<String, Supplier<Object>> pluginInstances;

    protected EvalVisitor(Environment env, @Nullable SoyRecord ijData, @Nullable SoyCssRenamingMap cssRenamingMap, @Nullable SoyIdRenamingMap xidRenamingMap, @Nullable SoyMsgBundle msgBundle, boolean debugSoyTemplateInfo, ImmutableMap<String, Supplier<Object>> pluginInstances) {
        this.env = (Environment)Preconditions.checkNotNull((Object)env);
        this.ijData = ijData;
        this.msgBundle = msgBundle;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
        this.context = new TofuPluginContext(msgBundle);
        this.pluginInstances = (ImmutableMap)Preconditions.checkNotNull(pluginInstances);
    }

    @Override
    protected SoyValue visitExprRootNode(ExprRootNode node) {
        return (SoyValue)this.visit(node.getRoot());
    }

    @Override
    protected SoyValue visitNullNode(NullNode node) {
        return NullData.INSTANCE;
    }

    @Override
    protected SoyValue visitBooleanNode(BooleanNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitIntegerNode(IntegerNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitFloatNode(FloatNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitStringNode(StringNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitGlobalNode(GlobalNode node) {
        return (SoyValue)this.visit(node.getValue());
    }

    @Override
    protected SoyValue visitListLiteralNode(ListLiteralNode node) {
        List values = this.visitChildren(node);
        return ListImpl.forProviderList(values);
    }

    @Override
    protected SoyValue visitRecordLiteralNode(RecordLiteralNode node) {
        int numItems = node.numChildren();
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < numItems; ++i) {
            map.put(node.getKey(i).identifier(), this.visit(node.getChild(i)));
        }
        return DictImpl.forProviderMap(map, RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD);
    }

    @Override
    protected SoyValue visitMapLiteralNode(MapLiteralNode node) {
        int numItems = node.numChildren() / 2;
        HashMap<SoyValue, SoyValue> map = new HashMap<SoyValue, SoyValue>();
        for (int i = 0; i < numItems; ++i) {
            SoyValue key = (SoyValue)this.visit(node.getChild(2 * i));
            SoyValue value = (SoyValue)this.visit(node.getChild(2 * i + 1));
            if (EvalVisitor.isNullOrUndefinedBase(key)) {
                throw RenderException.create(String.format("null key in entry: null=%s", value));
            }
            map.put(key, value);
        }
        return SoyMapImpl.forProviderMap(map);
    }

    @Override
    protected SoyValue visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected SoyValue visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private SoyValue visitNullSafeNode(ExprNode node) {
        SoyValue value = this.visitNullSafeNodeRecurse(node);
        if (value == NullSafetySentinel.INSTANCE) {
            return NullData.INSTANCE;
        }
        return value;
    }

    private SoyValue visitNullSafeNodeRecurse(ExprNode node) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                return this.visitNullSafeVarRefNode((VarRefNode)node);
            }
            case FIELD_ACCESS_NODE: {
                return this.visitNullSafeFieldAccessNode((FieldAccessNode)node);
            }
            case ITEM_ACCESS_NODE: {
                return this.visitNullSafeItemAccessNode((ItemAccessNode)node);
            }
        }
        return (SoyValue)this.visit(node);
    }

    private SoyValue visitNullSafeVarRefNode(VarRefNode varRef) {
        SoyValue result = null;
        if (varRef.isDollarSignIjParameter()) {
            if (this.ijData == null) {
                throw RenderException.create("Injected data not provided, yet referenced (" + varRef.toSourceString() + ").");
            }
        } else {
            if (varRef.getDefnDecl().kind() == VarDefn.Kind.STATE) {
                TemplateStateVar state = (TemplateStateVar)varRef.getDefnDecl();
                return (SoyValue)this.visit(state.defaultValue());
            }
            return this.env.getVar(varRef.getDefnDecl());
        }
        result = this.ijData.getField(varRef.getName());
        return result != null ? result : UndefinedData.INSTANCE;
    }

    private SoyValue visitNullSafeFieldAccessNode(FieldAccessNode fieldAccess) {
        SoyValue base = this.visitNullSafeNodeRecurse(fieldAccess.getBaseExprChild());
        if (!(base instanceof SoyRecord) && !(base instanceof SoyProtoValue)) {
            if (base == NullSafetySentinel.INSTANCE) {
                return NullSafetySentinel.INSTANCE;
            }
            if (fieldAccess.isNullSafe()) {
                if (EvalVisitor.isNullOrUndefinedBase(base)) {
                    return NullSafetySentinel.INSTANCE;
                }
                throw RenderException.create(String.format("While evaluating \"%s\", encountered non-record just before accessing \"%s\".", fieldAccess.toSourceString(), fieldAccess.getSourceStringSuffix()));
            }
            return UndefinedData.INSTANCE;
        }
        if (EvalVisitor.isProtoOrUnionOfProtos(fieldAccess.getBaseExprChild().getType())) {
            return ((SoyProtoValue)base).getProtoField(fieldAccess.getFieldName());
        }
        EvalVisitor.maybeMarkBadProtoAccess(fieldAccess, base);
        SoyValue value = ((SoyRecord)base).getField(fieldAccess.getFieldName());
        if (value != null && !TofuTypeChecks.isInstance(fieldAccess.getType(), value, fieldAccess.getSourceLocation())) {
            throw RenderException.create(String.format("Expected value of type '%s', but actual type was '%s'.", fieldAccess.getType(), value.getClass().getSimpleName()));
        }
        return value != null ? value : UndefinedData.INSTANCE;
    }

    private static boolean isProtoOrUnionOfProtos(SoyType type) {
        if (type.getKind() == SoyType.Kind.PROTO) {
            return true;
        }
        if (type.getKind() == SoyType.Kind.UNION) {
            for (SoyType memberType : ((UnionType)type).getMembers()) {
                if (memberType.getKind() == SoyType.Kind.PROTO || memberType.getKind() == SoyType.Kind.NULL) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private SoyValue visitNullSafeItemAccessNode(ItemAccessNode itemAccess) {
        SoyValue value;
        SoyValue base = this.visitNullSafeNodeRecurse(itemAccess.getBaseExprChild());
        if (!(base instanceof SoyLegacyObjectMap) && !(base instanceof SoyMap)) {
            if (base == NullSafetySentinel.INSTANCE) {
                return NullSafetySentinel.INSTANCE;
            }
            if (itemAccess.isNullSafe()) {
                if (EvalVisitor.isNullOrUndefinedBase(base)) {
                    return NullSafetySentinel.INSTANCE;
                }
                throw RenderException.create(String.format("While evaluating \"%s\", encountered non-map/list just before accessing \"%s\".", itemAccess.toSourceString(), itemAccess.getSourceStringSuffix()));
            }
            return UndefinedData.INSTANCE;
        }
        EvalVisitor.maybeMarkBadProtoAccess(itemAccess, base);
        SoyValue key = (SoyValue)this.visit(itemAccess.getKeyExprChild());
        SoyType baseType = SoyTypes.tryRemoveNull(itemAccess.getBaseExprChild().getType());
        boolean shouldUseNewMap = MapType.ANY_MAP.isAssignableFrom(baseType);
        SoyValue soyValue = value = shouldUseNewMap ? ((SoyMap)base).get(key) : ((SoyLegacyObjectMap)base).getItem(key);
        if (value != null && !TofuTypeChecks.isInstance(itemAccess.getType(), value, itemAccess.getSourceLocation())) {
            throw RenderException.create(String.format("Expected value of type '%s', but actual type was '%s'.", itemAccess.getType(), value.getClass().getSimpleName()));
        }
        if (value != null) {
            return value;
        }
        if (shouldUseNewMap) {
            return NullData.INSTANCE;
        }
        return UndefinedData.INSTANCE;
    }

    private static void maybeMarkBadProtoAccess(ExprNode expr, SoyValue value) {
        if (value instanceof SoyProtoValue) {
            ((SoyProtoValue)value).setAccessLocationKey(expr.getSourceLocation());
        }
    }

    private static boolean isNullOrUndefinedBase(SoyValue base) {
        return base == null || base instanceof NullData || base instanceof UndefinedData || base == NullSafetySentinel.INSTANCE;
    }

    @Override
    protected SoyValue visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        return SharedRuntime.negative((SoyValue)this.visit(node.getChild(0)));
    }

    @Override
    protected SoyValue visitNotOpNode(OperatorNodes.NotOpNode node) {
        SoyValue operand = (SoyValue)this.visit(node.getChild(0));
        return this.convertResult(!operand.coerceToBoolean());
    }

    @Override
    protected SoyValue visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        return SharedRuntime.times((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        return FloatData.forValue(SharedRuntime.dividedBy((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitModOpNode(OperatorNodes.ModOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand0.longValue() % operand1.longValue());
    }

    @Override
    protected SoyValue visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        return SharedRuntime.plus((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        return SharedRuntime.minus((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThan((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThan((SoyValue)this.visit(node.getChild(1)), (SoyValue)this.visit(node.getChild(0))));
    }

    @Override
    protected SoyValue visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThanOrEqual((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThanOrEqual((SoyValue)this.visit(node.getChild(1)), (SoyValue)this.visit(node.getChild(0))));
    }

    @Override
    protected SoyValue visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.convertResult(SharedRuntime.equal((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return this.convertResult(!SharedRuntime.equal((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitAndOpNode(OperatorNodes.AndOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (!operand0.coerceToBoolean()) {
            return this.convertResult(false);
        }
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand1.coerceToBoolean());
    }

    @Override
    protected SoyValue visitOrOpNode(OperatorNodes.OrOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0.coerceToBoolean()) {
            return this.convertResult(true);
        }
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand1.coerceToBoolean());
    }

    @Override
    protected SoyValue visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0.coerceToBoolean()) {
            return (SoyValue)this.visit(node.getChild(1));
        }
        return (SoyValue)this.visit(node.getChild(2));
    }

    @Override
    protected SoyValue visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0 instanceof NullData || operand0 instanceof UndefinedData) {
            return (SoyValue)this.visit(node.getChild(1));
        }
        return operand0;
    }

    @Override
    protected SoyValue visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            BuiltinFunction nonpluginFn = (BuiltinFunction)soyFunction;
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node.getChild(0));
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    return this.visitIsPrimaryMsgInUseFunction(node);
                }
                case V1_EXPRESSION: {
                    throw new UnsupportedOperationException("the v1Expression function can't be used in templates compiled to Java");
                }
                case TO_FLOAT: {
                    return this.visitToFloatFunction(node);
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    return BooleanData.forValue(this.debugSoyTemplateInfo);
                }
                case VE_DATA: {
                    return NullData.INSTANCE;
                }
                case MSG_WITH_ID: 
                case REMAINDER: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof SoyJavaFunction) {
            List<SoyValue> args = this.visitChildren(node);
            SoyJavaFunction fn = (SoyJavaFunction)soyFunction;
            return this.computeFunctionHelper(fn, args, node);
        }
        if (soyFunction instanceof SoyJavaSourceFunction) {
            List<SoyValue> args = this.visitChildren(node);
            SoyJavaSourceFunction fn = (SoyJavaSourceFunction)soyFunction;
            return this.computeFunctionHelper(fn, args, node);
        }
        if (soyFunction instanceof LoggingFunction) {
            return StringData.forValue(((LoggingFunction)soyFunction).getPlaceholder());
        }
        throw RenderException.create("Failed to find Soy function with name '" + node.getFunctionName() + "' (function call \"" + node.toSourceString() + "\").");
    }

    @Override
    protected SoyValue visitProtoInitNode(ProtoInitNode node) {
        SoyProtoType soyProto = (SoyProtoType)node.getType();
        ImmutableList<Identifier> paramNames = node.getParamNames();
        SoyProtoValue.Builder builder = new SoyProtoValue.Builder(soyProto.getDescriptor());
        for (int i = 0; i < node.numChildren(); ++i) {
            SoyValue visit = (SoyValue)this.visit(node.getChild(i));
            if (visit instanceof NullData || visit instanceof UndefinedData) continue;
            builder.setField(((Identifier)paramNames.get(i)).identifier(), visit);
        }
        return builder.build();
    }

    private SoyValue visitCheckNotNullFunction(ExprNode child) {
        SoyValue childValue = (SoyValue)this.visit(child);
        if (childValue instanceof NullData || childValue instanceof UndefinedData) {
            throw new SoyDataException(child.toSourceString() + " is null");
        }
        return childValue;
    }

    @ForOverride
    protected SoyValue computeFunctionHelper(SoyJavaFunction fn, List<SoyValue> args, FunctionNode fnNode) {
        try {
            return fn.computeForJava(args);
        }
        catch (Exception e) {
            throw RenderException.create("While computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage(), e);
        }
    }

    @ForOverride
    protected SoyValue computeFunctionHelper(SoyJavaSourceFunction fn, List<SoyValue> args, FunctionNode fnNode) {
        try {
            return new TofuValueFactory(fnNode, this.pluginInstances).computeForJava(fn, args, this.context);
        }
        catch (Exception e) {
            throw RenderException.create("While computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage(), e);
        }
    }

    private SoyValue visitIsFirstFunction(FunctionNode node) {
        int localVarIndex;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            localVarIndex = this.env.getIndex((LoopVar)dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(localVarIndex == 0);
    }

    private SoyValue visitIsLastFunction(FunctionNode node) {
        boolean isLast;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            isLast = this.env.isLast((LoopVar)dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(isLast);
    }

    private SoyValue visitIndexFunction(FunctionNode node) {
        int localVarIndex;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            localVarIndex = this.env.getIndex((LoopVar)dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(localVarIndex);
    }

    private SoyValue visitCssFunction(FunctionNode node) {
        List children = this.visitChildren(node);
        String selector = ((SoyValue)Iterables.getLast(children)).stringValue();
        String renamedSelector = this.cssRenamingMap.get(selector);
        if (renamedSelector == null) {
            renamedSelector = selector;
        }
        if (node.numChildren() == 1) {
            return StringData.forValue(renamedSelector);
        }
        String fullSelector = ((SoyValue)children.get(0)).stringValue() + "-" + renamedSelector;
        return StringData.forValue(fullSelector);
    }

    private SoyValue visitXidFunction(FunctionNode node) {
        String xid = ((SoyValue)this.visit(node.getChild(0))).stringValue();
        String renamed = this.xidRenamingMap.get(xid);
        return renamed != null ? StringData.forValue(renamed) : StringData.forValue(xid + "_");
    }

    private SoyValue visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        if (this.msgBundle == null) {
            return BooleanData.TRUE;
        }
        long primaryMsgId = ((IntegerNode)node.getChild(1)).getValue();
        if (!this.msgBundle.getMsgParts(primaryMsgId).isEmpty()) {
            return BooleanData.TRUE;
        }
        long fallbackMsgId = ((IntegerNode)node.getChild(2)).getValue();
        return BooleanData.forValue(this.msgBundle.getMsgParts(fallbackMsgId).isEmpty());
    }

    private SoyValue visitToFloatFunction(FunctionNode node) {
        IntegerData v = (IntegerData)this.visit(node.getChild(0));
        return FloatData.forValue(v.longValue());
    }

    @Override
    protected SoyValue visitVeLiteralNode(VeLiteralNode node) {
        return NullData.INSTANCE;
    }

    private SoyValue convertResult(boolean b) {
        return BooleanData.forValue(b);
    }

    private SoyValue convertResult(long i) {
        return IntegerData.forValue(i);
    }

    private SoyValue convertResult(double f) {
        return FloatData.forValue(f);
    }

    private SoyValue convertResult(String s) {
        return StringData.forValue(s);
    }

    private static final class NullSafetySentinel
    extends SoyAbstractValue {
        public static final NullSafetySentinel INSTANCE = new NullSafetySentinel();

        private NullSafetySentinel() {
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean coerceToBoolean() {
            return false;
        }

        @Override
        public String coerceToString() {
            return "null";
        }

        @Override
        public void render(LoggingAdvisingAppendable appendable) throws IOException {
            appendable.append(this.coerceToString());
        }
    }

    public static interface EvalVisitorFactory {
        public EvalVisitor create(Environment var1, @Nullable SoyRecord var2, @Nullable SoyCssRenamingMap var3, @Nullable SoyIdRenamingMap var4, @Nullable SoyMsgBundle var5, boolean var6, ImmutableMap<String, Supplier<Object>> var7);
    }
}

