/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.internal.SoySimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.inject.Singleton;

public final class SharedModule
extends AbstractModule {
    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), SoyFunction.class);
        Multibinder.newSetBinder((Binder)this.binder(), SoyPrintDirective.class);
        this.bind(SoyScopedData.class).toInstance((Object)new SoySimpleScope());
    }

    @Provides
    @ApiCallScopeBindingAnnotations.LocaleString
    String provideLocaleString(SoyScopedData data) {
        return data.getLocale();
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyFunction> provideSoyFunctionsMap(Set<SoyFunction> soyFunctionsSet) {
        LinkedHashMap<String, SoyFunction> mapBuilder = new LinkedHashMap<String, SoyFunction>();
        for (SoyFunction function : soyFunctionsSet) {
            SoyFunction old = mapBuilder.put(function.getName(), function);
            if (old == null || old.getClass().getName().equals(function.getClass().getName())) continue;
            throw new IllegalStateException("Found two functions with the same name: '" + function.getName() + "' and different implementations: " + function + " vs " + old);
        }
        return ImmutableMap.copyOf(mapBuilder);
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyPrintDirective> provideSoyDirectivesMap(Set<SoyPrintDirective> soyDirectivesSet) {
        LinkedHashMap<String, SoyPrintDirective> mapBuilder = new LinkedHashMap<String, SoyPrintDirective>();
        for (SoyPrintDirective directive : soyDirectivesSet) {
            SoyPrintDirective old = mapBuilder.put(directive.getName(), directive);
            if (old == null || old.getClass().getName().equals(directive.getClass().getName())) continue;
            throw new IllegalStateException("Found two print directives with the same name: '" + directive.getName() + "' and different implementations: " + directive + " vs " + old);
        }
        return ImmutableMap.copyOf(mapBuilder);
    }

    public boolean equals(Object other) {
        return other != null && ((Object)((Object)this)).getClass().equals(other.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

