/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public class HtmlMatcherTagNode
extends HtmlMatcherGraphNode {
    private final HtmlTagNode htmlTagNode;
    @Nullable
    private HtmlMatcherGraphNode nextNode = null;

    public HtmlMatcherTagNode(SoyNode htmlTagNode) {
        Preconditions.checkState((boolean)(htmlTagNode instanceof HtmlTagNode), (Object)"HtmlMatcherCondition nodes must be constructed with an HtmlTagNode.");
        this.htmlTagNode = (HtmlTagNode)htmlTagNode;
    }

    public TagKind getTagKind() {
        if (this.htmlTagNode instanceof HtmlOpenTagNode) {
            HtmlOpenTagNode openTagNode = (HtmlOpenTagNode)this.htmlTagNode;
            if (openTagNode.isSelfClosing() || openTagNode.getTagName().isDefinitelyVoid()) {
                return TagKind.VOID_TAG;
            }
            return TagKind.OPEN_TAG;
        }
        return TagKind.CLOSE_TAG;
    }

    @Override
    public Optional<SoyNode> getSoyNode() {
        return Optional.of((Object)this.htmlTagNode);
    }

    @Override
    public Optional<HtmlMatcherGraphNode> getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        if (edgeKind == HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE) {
            return Optional.fromNullable((Object)this.nextNode);
        }
        return Optional.absent();
    }

    @Override
    public void setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        throw new UnsupportedOperationException("Cannot set the edge kind of a Tag node.");
    }

    @Override
    public void linkEdgeToNode(HtmlMatcherGraphNode.EdgeKind edgeKind, HtmlMatcherGraphNode node) {
        Preconditions.checkState((edgeKind == HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE ? 1 : 0) != 0, (Object)"HTML Tag nodes only have a true branch.");
        Preconditions.checkState((!this.equals(node) ? 1 : 0) != 0, (Object)"Can't link a node to itsself.");
        this.nextNode = node;
    }

    public static enum TagKind {
        OPEN_TAG,
        CLOSE_TAG,
        VOID_TAG;

    }
}

