/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import java.util.ArrayDeque;

public final class HtmlMatcherGraph {
    private Optional<HtmlMatcherGraphNode> rootNode = Optional.absent();
    private Optional<HtmlMatcherGraphNode> graphCursor = Optional.absent();
    private final ArrayDeque<Optional<HtmlMatcherGraphNode>> cursorStack = new ArrayDeque();

    public Optional<HtmlMatcherGraphNode> getRootNode() {
        return this.rootNode;
    }

    public Optional<HtmlMatcherGraphNode> getNodeAtCursor() {
        return this.graphCursor;
    }

    public void saveCursor() {
        this.cursorStack.push(this.graphCursor);
    }

    public void restoreCursor() {
        Preconditions.checkState((!this.cursorStack.isEmpty() ? 1 : 0) != 0, (Object)"Cursor stack underflow: restoreCursor() without matching saveCursor() call.");
        this.graphCursor = this.cursorStack.pop();
    }

    public void addNode(HtmlMatcherGraphNode node) {
        Preconditions.checkNotNull((Object)node);
        if (this.graphCursor.isPresent()) {
            ((HtmlMatcherGraphNode)this.graphCursor.get()).linkActiveEdgeToNode(node);
        }
        this.setGraphCursorNode(node);
    }

    private void setGraphCursorNode(HtmlMatcherGraphNode node) {
        this.graphCursor = Optional.of((Object)node);
        if (!this.rootNode.isPresent()) {
            this.rootNode = this.graphCursor;
        }
    }
}

