/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.ast.TypeNodeConverter;

public final class ResolveTemplateParamTypesPass
extends CompilerFilePass {
    private final TypeNodeConverter converter;

    ResolveTemplateParamTypesPass(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter) {
        this.converter = new TypeNodeConverter(errorReporter, typeRegistry);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            for (TemplateParam param : template.getAllParams()) {
                if (param.getTypeNode() == null) continue;
                param.setType(this.converter.getOrCreateType(param.getTypeNode()));
            }
            if (!(template instanceof TemplateElementNode)) continue;
            for (TemplateStateVar state : ((TemplateElementNode)template).getStateVars()) {
                if (state.getTypeNode() == null) continue;
                state.setType(this.converter.getOrCreateType(state.getTypeNode()));
            }
        }
    }
}

