/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;

final class ResolvePluginsPass
extends CompilerFilePass {
    private final PluginResolver resolver;
    private final SoyTypeRegistry typeRegistry;

    ResolvePluginsPass(PluginResolver resolver, SoyTypeRegistry typeRegistry) {
        this.resolver = resolver;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(file, FunctionNode.class)) {
            String name;
            String resolvedName;
            SoyType type;
            if (function.numChildren() == 0 && (type = this.typeRegistry.getType(resolvedName = file.resolveAlias(name = function.getFunctionName()))) != null && type.getKind() == SoyType.Kind.PROTO) {
                ProtoInitNode protoInit = new ProtoInitNode(resolvedName, (Iterable<Identifier>)ImmutableList.of(), function.getSourceLocation());
                function.getParent().replaceChild(function, protoInit);
                continue;
            }
            function.setSoyFunction(this.resolver.lookupSoyFunction(function.getFunctionName(), function.numChildren(), function.getSourceLocation()));
        }
        for (PrintDirectiveNode directive : SoyTreeUtils.getAllNodesOfType(file, PrintDirectiveNode.class)) {
            directive.setPrintDirective(this.resolver.lookupPrintDirective(directive.getName(), directive.getExprList().size(), directive.getSourceLocation()));
        }
    }
}

