/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basicfunctions.AugmentMapFunction;
import com.google.template.soy.basicfunctions.ConcatListsFunction;
import com.google.template.soy.basicfunctions.KeysFunction;
import com.google.template.soy.basicfunctions.LegacyObjectMapToMapFunction;
import com.google.template.soy.basicfunctions.MapKeysFunction;
import com.google.template.soy.basicfunctions.MapToLegacyObjectMapFunction;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.ResolvedSignature;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.ErrorType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import com.google.template.soy.types.VeType;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class ResolveExpressionTypesPass
extends CompilerFilePass {
    private static final SoyErrorKind BAD_FOREACH_TYPE = SoyErrorKind.of("Cannot iterate over {0} of type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_INDEX_TYPE = SoyErrorKind.of("Bad index type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_KEY_TYPE = SoyErrorKind.of("Bad key type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support bracket access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NULLABLE_UNION = SoyErrorKind.of("Union type that is nullable cannot use bracket access. To access this value, first check for null or use null-safe (\"?[\") operations.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CHECK_NOT_NULL_ON_COMPILE_TIME_NULL = SoyErrorKind.of("Cannot call checkNotNull on a parameter with a static type of ''null''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support dot access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD = SoyErrorKind.of("Type {0} does not support dot access (consider record instead of map).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Map literals with duplicate keys are not allowed.  Duplicate key: ''{0}''", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind KEYS_PASSED_MAP = SoyErrorKind.of("Use the ''mapKeys'' function instead of ''keys'' for objects of type ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_MAP_RESOLVED_KEY_TYPE = SoyErrorKind.of("A map''s keys must all be the same type. This map has keys of multiple types (''{0}'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_ACCESS = SoyErrorKind.of("Accessing item in empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_FOREACH = SoyErrorKind.of("Cannot iterate over empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_MAP_ACCESS = SoyErrorKind.of("Accessing item in empty map.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TYPE_SUBSTITUTION = SoyErrorKind.of("Expected expression of type ''{0}'', found ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LIST_LENGTH_ERROR = SoyErrorKind.of("Soy lists do not have a ''length'' field. Use function length(...) instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for node {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_A_PROTO_TYPE = SoyErrorKind.of("''{0}'' is a ''{1}'', expected a protocol buffer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OR_OPERATOR_HAS_CONSTANT_OPERAND = SoyErrorKind.of("Constant operand ''{0}'' used with ''or'' operator. Consider simplifying or using the ?: operator, see go/soy/reference/expressions.md#logical-operators", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind STRING_LENGTH_ERROR = SoyErrorKind.of("Soy strings do not have a ''length'' field. Use function strLen(...) instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_PROTO_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for proto type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_RECORD_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for record type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNKNOWN_PROTO_TYPE = SoyErrorKind.of("Unknown proto type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_FIELD_DOES_NOT_EXIST = SoyErrorKind.of("Proto field ''{0}'' does not exist.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PROTO_MISSING_REQUIRED_FIELD = SoyErrorKind.of("Missing required proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_NULL_ARG_TYPE = SoyErrorKind.of("Cannot assign static type ''null'' to proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TYPE_MISMATCH = SoyErrorKind.of("Soy types ''{0}'' and ''{1}'' are not comparable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TYPE_MISMATCH_STATE = SoyErrorKind.of("The initializer for ''{0}'' has type ''{1}'' which is not assignable to type ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_MUST_BE_CONSTANT = SoyErrorKind.of("The initializer for ''{0}'' must be a constant value.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_ARITHMETIC_OP = SoyErrorKind.of("Using arithmetic operators on Soy types ''{0}'' and ''{1}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_ARITHMETIC_OP_UNARY = SoyErrorKind.of("Using arithmetic operators on the Soy type ''{0}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCORRECT_ARG_TYPE = SoyErrorKind.of("Function ''{0}'' called with incorrect arg type {1} (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LOOP_VARIABLE_NOT_IN_SCOPE = SoyErrorKind.of("Function ''{0}'' must have a loop variable as its argument.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRING_LITERAL_REQUIRED = SoyErrorKind.of("Argument to function ''{0}'' must be a string literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPLICIT_NULL = SoyErrorKind.of("Explicit use of the ''null'' type is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INFERRED_NULL = SoyErrorKind.of("The inferred type of this parameter is ''null'' which is not a useful type. Use an explicit type declaration to specify a wider type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPLICIT_TYPE_SAME_AS_INFERRED = SoyErrorKind.of("The inferred type of this parameter is the same as the declared type, use the '':='' syntax to use the inferred type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VE_NO_CONFIG_FOR_ELEMENT = SoyErrorKind.of("Could not find logging configuration for this element.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;
    private final SoyTypeRegistry typeRegistry;
    private final ValidatedLoggingConfig loggingConfig;
    private final TypeNodeConverter typeNodeConverter;
    private final Map<Signature, ResolvedSignature> signatureMap = new HashMap<Signature, ResolvedSignature>();
    private TypeSubstitution substitutions;

    ResolveExpressionTypesPass(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter, ValidatedLoggingConfig loggingConfig) {
        this.errorReporter = errorReporter;
        this.typeRegistry = typeRegistry;
        this.loggingConfig = loggingConfig;
        this.typeNodeConverter = new TypeNodeConverter(errorReporter, typeRegistry);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        this.substitutions = null;
        new TypeAssignmentSoyVisitor().exec(file);
    }

    private void addTypeSubstitutions(Map<Equivalence.Wrapper<ExprNode>, SoyType> substitutionsToAdd) {
        for (Map.Entry<Equivalence.Wrapper<ExprNode>, SoyType> entry : substitutionsToAdd.entrySet()) {
            ExprNode expr = (ExprNode)entry.getKey().get();
            SoyType previousType = expr.getType();
            TypeSubstitution subst = this.substitutions;
            while (subst != null) {
                if (ExprEquivalence.get().equivalent(subst.expression, expr)) {
                    previousType = subst.type;
                    break;
                }
                subst = subst.parent;
            }
            if (entry.getValue().equals(previousType)) continue;
            this.substitutions = new TypeSubstitution(this.substitutions, expr, entry.getValue());
        }
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        ResolveTypesExprVisitor exprVisitor = new ResolveTypesExprVisitor();
        for (ExprRootNode expr : node.getExprList()) {
            exprVisitor.exec(expr);
        }
    }

    private SoyType getElementType(SoyType collectionType, ForNonemptyNode node) {
        Preconditions.checkNotNull((Object)collectionType);
        switch (collectionType.getKind()) {
            case UNKNOWN: {
                return UnknownType.getInstance();
            }
            case LIST: {
                if (collectionType == ListType.EMPTY_LIST) {
                    this.errorReporter.report(node.getParent().getSourceLocation(), EMPTY_LIST_FOREACH, new Object[0]);
                    return ErrorType.getInstance();
                }
                return ((ListType)collectionType).getElementType();
            }
            case UNION: {
                UnionType unionType = (UnionType)collectionType;
                ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                for (SoyType unionMember : unionType.getMembers()) {
                    SoyType elementType = this.getElementType(unionMember, node);
                    if (elementType.getKind() == SoyType.Kind.ERROR) {
                        return ErrorType.getInstance();
                    }
                    fieldTypes.add(elementType);
                }
                return SoyTypes.computeLowestCommonType(this.typeRegistry, fieldTypes);
            }
        }
        this.errorReporter.report(node.getParent().getSourceLocation(), BAD_FOREACH_TYPE, node.getExpr().toSourceString(), node.getExpr().getType());
        return ErrorType.getInstance();
    }

    private static final class TypeSubstitution {
        @Nullable
        final TypeSubstitution parent;
        final ExprNode expression;
        final SoyType type;

        TypeSubstitution(@Nullable TypeSubstitution parent, ExprNode expression, SoyType type) {
            this.parent = parent;
            this.expression = expression;
            this.type = type;
        }
    }

    private static enum UnknownPolicy {
        ALLOWED,
        DISALLOWED;

    }

    private final class TypeNarrowingConditionVisitor
    extends AbstractExprNodeVisitor<Void> {
        Map<Equivalence.Wrapper<ExprNode>, SoyType> positiveTypeConstraints = new LinkedHashMap<Equivalence.Wrapper<ExprNode>, SoyType>();
        Map<Equivalence.Wrapper<ExprNode>, SoyType> negativeTypeConstraints = new LinkedHashMap<Equivalence.Wrapper<ExprNode>, SoyType>();

        private TypeNarrowingConditionVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitAndImplicitlyCastToBoolean(node.getRoot());
        }

        void visitAndImplicitlyCastToBoolean(ExprNode node) {
            this.visit(node);
            Equivalence.Wrapper wrapped = ExprEquivalence.get().wrap(node);
            this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrapped, SoyTypes.tryRemoveNull(node.getType()));
            this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrapped, node.getType());
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            Preconditions.checkArgument((node.getChildren().size() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.positiveTypeConstraints.putAll(this.computeConstraintUnion(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints));
            this.negativeTypeConstraints.putAll(this.computeConstraintIntersection(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints));
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            Preconditions.checkArgument((node.getChildren().size() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.positiveTypeConstraints.putAll(this.computeConstraintIntersection(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints));
            this.negativeTypeConstraints.putAll(this.computeConstraintUnion(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints));
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            TypeNarrowingConditionVisitor childVisitor = new TypeNarrowingConditionVisitor();
            childVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            this.positiveTypeConstraints.putAll(childVisitor.negativeTypeConstraints);
            this.negativeTypeConstraints.putAll(childVisitor.positiveTypeConstraints);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(1));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
            }
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(1));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            }
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.numChildren() != 1) {
                return;
            }
            if (node.getFunctionName().equals("isNonnull")) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            } else if (node.getFunctionName().equals("isNull")) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        private <T> Map<T, SoyType> computeConstraintUnion(Map<T, SoyType> left, Map<T, SoyType> right) {
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
            LinkedHashMap<T, SoyType> result = new LinkedHashMap<T, SoyType>(left);
            for (Map.Entry<T, SoyType> entry : right.entrySet()) {
                if (left.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        private Map<Equivalence.Wrapper<ExprNode>, SoyType> computeConstraintIntersection(Map<Equivalence.Wrapper<ExprNode>, SoyType> left, Map<Equivalence.Wrapper<ExprNode>, SoyType> right) {
            if (left.isEmpty()) {
                return left;
            }
            if (right.isEmpty()) {
                return right;
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)left.size());
            for (Map.Entry<Equivalence.Wrapper<ExprNode>, SoyType> entry : left.entrySet()) {
                if (!right.containsKey(entry.getKey())) continue;
                SoyType rightSideType = right.get(entry.getKey());
                result.put(entry.getKey(), SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, entry.getValue(), rightSideType));
            }
            return result;
        }
    }

    private final class ResolveTypesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final AbstractExprNodeVisitor<Void> checkAllTypesAssignedVisitor = new AbstractExprNodeVisitor<Void>(){

            @Override
            protected void visitExprNode(ExprNode node) {
                if (node instanceof ExprNode.ParentExprNode) {
                    this.visitChildren((ExprNode.ParentExprNode)node);
                }
                ResolveTypesExprVisitor.this.requireNodeType(node);
            }
        };

        private ResolveTypesExprVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            this.checkAllTypesAssignedVisitor.exec(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
            ExprNode expr = node.getRoot();
            node.setType(expr.getType());
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
            ArrayList<SoyType> elementTypes = new ArrayList<SoyType>(node.getChildren().size());
            for (ExprNode child : node.getChildren()) {
                this.requireNodeType(child);
                elementTypes.add(child.getType());
            }
            if (elementTypes.isEmpty()) {
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, elementTypes)));
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitRecordLiteralNode(RecordLiteralNode node) {
            this.visitChildren(node);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren == node.getKeys().size() ? 1 : 0) != 0);
            if (numChildren == 0) {
                node.setType(RecordType.EMPTY_RECORD);
                return;
            }
            HashMap fieldTypes = Maps.newHashMapWithExpectedSize((int)numChildren);
            for (int i = 0; i < numChildren; ++i) {
                fieldTypes.put(node.getKey(i).identifier(), node.getChild(i).getType());
            }
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateRecordType(fieldTypes));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren % 2 == 0 ? 1 : 0) != 0);
            if (numChildren == 0) {
                node.setType(MapType.EMPTY_MAP);
                return;
            }
            HashSet<String> duplicateKeyErrors = new HashSet<String>();
            LinkedHashMap<String, SoyType> recordFieldTypes = new LinkedHashMap<String, SoyType>();
            ArrayList<SoyType> keyTypes = new ArrayList<SoyType>(numChildren / 2);
            ArrayList<SoyType> valueTypes = new ArrayList<SoyType>(numChildren / 2);
            ErrorReporter.Checkpoint checkpoint = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
            for (int i = 0; i < numChildren; i += 2) {
                String fieldName;
                SoyType prev;
                ExprNode key = node.getChild(i);
                ExprNode value = node.getChild(i + 1);
                if (key.getKind() == ExprNode.Kind.STRING_NODE && (prev = recordFieldTypes.put(fieldName = ((StringNode)key).getValue(), value.getType())) != null && duplicateKeyErrors.add(fieldName)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(key.getSourceLocation(), DUPLICATE_KEY_IN_MAP_LITERAL, fieldName);
                }
                keyTypes.add(key.getType());
                if (!MapType.isAllowedKeyType(key.getType())) {
                    ResolveExpressionTypesPass.this.errorReporter.report(key.getSourceLocation(), MapType.BAD_MAP_KEY_TYPE, key.getType());
                }
                valueTypes.add(value.getType());
            }
            SoyType commonKeyType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, keyTypes);
            if (!ResolveExpressionTypesPass.this.errorReporter.errorsSince(checkpoint) && !MapType.isAllowedKeyType(commonKeyType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), ILLEGAL_MAP_RESOLVED_KEY_TYPE, commonKeyType);
            }
            SoyType commonValueType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, valueTypes);
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(commonKeyType, commonValueType));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            SoyType newType = this.getTypeSubstitution(varRef);
            if (newType != null) {
                varRef.setSubstituteType(newType);
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            this.visit(node.getBaseExprChild());
            node.setType(this.getFieldType(node.getBaseExprChild().getType(), node.getFieldName(), node.getSourceLocation()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitItemAccessNode(ItemAccessNode node) {
            this.visit(node.getBaseExprChild());
            this.visit(node.getKeyExprChild());
            SoyType itemType = this.getItemType(node.getBaseExprChild().getType(), node.getKeyExprChild().getType(), node.isNullSafe(), node.getSourceLocation(), node.getKeyExprChild().getSourceLocation());
            node.setType(itemType);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
        }

        @Override
        protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            this.visitChildren(node);
            SoyType childType = node.getChild(0).getType();
            if (SoyTypes.isNumericOrUnknown(childType)) {
                node.setType(childType);
            } else {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), INCOMPATIBLE_ARITHMETIC_OP_UNARY, childType);
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            this.visitChildren(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitModOpNode(OperatorNodes.ModOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypePlusOperator());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), INCOMPATIBLE_ARITHMETIC_OP, left, right);
                result = UnknownType.getInstance();
            }
            node.setType(result);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            ExprNode lhs = node.getChild(0);
            if (SoyTreeUtils.isConstantExpr(lhs)) {
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getSourceLocation(), OR_OPERATOR_HAS_CONSTANT_OPERAND, lhs.toSourceString());
            }
            this.visit(lhs);
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            ExprNode rhs = node.getChild(1);
            this.visit(rhs);
            if (SoyTreeUtils.isConstantExpr(rhs)) {
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getSourceLocation(), OR_OPERATOR_HAS_CONSTANT_OPERAND, rhs.toSourceString());
            }
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getChild(0).getType(), node.getChild(1).getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(2));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getChild(1).getType(), node.getChild(2).getType()));
            this.tryApplySubstitution(node);
        }

        @Nullable
        private ResolvedSignature getOrCreateFunctionSignature(Signature signature, String className, ErrorReporter errorReporter) {
            ResolvedSignature resolvedSignature = (ResolvedSignature)ResolveExpressionTypesPass.this.signatureMap.get(signature);
            if (resolvedSignature != null) {
                return resolvedSignature;
            }
            ImmutableList.Builder paramTypes = ImmutableList.builder();
            for (String paramTypeString : signature.parameterTypes()) {
                TypeNode paramType = SoyFileParser.parseType(paramTypeString, className, errorReporter);
                if (paramType == null) {
                    return null;
                }
                paramTypes.add((Object)ResolveExpressionTypesPass.this.typeNodeConverter.getOrCreateType(paramType));
            }
            TypeNode returnType = SoyFileParser.parseType(signature.returnType(), className, errorReporter);
            if (returnType == null) {
                return null;
            }
            resolvedSignature = ResolvedSignature.create((ImmutableList<SoyType>)paramTypes.build(), ResolveExpressionTypesPass.this.typeNodeConverter.getOrCreateType(returnType));
            ResolveExpressionTypesPass.this.signatureMap.put(signature, resolvedSignature);
            return resolvedSignature;
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            this.visitChildren(node);
            Object knownFunction = node.getSoyFunction();
            if (knownFunction.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                Preconditions.checkState((knownFunction instanceof TypedSoyFunction || knownFunction instanceof SoySourceFunction ? 1 : 0) != 0, (Object)"Classes annotated with @SoyFunctionSignature must either extend TypedSoyFunction or implement SoySourceFunction.");
                this.visitSoyFunctionWithSignature(knownFunction.getClass().getAnnotation(SoyFunctionSignature.class), knownFunction.getClass().getCanonicalName(), node);
            } else if (knownFunction instanceof BuiltinFunction) {
                this.visitBuiltinFunction((BuiltinFunction)knownFunction, node);
            }
            this.visitInternalSoyFunction(knownFunction, node);
            this.tryApplySubstitution(node);
            if (node.getAllowedParamTypes() == null) {
                node.setAllowedParamTypes(Collections.nCopies(node.numChildren(), UnknownType.getInstance()));
            }
        }

        private void visitSoyFunctionWithSignature(SoyFunctionSignature fnSignature, String className, FunctionNode node) {
            ResolvedSignature matchedSignature = null;
            for (Signature signature : fnSignature.value()) {
                if (signature.parameterTypes().length != node.numChildren()) continue;
                matchedSignature = this.getOrCreateFunctionSignature(signature, className, ResolveExpressionTypesPass.this.errorReporter);
                break;
            }
            if (matchedSignature == null) {
                node.setType(UnknownType.getInstance());
                return;
            }
            for (int i = 0; i < node.numChildren(); ++i) {
                this.checkArgType(node.getChild(i), (SoyType)matchedSignature.parameterTypes().get(i), node);
            }
            node.setAllowedParamTypes((List<SoyType>)matchedSignature.parameterTypes());
            node.setType(matchedSignature.returnType());
        }

        private void visitKeysFunction(FunctionNode node) {
            ListType listType;
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(LegacyObjectMapType.EMPTY_MAP)) {
                listType = ListType.EMPTY_LIST;
            } else {
                SoyType listArg;
                if (argType.getKind() == SoyType.Kind.LEGACY_OBJECT_MAP) {
                    listArg = ((LegacyObjectMapType)argType).getKeyType();
                } else if (argType.getKind() == SoyType.Kind.LIST) {
                    listArg = IntType.getInstance();
                } else if (argType.getKind() == SoyType.Kind.MAP) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), KEYS_PASSED_MAP, new Object[0]);
                    listArg = ErrorType.getInstance();
                } else {
                    listArg = UnknownType.getInstance();
                }
                listType = ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(listArg);
            }
            node.setType(listType);
        }

        private void visitMapKeysFunction(FunctionNode node) {
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(MapType.EMPTY_MAP)) {
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(((MapType)argType).getKeyType()));
            }
        }

        private void visitLegacyObjectMapToMapFunction(FunctionNode node) {
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(LegacyObjectMapType.EMPTY_MAP)) {
                node.setType(MapType.EMPTY_MAP);
            } else if (argType.isAssignableFrom(UnknownType.getInstance())) {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(StringType.getInstance(), UnknownType.getInstance()));
            } else {
                LegacyObjectMapType actualArgType = (LegacyObjectMapType)argType;
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(StringType.getInstance(), actualArgType.getValueType()));
            }
        }

        private void visitMapToLegacyObjectMapFunction(FunctionNode node) {
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(MapType.EMPTY_MAP)) {
                node.setType(LegacyObjectMapType.EMPTY_MAP);
            } else {
                MapType actualArgType = (MapType)argType;
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateLegacyObjectMapType(StringType.getInstance(), actualArgType.getValueType()));
            }
        }

        private void visitAugmentMapFunction(FunctionNode node) {
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateLegacyObjectMapType(StringType.getInstance(), UnknownType.getInstance()));
        }

        @Override
        protected void visitProtoInitNode(ProtoInitNode node) {
            this.visitChildren(node);
            String protoName = node.getProtoName();
            SoyType type = ResolveExpressionTypesPass.this.typeRegistry.getType(protoName);
            if (type == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), UNKNOWN_PROTO_TYPE, protoName);
                node.setType(ErrorType.getInstance());
            } else if (type.getKind() != SoyType.Kind.PROTO) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), NOT_A_PROTO_TYPE, protoName, type);
                node.setType(ErrorType.getInstance());
            } else {
                node.setType(type);
                SoyProtoType protoType = (SoyProtoType)type;
                HashSet<String> givenParams = new HashSet<String>();
                for (Identifier id : node.getParamNames()) {
                    givenParams.add(id.identifier());
                }
                for (Descriptors.FieldDescriptor field : protoType.getDescriptor().getFields()) {
                    if (!field.isRequired() || givenParams.contains(field.getName())) continue;
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), PROTO_MISSING_REQUIRED_FIELD, field.getName());
                }
                ImmutableSet<String> fields = protoType.getFieldNames();
                for (int i = 0; i < node.numChildren(); ++i) {
                    SoyType expectedType;
                    SoyType argElementType;
                    Identifier fieldName = (Identifier)node.getParamNames().get(i);
                    ExprNode expr = node.getChild(i);
                    if (!fields.contains((Object)fieldName.identifier())) {
                        String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(fields, protoType.getDescriptor(), fieldName.identifier());
                        ResolveExpressionTypesPass.this.errorReporter.report(fieldName.location(), PROTO_FIELD_DOES_NOT_EXIST, fieldName.identifier(), extraErrorMessage);
                        continue;
                    }
                    SoyType argType = expr.getType();
                    if (argType.equals(NullType.getInstance())) {
                        ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), PROTO_NULL_ARG_TYPE, fieldName.identifier());
                    }
                    SoyType fieldType = protoType.getFieldType(fieldName.identifier());
                    if (argType.equals(UnknownType.getInstance()) || argType.equals(ErrorType.getInstance()) || fieldType.getKind() == SoyType.Kind.LIST && argType.getKind() == SoyType.Kind.LIST && ((argElementType = ((ListType)argType).getElementType()) == null || argElementType.equals(UnknownType.getInstance())) || (expectedType = SoyTypes.makeNullable(fieldType)).isAssignableFrom(argType)) continue;
                    ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), CheckTemplateCallsPass.ARGUMENT_TYPE_MISMATCH, fieldName.identifier(), expectedType, argType);
                }
            }
        }

        @Override
        protected void visitVeLiteralNode(VeLiteralNode node) {
            SoyType type;
            ValidatedLoggingConfig.ValidatedLoggableElement config = ResolveExpressionTypesPass.this.loggingConfig.getElement(node.getName().identifier());
            if (config == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getName().location(), VE_NO_CONFIG_FOR_ELEMENT, SoyErrors.getDidYouMeanMessage(ResolveExpressionTypesPass.this.loggingConfig.allKnownIdentifiers(), node.getName().identifier()));
                type = ErrorType.getInstance();
            } else {
                type = config.getProtoName().isPresent() ? ResolveExpressionTypesPass.this.typeRegistry.getOrCreateVeType((String)config.getProtoName().get()) : VeType.NO_DATA;
                node.setId(config.getId());
            }
            node.setType(type);
        }

        private void visitComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeComparisonOp());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitEqualComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeEqualComparisonOp());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitArithmeticOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            boolean isDivide = node instanceof OperatorNodes.DivideByOpNode;
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeArithmeticOperator());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), INCOMPATIBLE_ARITHMETIC_OP, left, right);
                result = UnknownType.getInstance();
            }
            node.setType(isDivide ? FloatType.getInstance() : result);
            this.tryApplySubstitution(node);
        }

        private void requireNodeType(ExprNode node) {
            if (node.getType() == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), MISSING_SOY_TYPE, node.getClass().getName());
            }
        }

        private SoyType getFieldType(SoyType baseType, String fieldName, SourceLocation sourceLocation) {
            Preconditions.checkNotNull((Object)baseType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case RECORD: {
                    RecordType recordType = (RecordType)baseType;
                    SoyType fieldType = recordType.getFieldType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessage(recordType.getFieldNames(), fieldName);
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_RECORD_TYPE, fieldName, baseType, extraErrorMessage);
                    return ErrorType.getInstance();
                }
                case PROTO: {
                    SoyProtoType protoType = (SoyProtoType)baseType;
                    SoyType fieldType = protoType.getFieldType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(protoType.getFieldNames(), protoType.getDescriptor(), fieldName);
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_PROTO_TYPE, fieldName, baseType, extraErrorMessage);
                    return ErrorType.getInstance();
                }
                case LEGACY_OBJECT_MAP: {
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD, baseType);
                    return ErrorType.getInstance();
                }
                case UNION: {
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.getKind() == SoyType.Kind.NULL) continue;
                        SoyType fieldType = this.getFieldType(unionMember, fieldName, sourceLocation);
                        if (fieldType == ErrorType.getInstance()) {
                            return fieldType;
                        }
                        fieldTypes.add(fieldType);
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, fieldTypes);
                }
                case ERROR: {
                    return ErrorType.getInstance();
                }
                case STRING: 
                case CSS: 
                case JS: 
                case ATTRIBUTES: 
                case HTML: 
                case URI: {
                    if (fieldName.equals("length")) {
                        ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, STRING_LENGTH_ERROR, new Object[0]);
                        return ErrorType.getInstance();
                    }
                }
                case LIST: {
                    if (fieldName.equals("length")) {
                        ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, LIST_LENGTH_ERROR, new Object[0]);
                        return ErrorType.getInstance();
                    }
                }
                case ANY: 
                case NULL: 
                case BOOL: 
                case INT: 
                case FLOAT: 
                case TRUSTED_RESOURCE_URI: 
                case MAP: 
                case PROTO_ENUM: 
                case VE: 
                case VE_DATA: {
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED, baseType);
                    return ErrorType.getInstance();
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + (Object)((Object)baseType.getKind())));
        }

        private SoyType getItemType(SoyType baseType, SoyType keyType, boolean isNullSafe, SourceLocation baseLocation, SourceLocation keyLocation) {
            Preconditions.checkNotNull((Object)baseType);
            Preconditions.checkNotNull((Object)keyType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case LIST: {
                    ListType listType = (ListType)baseType;
                    if (listType.equals(ListType.EMPTY_LIST)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, EMPTY_LIST_ACCESS, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    if (keyType.getKind() != SoyType.Kind.UNKNOWN && !IntType.getInstance().isAssignableFrom(keyType)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(keyLocation, BAD_INDEX_TYPE, keyType, baseType);
                    }
                    return listType.getElementType();
                }
                case LEGACY_OBJECT_MAP: 
                case MAP: {
                    AbstractMapType mapType = (AbstractMapType)baseType;
                    if (mapType.equals(LegacyObjectMapType.EMPTY_MAP) || mapType.equals(MapType.EMPTY_MAP)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, EMPTY_MAP_ACCESS, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    if (keyType.getKind() != SoyType.Kind.UNKNOWN && !mapType.getKeyType().isAssignableFrom(keyType)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(keyLocation, BAD_KEY_TYPE, keyType, baseType);
                    }
                    return mapType.getValueType();
                }
                case UNION: {
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> itemTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.equals(NullType.getInstance())) continue;
                        SoyType itemType = this.getItemType(unionMember, keyType, isNullSafe, baseLocation, keyLocation);
                        if (itemType == ErrorType.getInstance()) {
                            return itemType;
                        }
                        itemTypes.add(itemType);
                    }
                    if (unionType.isNullable() && !isNullSafe) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NULLABLE_UNION, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, itemTypes);
                }
                case ERROR: {
                    return ErrorType.getInstance();
                }
                case RECORD: 
                case PROTO: 
                case STRING: 
                case CSS: 
                case JS: 
                case ATTRIBUTES: 
                case HTML: 
                case URI: 
                case ANY: 
                case NULL: 
                case BOOL: 
                case INT: 
                case FLOAT: 
                case TRUSTED_RESOURCE_URI: 
                case PROTO_ENUM: 
                case VE: 
                case VE_DATA: {
                    ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NOT_SUPPORTED, baseType);
                    return ErrorType.getInstance();
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + (Object)((Object)baseType.getKind())));
        }

        private void tryApplySubstitution(AbstractParentExprNode parentNode) {
            SoyType newType = this.getTypeSubstitution(parentNode);
            if (newType != null) {
                if (!parentNode.getType().isAssignableFrom(newType)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(parentNode.getSourceLocation(), INVALID_TYPE_SUBSTITUTION, parentNode.getType(), newType);
                }
                parentNode.setType(newType);
            }
        }

        @Nullable
        private SoyType getTypeSubstitution(ExprNode expr) {
            TypeSubstitution subst = ResolveExpressionTypesPass.this.substitutions;
            while (subst != null) {
                if (ExprEquivalence.get().equivalent(subst.expression, expr)) {
                    return subst.type;
                }
                subst = subst.parent;
            }
            return null;
        }

        private void visitBuiltinFunction(BuiltinFunction builtinFunction, FunctionNode node) {
            switch (builtinFunction) {
                case CHECK_NOT_NULL: {
                    SoyType type = node.getChild(0).getType();
                    if (type.equals(NullType.getInstance())) {
                        ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, new Object[0]);
                        break;
                    }
                    node.setType(SoyTypes.removeNull(type));
                    break;
                }
                case INDEX: {
                    this.requireLoopVariableInScope(node, node.getChild(0));
                    node.setType(IntType.getInstance());
                    break;
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case IS_FIRST: 
                case IS_LAST: {
                    this.requireLoopVariableInScope(node, node.getChild(0));
                    node.setType(BoolType.getInstance());
                    break;
                }
                case CSS: {
                    this.checkArgIsStringLiteral(node.getChild(node.numChildren() - 1), "css");
                    node.setType(StringType.getInstance());
                    break;
                }
                case XID: {
                    node.setType(StringType.getInstance());
                    break;
                }
                case V1_EXPRESSION: {
                    this.checkArgIsStringLiteral(node.getChild(0), "v1Expression");
                    node.setType(UnknownType.getInstance());
                    break;
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case VE_DATA: {
                    node.setType(VeDataType.getInstance());
                    break;
                }
                case TO_FLOAT: 
                case REMAINDER: 
                case MSG_WITH_ID: {
                    throw new AssertionError();
                }
            }
        }

        private void checkArgIsStringLiteral(ExprNode arg, String funcName) {
            if (!(arg instanceof StringNode)) {
                ResolveExpressionTypesPass.this.errorReporter.report(arg.getSourceLocation(), STRING_LITERAL_REQUIRED, funcName);
            }
        }

        private void visitInternalSoyFunction(Object fn, FunctionNode node) {
            if (fn instanceof AugmentMapFunction) {
                this.visitAugmentMapFunction(node);
            } else if (fn instanceof LegacyObjectMapToMapFunction) {
                if (this.checkArgType(node.getChild(0), LegacyObjectMapType.ANY_MAP, node)) {
                    this.visitLegacyObjectMapToMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof MapToLegacyObjectMapFunction) {
                if (this.checkArgType(node.getChild(0), MapType.ANY_MAP, node, UnknownPolicy.DISALLOWED)) {
                    this.visitMapToLegacyObjectMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof KeysFunction) {
                this.visitKeysFunction(node);
            } else if (fn instanceof MapKeysFunction) {
                if (this.checkArgType(node.getChild(0), MapType.ANY_MAP, node, UnknownPolicy.DISALLOWED)) {
                    this.visitMapKeysFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof ConcatListsFunction) {
                ExprNode childNode;
                boolean allTypesValid = true;
                ImmutableSet.Builder elementTypesBuilder = ImmutableSet.builder();
                Iterator<ExprNode> iterator = node.getChildren().iterator();
                while (iterator.hasNext() && (allTypesValid = this.checkArgType(childNode = iterator.next(), ListType.ANY_LIST, node, UnknownPolicy.DISALLOWED))) {
                    SoyType elementType = ((ListType)childNode.getType()).getElementType();
                    if (elementType == null) continue;
                    elementTypesBuilder.add((Object)elementType);
                }
                if (allTypesValid) {
                    ImmutableSet elementTypes = elementTypesBuilder.build();
                    node.setType(elementTypes.isEmpty() ? ListType.EMPTY_LIST : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)elementTypes)));
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof LoggingFunction) {
                node.setType(StringType.getInstance());
            } else if (node.getType() == null) {
                node.setType(UnknownType.getInstance());
            }
        }

        private void requireLoopVariableInScope(FunctionNode fn, ExprNode loopVariable) {
            if (!(loopVariable instanceof VarRefNode) || !(((VarRefNode)loopVariable).getDefnDecl() instanceof LoopVar)) {
                ResolveExpressionTypesPass.this.errorReporter.report(fn.getSourceLocation(), LOOP_VARIABLE_NOT_IN_SCOPE, fn.getFunctionName());
            }
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node) {
            return this.checkArgType(arg, expectedType, node, UnknownPolicy.ALLOWED);
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node, UnknownPolicy policy) {
            SoyType.Kind argTypeKind = arg.getType().getKind();
            if (argTypeKind == SoyType.Kind.ERROR || expectedType.getKind() == SoyType.Kind.ERROR) {
                return false;
            }
            if (policy == UnknownPolicy.ALLOWED && argTypeKind == SoyType.Kind.UNKNOWN) {
                return true;
            }
            if (!expectedType.isAssignableFrom(arg.getType())) {
                ResolveExpressionTypesPass.this.errorReporter.report(arg.getSourceLocation(), INCORRECT_ARG_TYPE, node.getFunctionName(), arg.getType(), expectedType);
                return false;
            }
            return true;
        }
    }

    private final class TypeAssignmentSoyVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private TypeAssignmentSoyVisitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            ArrayList headerVars = Lists.newArrayList(node.getParams());
            if (node.getKind() == SoyNode.Kind.TEMPLATE_ELEMENT_NODE) {
                headerVars.addAll(((TemplateElementNode)node).getStateVars());
            }
            ErrorReporter.Checkpoint cp = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
            for (TemplateHeaderVarDefn headerVar : headerVars) {
                if (headerVar.defaultValue() == null || SoyTreeUtils.isConstantExpr(headerVar.defaultValue())) continue;
                ResolveExpressionTypesPass.this.errorReporter.report(headerVar.defaultValue().getSourceLocation(), STATE_MUST_BE_CONSTANT, headerVar.name());
                headerVar.setType(ErrorType.getInstance());
            }
            if (ResolveExpressionTypesPass.this.errorReporter.errorsSince(cp)) {
                for (TemplateHeaderVarDefn headerVar : headerVars) {
                    if (headerVar.hasType()) continue;
                    headerVar.setType(ErrorType.getInstance());
                }
                return;
            }
            ResolveExpressionTypesPass.this.visitExpressions(node);
            for (TemplateHeaderVarDefn headerVar : headerVars) {
                if (headerVar.defaultValue() != null) {
                    SoyType actualType = headerVar.defaultValue().getRoot().getType();
                    if (headerVar.getTypeNode() != null) {
                        SoyType declaredType = headerVar.type();
                        if (declaredType.equals(NullType.getInstance())) {
                            ResolveExpressionTypesPass.this.errorReporter.report(headerVar.getTypeNode().sourceLocation(), EXPLICIT_NULL, new Object[0]);
                        }
                        if (!declaredType.isAssignableFrom(actualType)) {
                            ResolveExpressionTypesPass.this.errorReporter.report(headerVar.defaultValue().getSourceLocation(), TYPE_MISMATCH_STATE, headerVar.name(), actualType, declaredType);
                        }
                        if (!declaredType.equals(actualType)) continue;
                        ResolveExpressionTypesPass.this.errorReporter.report(headerVar.getTypeNode().sourceLocation(), EXPLICIT_TYPE_SAME_AS_INFERRED, new Object[0]);
                        continue;
                    }
                    headerVar.setType(actualType);
                    if (!actualType.equals(NullType.getInstance())) continue;
                    ResolveExpressionTypesPass.this.errorReporter.report(headerVar.nameLocation(), INFERRED_NULL, new Object[0]);
                    continue;
                }
                if (!headerVar.type().equals(NullType.getInstance())) continue;
                ResolveExpressionTypesPass.this.errorReporter.report(headerVar.getTypeNode().sourceLocation(), EXPLICIT_NULL, new Object[0]);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.visitSoyNode(node);
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.visitSoyNode(node);
            node.getVar().setType(node.getExpr().getType());
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitSoyNode(node);
            node.getVar().setType(node.getContentKind() != null ? SanitizedType.getTypeForContentKind(node.getContentKind()) : StringType.getInstance());
        }

        @Override
        protected void visitIfNode(IfNode node) {
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    ResolveExpressionTypesPass.this.visitExpressions(icn);
                    TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
                    visitor.exec(icn.getExpr());
                    TypeSubstitution previousSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
                    this.visitChildren(icn);
                    ResolveExpressionTypesPass.this.substitutions = previousSubstitutionState;
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
                    continue;
                }
                if (!(child instanceof IfElseNode)) continue;
                IfElseNode ien = (IfElseNode)child;
                this.visitChildren(ien);
            }
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            ResolveExpressionTypesPass.this.visitExpressions(node);
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            ExprNode switchExpr = node.getExpr().getRoot();
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    ResolveExpressionTypesPass.this.visitExpressions(scn);
                    ArrayList<SoyType> caseTypes = new ArrayList<SoyType>();
                    boolean nullFound = false;
                    for (ExprRootNode expr : scn.getExprList()) {
                        caseTypes.add(expr.getType());
                        if (expr.getRoot().getKind() != ExprNode.Kind.NULL_NODE) continue;
                        nullFound = true;
                    }
                    SoyType caseType = ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType(caseTypes);
                    TypeSubstitution previousSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
                    HashMap<Equivalence.Wrapper, SoyType> positiveTypeConstraints = new HashMap<Equivalence.Wrapper, SoyType>();
                    positiveTypeConstraints.put(ExprEquivalence.get().wrap(switchExpr), caseType);
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(positiveTypeConstraints);
                    this.visitChildren(scn);
                    ResolveExpressionTypesPass.this.substitutions = previousSubstitutionState;
                    if (!nullFound) continue;
                    HashMap<Equivalence.Wrapper, SoyType> negativeTypeConstraints = new HashMap<Equivalence.Wrapper, SoyType>();
                    negativeTypeConstraints.put(ExprEquivalence.get().wrap(switchExpr), SoyTypes.tryRemoveNull(switchExpr.getType()));
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(negativeTypeConstraints);
                    continue;
                }
                if (!(child instanceof SwitchDefaultNode)) continue;
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.visitChildren(sdn);
            }
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            ResolveExpressionTypesPass.this.visitExpressions(node.getParent());
            node.getVar().setType(ResolveExpressionTypesPass.this.getElementType(node.getExpr().getType(), node));
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ExprHolderNode) {
                ResolveExpressionTypesPass.this.visitExpressions((SoyNode.ExprHolderNode)node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

