/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

final class CheckEscapingSanityFilePass
extends CompilerFilePass {
    private static final SoyErrorKind ILLEGAL_PRINT_DIRECTIVE = SoyErrorKind.of("{0} can only be used internally by the Soy compiler.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind RENDER_UNIT_WITHOUT_KIND = SoyErrorKind.of("In strict templates, '{'{0}'}'...'{'/{0}'}' blocks require an explicit kind=\"\".", new SoyErrorKind.StyleAllowance[0]);
    private final Visitor visitor;

    CheckEscapingSanityFilePass(ErrorReporter errorReporter) {
        this.visitor = new Visitor(errorReporter);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        this.visitor.exec(file);
    }

    private static final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        AutoescapeMode autoescapeMode;
        final ErrorReporter errorReporter;

        Visitor(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.autoescapeMode = node.getAutoescapeMode();
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintDirectiveNode(PrintDirectiveNode node) {
            EscapingMode escapingMode = EscapingMode.fromDirective(node.getName());
            if (escapingMode != null && escapingMode.isInternalOnly) {
                this.errorReporter.report(node.getSourceLocation(), ILLEGAL_PRINT_DIRECTIVE, node.getName());
            }
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            AutoescapeMode oldMode = this.autoescapeMode;
            if (node.getContentKind() != null) {
                this.autoescapeMode = AutoescapeMode.STRICT;
            } else if (this.autoescapeMode == AutoescapeMode.STRICT) {
                this.errorReporter.report(node.getSourceLocation(), RENDER_UNIT_WITHOUT_KIND, node.getKind() == SoyNode.Kind.LET_CONTENT_NODE ? "let" : "param");
            }
            this.visitChildren(node);
            this.autoescapeMode = oldMode;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

