/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.Sanitizers;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

final class AddDebugAttributesPass
extends CompilerFilePass {
    AddDebugAttributesPass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new Visitor(nodeIdGen).exec(file);
    }

    private static final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        String currentTemplate;
        int tagDepth;
        final IdGenerator nodeIdGen;

        Visitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.currentTemplate = node.getTemplateNameForUserMsgs();
            this.visitBlock(node);
            this.currentTemplate = null;
        }

        private void visitBlock(SoyNode.BlockNode node) {
            int oldDepth = this.tagDepth;
            if (node instanceof SoyNode.RenderUnitNode) {
                this.tagDepth = 0;
            }
            this.visitChildren(node);
            this.tagDepth = oldDepth;
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            if (this.tagDepth == 0) {
                node.addChild(this.createSoyDebug(node.getSourceLocation()));
            }
            if (!node.isSelfClosing() && !node.getTagName().isDefinitelyVoid()) {
                ++this.tagDepth;
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            --this.tagDepth;
            if (this.tagDepth < 0) {
                this.tagDepth = 0;
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.BlockNode) {
                this.visitBlock((SoyNode.BlockNode)node);
            } else if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private IfNode createSoyDebug(SourceLocation insertionLocation) {
            IfNode ifNode = new IfNode(this.nodeIdGen.genId(), insertionLocation);
            FunctionNode funcNode = new FunctionNode(Identifier.create(BuiltinFunction.DEBUG_SOY_TEMPLATE_INFO.getName(), insertionLocation), BuiltinFunction.DEBUG_SOY_TEMPLATE_INFO, insertionLocation);
            IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), insertionLocation, "if", funcNode);
            HtmlAttributeNode attribute = new HtmlAttributeNode(this.nodeIdGen.genId(), insertionLocation, insertionLocation.getBeginPoint());
            attribute.addChild(new RawTextNode(this.nodeIdGen.genId(), "data-debug-soy", insertionLocation));
            HtmlAttributeValueNode attrValue = new HtmlAttributeValueNode(this.nodeIdGen.genId(), insertionLocation, HtmlAttributeValueNode.Quotes.DOUBLE);
            attribute.addChild(attrValue);
            attrValue.addChild(new RawTextNode(this.nodeIdGen.genId(), Sanitizers.escapeHtmlAttribute(this.currentTemplate + " " + insertionLocation.getFilePath() + ":" + insertionLocation.getBeginLine()), insertionLocation));
            ifCondNode.addChild(attribute);
            ifNode.addChild(ifCondNode);
            return ifNode;
        }
    }
}

