/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;

final class Rewriter {
    private final Inferences inferences;
    private final IdGenerator idGen;
    private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;
    private final RewriterVisitor mutator = new RewriterVisitor();

    Rewriter(Inferences inferences, IdGenerator idGen, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
        this.inferences = inferences;
        this.idGen = idGen;
        this.printDirectives = printDirectives;
    }

    public void rewrite(SoyFileNode file) {
        this.mutator.exec(file);
    }

    private final class RewriterVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private RewriterVisitor() {
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            ImmutableList<EscapingMode> escapingModes = Rewriter.this.inferences.getEscapingModesForNode(printNode);
            for (EscapingMode escapingMode : escapingModes) {
                int newPrintDirectiveIndex;
                PrintDirectiveNode newPrintDirective = PrintDirectiveNode.createSyntheticNode(Rewriter.this.idGen.genId(), Identifier.create(escapingMode.directiveName, printNode.getSourceLocation()), printNode.getSourceLocation(), (SoyPrintDirective)Rewriter.this.printDirectives.get((Object)escapingMode.directiveName));
                for (newPrintDirectiveIndex = printNode.numChildren(); newPrintDirectiveIndex > 0; --newPrintDirectiveIndex) {
                    SanitizedContentKind contentKind;
                    SoyPrintDirective printDirective = ((PrintDirectiveNode)printNode.getChild(newPrintDirectiveIndex - 1)).getPrintDirective();
                    SanitizedContentKind sanitizedContentKind = contentKind = printDirective instanceof SanitizedContentOperator ? SanitizedContentKind.valueOf(((SanitizedContentOperator)((Object)printDirective)).getContentKind().name()) : null;
                    if (contentKind == null || contentKind != escapingMode.contentKind) break;
                }
                printNode.addChild(newPrintDirectiveIndex, newPrintDirective);
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
        }

        private ImmutableList<SoyPrintDirective> getDirectivesForNode(SoyNode node) {
            ImmutableList.Builder escapingDirectiveNames = new ImmutableList.Builder();
            for (EscapingMode escapingMode : Rewriter.this.inferences.getEscapingModesForNode(node)) {
                escapingDirectiveNames.add(Rewriter.this.printDirectives.get((Object)escapingMode.directiveName));
            }
            return escapingDirectiveNames.build();
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            node.setEscapingDirectives(this.getDirectivesForNode(node));
            this.visitChildren(node);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            node.setEscapingDirectives(this.getDirectivesForNode(node));
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

