/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Utf8;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public abstract class SoyMsgRawTextPart
extends SoyMsgPart {
    private static final int BYTES_PER_CHAR = 2;

    public static SoyMsgRawTextPart of(String rawText) {
        int utf8Length = Utf8.encodedLength((CharSequence)rawText);
        if (utf8Length < rawText.length() * 2) {
            return new Utf8SoyMsgRawTextPart(rawText);
        }
        return new CharArraySoyMsgRawTextPart(rawText);
    }

    public abstract String getRawText();

    @Override
    public final String toString() {
        return this.getRawText();
    }

    SoyMsgRawTextPart() {
    }

    @VisibleForTesting
    static final class CharArraySoyMsgRawTextPart
    extends SoyMsgRawTextPart {
        private final char[] charArray;

        CharArraySoyMsgRawTextPart(String rawText) {
            this.charArray = rawText.toCharArray();
        }

        public boolean equals(Object other) {
            return other instanceof CharArraySoyMsgRawTextPart && Arrays.equals(this.charArray, ((CharArraySoyMsgRawTextPart)other).charArray);
        }

        public int hashCode() {
            return this.getClass().hashCode() + Arrays.hashCode(this.charArray);
        }

        @Override
        public String getRawText() {
            return new String(this.charArray);
        }
    }

    @VisibleForTesting
    static final class Utf8SoyMsgRawTextPart
    extends SoyMsgRawTextPart {
        private final byte[] utf8Bytes;

        Utf8SoyMsgRawTextPart(String rawText) {
            this.utf8Bytes = rawText.getBytes(StandardCharsets.UTF_8);
        }

        public boolean equals(Object other) {
            return other instanceof Utf8SoyMsgRawTextPart && Arrays.equals(this.utf8Bytes, ((Utf8SoyMsgRawTextPart)other).utf8Bytes);
        }

        public int hashCode() {
            return this.getClass().hashCode() + Arrays.hashCode(this.utf8Bytes);
        }

        @Override
        public String getRawText() {
            return new String(this.utf8Bytes, StandardCharsets.UTF_8);
        }
    }
}

