/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.Locale;

public final class SoyMsgBundleWithFullLocale
extends SoyMsgBundle {
    private final SoyMsgBundle delegate;
    private final String localeString;
    private final ULocale locale;
    private final boolean isRtl;

    public static SoyMsgBundle preservingLocaleIfAllowed(SoyMsgBundle bundle, Locale locale) {
        ULocale ulocale = new ULocale(locale.toLanguageTag());
        return ulocale.getLanguage().equals(bundle.getLocale().getLanguage()) ? new SoyMsgBundleWithFullLocale(bundle, ulocale, ulocale.toLanguageTag()) : bundle;
    }

    @VisibleForTesting
    SoyMsgBundleWithFullLocale(SoyMsgBundle delegate, ULocale locale, String localeString) {
        while (delegate instanceof SoyMsgBundleWithFullLocale) {
            delegate = ((SoyMsgBundleWithFullLocale)delegate).delegate;
        }
        this.delegate = delegate;
        this.locale = locale;
        this.localeString = localeString;
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isRtl() {
        return this.isRtl;
    }

    @Override
    public SoyMsg getMsg(long msgId) {
        return this.delegate.getMsg(msgId);
    }

    @Override
    public ImmutableList<SoyMsgPart> getMsgParts(long msgId) {
        return this.delegate.getMsgParts(msgId);
    }

    @Override
    public int getNumMsgs() {
        return this.delegate.getNumMsgs();
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return this.delegate.iterator();
    }

    @VisibleForTesting
    public SoyMsgBundle getInnerSoyMsgBundle() {
        return this.delegate;
    }
}

