/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.List;

public class GenCallCodeUtils {
    private final DelTemplateNamer delTemplateNamer;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    protected GenCallCodeUtils(DelTemplateNamer delTemplateNamer, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.delTemplateNamer = delTemplateNamer;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    public Expression gen(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Expression callee = this.genCallee(callNode, templateAliases, exprTranslator);
        Expression objToPass = this.genObjToPass(callNode, templateAliases, translationContext, errorReporter, exprTranslator);
        Expression call = this.genMainCall(callee, objToPass, callNode);
        if (callNode.getEscapingDirectives().isEmpty()) {
            return call;
        }
        return GenCallCodeUtils.applyEscapingDirectives(call, callNode);
    }

    protected Expression genMainCall(Expression callee, Expression objToPass, CallNode call) {
        return callee.call(objToPass, JsRuntime.OPT_IJ_DATA);
    }

    public static Expression applyEscapingDirectives(Expression call, CallNode callNode) {
        JsExpr callResult = call.singleExprOrName();
        CodeChunk.RequiresCollector.IntoImmutableSet collector = new CodeChunk.RequiresCollector.IntoImmutableSet();
        call.collectRequires(collector);
        for (SoyPrintDirective directive : callNode.getEscapingDirectives()) {
            Preconditions.checkState((boolean)(directive instanceof SoyJsSrcPrintDirective), (String)"Contextual autoescaping produced a bogus directive: %s", (Object)directive.getName());
            callResult = ((SoyJsSrcPrintDirective)directive).applyForJsSrc(callResult, (List<JsExpr>)ImmutableList.of());
            if (!(directive instanceof SoyLibraryAssistedJsSrcPrintDirective)) continue;
            for (String name : ((SoyLibraryAssistedJsSrcPrintDirective)directive).getRequiredJsLibNames()) {
                collector.add(GoogRequire.create(name));
            }
        }
        return Expression.fromExpr(callResult, collector.get()).withInitialStatements((Iterable<? extends Statement>)call.initialStatements());
    }

    public Expression genCallee(CallNode callNode, TemplateAliases templateAliases, TranslateExprNodeVisitor exprTranslator) {
        Expression callee;
        if (callNode instanceof CallBasicNode) {
            callee = Expression.dottedIdNoRequire(templateAliases.get(((CallBasicNode)callNode).getCalleeName()));
        } else {
            CallDelegateNode callDelegateNode = (CallDelegateNode)callNode;
            Expression calleeId = JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expression.stringLiteral(this.delTemplateNamer.getDelegateName(callDelegateNode)));
            ExprRootNode variantSoyExpr = callDelegateNode.getDelCalleeVariantExpr();
            Expression variant = variantSoyExpr == null ? Expression.LITERAL_EMPTY_STRING : (Expression)exprTranslator.exec(variantSoyExpr);
            callee = JsRuntime.SOY_GET_DELEGATE_FN.call(calleeId, variant, callDelegateNode.allowEmptyDefault() ? Expression.LITERAL_TRUE : Expression.LITERAL_FALSE);
        }
        return callee;
    }

    public Expression genObjToPass(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Expression dataToPass;
        if (callNode.isPassingAllData()) {
            dataToPass = JsRuntime.OPT_DATA;
        } else if (callNode.isPassingData()) {
            dataToPass = (Expression)exprTranslator.exec(callNode.getDataExpr());
        } else {
            if (callNode.numChildren() == 0) {
                return Expression.LITERAL_NULL;
            }
            dataToPass = Expression.LITERAL_NULL;
        }
        if (callNode.numChildren() == 0) {
            return dataToPass.castAs("?");
        }
        ImmutableList.Builder keys = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        for (CallParamNode child : callNode.getChildren()) {
            Expression content;
            keys.add((Object)Expression.id(child.getKey().identifier()));
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                Expression value = (Expression)exprTranslator.exec(cpvn.getExpr());
                values.add((Object)value);
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(cpcn)).booleanValue()) {
                List<Expression> chunks = this.genJsExprsVisitorFactory.create(translationContext, templateAliases, errorReporter).exec(cpcn);
                content = CodeChunkUtils.concatChunksForceString(chunks);
            } else {
                content = Expression.id("param" + cpcn.getId());
            }
            content = this.maybeWrapContent(translationContext.codeGenerator(), cpcn, content);
            values.add((Object)content);
        }
        Expression params = Expression.objectLiteral((Iterable<? extends Expression>)keys.build(), (Iterable<? extends Expression>)values.build());
        if (callNode.isPassingData()) {
            Expression allData = JsRuntime.SOY_ASSIGN_DEFAULTS.call(params, dataToPass);
            return allData;
        }
        return params.castAs("?");
    }

    protected Expression maybeWrapContent(CodeChunk.Generator generator, CallParamContentNode node, Expression content) {
        if (node.getContentKind() == null) {
            return content;
        }
        return JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(content);
    }
}

