/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ObjectLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
@AutoValue
abstract class ObjectLiteral
extends Expression {
    ObjectLiteral() {
    }

    abstract ImmutableList<? extends Expression> keys();

    abstract ImmutableList<? extends Expression> values();

    static ObjectLiteral create(ImmutableList<? extends Expression> keys, ImmutableList<? extends Expression> values) {
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Mismatch between keys and values.");
        ImmutableList.Builder initialStatements = ImmutableList.builder();
        for (Expression key : keys) {
            initialStatements.addAll(key.initialStatements());
        }
        for (Expression value : values) {
            initialStatements.addAll(value.initialStatements());
        }
        return new AutoValue_ObjectLiteral((ImmutableList<Statement>)initialStatements.build(), keys, values);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('{');
        for (int i = 0; i < this.keys().size(); ++i) {
            if (i > 0) {
                ctx.append(", ");
            }
            ctx.appendOutputExpression((Expression)this.keys().get(i)).append(": ").appendOutputExpression((Expression)this.values().get(i));
        }
        ctx.append('}');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (Expression key : this.keys()) {
            ctx.appendInitialStatements(key);
        }
        for (Expression value : this.values()) {
            ctx.appendInitialStatements(value);
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (Expression key : this.keys()) {
            key.collectRequires(collector);
        }
        for (Expression value : this.values()) {
            value.collectRequires(collector);
        }
    }
}

