/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Bracket;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Statement;

@Immutable
@AutoValue
abstract class Bracket
extends Operation {
    Bracket() {
    }

    abstract Expression receiver();

    abstract Expression key();

    static Bracket create(Expression receiver, Expression key) {
        return new AutoValue_Bracket((ImmutableList<Statement>)ImmutableList.builder().addAll(receiver.initialStatements()).addAll(key.initialStatements()).build(), receiver, key);
    }

    @Override
    int precedence() {
        return Integer.MAX_VALUE;
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.Associativity.LEFT;
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.receiver().collectRequires(collector);
        this.key().collectRequires(collector);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.receiver()).appendInitialStatements(this.key());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.receiver(), OperandPosition.LEFT, ctx);
        ctx.append('[').appendOutputExpression(this.key()).append(']');
    }
}

