/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.template.soy.base.internal.FixedIdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledForeachRangeArgs;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledMethodBody;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.ControlFlow;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.LazyClosureCompiler;
import com.google.template.soy.jbcsrc.MsgCompiler;
import com.google.template.soy.jbcsrc.PrintDirectives;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SoyNodeCompiler
extends AbstractReturningSoyNodeVisitor<Statement> {
    private final Expression thisVar;
    private final CompiledTemplateRegistry registry;
    private final DetachState detachState;
    private final TemplateVariableManager variables;
    private final TemplateParameterLookup parameterLookup;
    private final AppendableExpression appendableExpression;
    private final ExpressionCompiler exprCompiler;
    private final ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler;
    private final LazyClosureCompiler lazyClosureCompiler;
    private TemplateVariableManager.Scope currentScope;

    static SoyNodeCompiler create(CompiledTemplateRegistry registry, InnerClasses innerClasses, FieldRef stateField, Expression thisVar, AppendableExpression appendableVar, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, ErrorReporter reporter, SoyTypeRegistry typeRegistry, List<TemplateStateVar> stateVars) {
        DetachState detachState = new DetachState(variables, thisVar, stateField);
        ExpressionCompiler expressionCompiler = ExpressionCompiler.create(detachState, parameterLookup, variables, reporter, typeRegistry);
        ExpressionToSoyValueProviderCompiler soyValueProviderCompiler = ExpressionToSoyValueProviderCompiler.create(variables, expressionCompiler, parameterLookup);
        return new SoyNodeCompiler(thisVar, registry, detachState, variables, parameterLookup, appendableVar, expressionCompiler, soyValueProviderCompiler, new LazyClosureCompiler(registry, innerClasses, parameterLookup, variables, soyValueProviderCompiler, reporter, typeRegistry, stateVars));
    }

    SoyNodeCompiler(Expression thisVar, CompiledTemplateRegistry registry, DetachState detachState, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, AppendableExpression appendableExpression, ExpressionCompiler exprCompiler, ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler, LazyClosureCompiler lazyClosureCompiler) {
        this.thisVar = (Expression)Preconditions.checkNotNull((Object)thisVar);
        this.registry = (CompiledTemplateRegistry)Preconditions.checkNotNull((Object)registry);
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.variables = (TemplateVariableManager)Preconditions.checkNotNull((Object)variables);
        this.parameterLookup = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.exprCompiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)exprCompiler);
        this.expressionToSoyValueProviderCompiler = (ExpressionToSoyValueProviderCompiler)Preconditions.checkNotNull((Object)expressionToSoyValueProviderCompiler);
        this.lazyClosureCompiler = (LazyClosureCompiler)Preconditions.checkNotNull((Object)lazyClosureCompiler);
    }

    CompiledMethodBody compile(SoyNode.RenderUnitNode node) {
        return this.compile(node, ExtraCodeCompiler.NO_OP, ExtraCodeCompiler.NO_OP);
    }

    CompiledMethodBody compile(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (node.getContentKind() != null) {
            statements.add(this.appendableExpression.setSanitizedContentKind(node.getContentKind()).setSanitizedContentDirectionality(SanitizedContent.ContentKind.valueOf(node.getContentKind().name()).getDefaultDir()).toStatement());
        }
        statements.add(prefix.compile(this.exprCompiler, this.appendableExpression));
        statements.add(this.visitChildrenInNewScope(node));
        statements.add(suffix.compile(this.exprCompiler, this.appendableExpression));
        statements.add(0, this.detachState.generateReattachTable());
        return CompiledMethodBody.create(Statement.concat(statements), this.detachState.getNumberOfDetaches());
    }

    @Override
    protected Statement visit(SoyNode node) {
        try {
            return ((Statement)super.visit(node)).withSourceLocation(node.getSourceLocation());
        }
        catch (UnexpectedCompilerFailureException e) {
            e.addLocation(node);
            throw e;
        }
        catch (Throwable t) {
            throw new UnexpectedCompilerFailureException(node, t);
        }
    }

    @Override
    protected Statement visitTemplateNode(TemplateNode node) {
        return this.visitChildrenInNewScope(node);
    }

    private Statement visitChildrenInNewScope(SoyNode.BlockNode node) {
        TemplateVariableManager.Scope prev = this.currentScope;
        this.currentScope = this.variables.enterScope();
        List children = this.visitChildren(node);
        Statement leave = this.currentScope.exitScope();
        children.add(leave);
        this.currentScope = prev;
        return Statement.concat(children);
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        ArrayList<ControlFlow.IfBlock> ifs = new ArrayList<ControlFlow.IfBlock>();
        Optional elseBlock = Optional.absent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                SoyExpression cond = this.exprCompiler.compile(icn.getExpr()).coerceToBoolean();
                Statement block = this.visitChildrenInNewScope(icn);
                ifs.add(ControlFlow.IfBlock.create(cond, block));
                continue;
            }
            IfElseNode ien = (IfElseNode)child;
            elseBlock = Optional.of((Object)this.visitChildrenInNewScope(ien));
        }
        return ControlFlow.ifElseChain(ifs, (Optional<Statement>)elseBlock);
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return Statement.NULL_STATEMENT;
        }
        if (children.size() == 1 && children.get(0) instanceof SwitchDefaultNode) {
            return this.visitChildrenInNewScope((SoyNode.BlockNode)children.get(0));
        }
        SoyExpression switchVar = this.exprCompiler.compile(node.getExpr());
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        TemplateVariableManager.Variable variable = scope.createSynthetic(SyntheticVarName.forSwitch(node), switchVar, TemplateVariableManager.SaveStrategy.STORE);
        Statement initializer = variable.initializer();
        switchVar = switchVar.withSource(variable.local());
        ArrayList<ControlFlow.IfBlock> cases = new ArrayList<ControlFlow.IfBlock>();
        Optional defaultBlock = Optional.absent();
        for (SoyNode child : children) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                Label reattachPoint = new Label();
                ArrayList<Expression> comparisons = new ArrayList<Expression>();
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    comparisons.add(BytecodeUtils.compareSoyEquals(switchVar, this.exprCompiler.compile(caseExpr, reattachPoint)));
                }
                Expression condition = BytecodeUtils.logicalOr(comparisons).labelStart(reattachPoint);
                Statement block = this.visitChildrenInNewScope(caseNode);
                cases.add(ControlFlow.IfBlock.create(condition, block));
                continue;
            }
            SwitchDefaultNode defaultNode = (SwitchDefaultNode)child;
            defaultBlock = Optional.of((Object)this.visitChildrenInNewScope(defaultNode));
        }
        Statement exitScope = scope.exitScope();
        return Statement.concat(initializer, ControlFlow.ifElseChain(cases, (Optional<Statement>)defaultBlock), exitScope);
    }

    @Override
    protected Statement visitForNode(ForNode node) {
        TemplateVariableManager.Variable itemVar;
        TemplateVariableManager.Variable indexVar;
        TemplateVariableManager.Variable sizeVar;
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)node.getChild(0);
        Optional<RangeArgs> exprAsRangeArgs = RangeArgs.createFromNode(node);
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        final ArrayList<Statement> initializers = new ArrayList<Statement>();
        if (exprAsRangeArgs.isPresent()) {
            final CompiledForeachRangeArgs compiledArgs = this.calculateRangeArgs(node, scope);
            initializers.addAll((Collection<Statement>)compiledArgs.initStatements());
            sizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRef.RUNTIME_RANGE_LOOP_LENGTH.invoke(compiledArgs.start(), compiledArgs.end(), compiledArgs.step()), TemplateVariableManager.SaveStrategy.DERIVED);
            indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            itemVar = scope.create(nonEmptyNode.getVarName(), new Expression(Type.LONG_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    compiledArgs.start().gen(adapter);
                    compiledArgs.step().gen(adapter);
                    indexVar.local().gen(adapter);
                    adapter.visitInsn(104);
                    adapter.visitInsn(96);
                    adapter.cast(Type.INT_TYPE, Type.LONG_TYPE);
                }
            }, TemplateVariableManager.SaveStrategy.DERIVED);
        } else {
            SoyExpression expr = this.exprCompiler.compile(node.getExpr()).unboxAsList();
            TemplateVariableManager.Variable listVar = scope.createSynthetic(SyntheticVarName.foreachLoopList(nonEmptyNode), expr, TemplateVariableManager.SaveStrategy.STORE);
            initializers.add(listVar.initializer());
            sizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRef.LIST_SIZE.invoke(listVar.local()), TemplateVariableManager.SaveStrategy.DERIVED);
            indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            itemVar = scope.create(nonEmptyNode.getVarName(), MethodRef.LIST_GET.invoke(listVar.local(), indexVar.local()).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
        }
        initializers.add(sizeVar.initializer());
        final Statement loopBody = this.visitChildrenInNewScope(nonEmptyNode);
        final Statement exitScope = scope.exitScope();
        final Statement emptyBlock = node.numChildren() == 2 ? this.visitChildrenInNewScope((SoyNode.BlockNode)node.getChild(1)) : null;
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                for (Statement initializer : initializers) {
                    initializer.gen(adapter);
                }
                sizeVar.local().gen(adapter);
                Label emptyListLabel = new Label();
                adapter.ifZCmp(153, emptyListLabel);
                indexVar.initializer().gen(adapter);
                Label loopStart = adapter.mark();
                itemVar.initializer().gen(adapter);
                loopBody.gen(adapter);
                adapter.iinc(indexVar.local().index(), 1);
                indexVar.local().gen(adapter);
                sizeVar.local().gen(adapter);
                adapter.ifICmp(155, loopStart);
                exitScope.gen(adapter);
                if (emptyBlock != null) {
                    Label skipIfEmptyBlock = new Label();
                    adapter.goTo(skipIfEmptyBlock);
                    adapter.mark(emptyListLabel);
                    emptyBlock.gen(adapter);
                    adapter.mark(skipIfEmptyBlock);
                } else {
                    adapter.mark(emptyListLabel);
                }
            }
        };
    }

    private CompiledForeachRangeArgs calculateRangeArgs(ForNode forNode, TemplateVariableManager.Scope scope) {
        RangeArgs rangeArgs = (RangeArgs)RangeArgs.createFromNode(forNode).get();
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)forNode.getChild(0);
        ImmutableList.Builder initStatements = ImmutableList.builder();
        Expression startExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeStart(nonEmptyNode), rangeArgs.start(), 0, scope, (ImmutableList.Builder<Statement>)initStatements);
        Expression stepExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeStep(nonEmptyNode), rangeArgs.increment(), 1, scope, (ImmutableList.Builder<Statement>)initStatements);
        Expression endExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeEnd(nonEmptyNode), (Optional<ExprNode>)Optional.of((Object)rangeArgs.limit()), Integer.MAX_VALUE, scope, (ImmutableList.Builder<Statement>)initStatements);
        return new AutoValue_SoyNodeCompiler_CompiledForeachRangeArgs(startExpression, endExpression, stepExpression, (ImmutableList<Statement>)initStatements.build());
    }

    private Expression computeRangeValue(SyntheticVarName varName, Optional<ExprNode> expression, int defaultValue, TemplateVariableManager.Scope scope, ImmutableList.Builder<Statement> initStatements) {
        if (!expression.isPresent()) {
            return BytecodeUtils.constant(defaultValue);
        }
        if (expression.get() instanceof IntegerNode && ((IntegerNode)expression.get()).isInt()) {
            int value = Ints.checkedCast((long)((IntegerNode)expression.get()).getValue());
            return BytecodeUtils.constant(value);
        }
        Label startDetachPoint = new Label();
        Expression startExpression = MethodRef.INTS_CHECKED_CAST.invoke(this.exprCompiler.compile((ExprNode)expression.get(), startDetachPoint).unboxAsLong());
        if (!startExpression.isCheap()) {
            TemplateVariableManager.Variable startVar = scope.createSynthetic(varName, startExpression, TemplateVariableManager.SaveStrategy.STORE);
            initStatements.add((Object)startVar.initializer().labelStart(startDetachPoint));
            startExpression = startVar.local();
        }
        return startExpression;
    }

    @Override
    protected Statement visitPrintNode(PrintNode node) {
        Label reattachPoint;
        FunctionNode fn;
        if (node.getExpr().getRoot() instanceof FunctionNode && (fn = (FunctionNode)node.getExpr().getRoot()).getSoyFunction() instanceof LoggingFunction) {
            return this.visitLoggingFunction(node, fn, (LoggingFunction)fn.getSoyFunction());
        }
        if (PrintDirectives.areAllPrintDirectivesStreamable(node)) {
            reattachPoint = new Label();
            ExprRootNode expr = node.getExpr();
            Optional<Expression> asSoyValueProvider = this.expressionToSoyValueProviderCompiler.compileAvoidingBoxing(expr, reattachPoint);
            if (asSoyValueProvider.isPresent()) {
                return this.renderIncrementally((Expression)asSoyValueProvider.get(), node.getChildren(), reattachPoint);
            }
        }
        reattachPoint = new Label();
        SoyExpression value = this.compilePrintNodeAsExpression(node, reattachPoint);
        AppendableExpression renderSoyValue = this.appendableExpression.appendString(value.coerceToString()).labelStart(reattachPoint);
        Statement stmt = SoyNodeCompiler.shouldCheckBuffer(node) ? this.detachState.detachLimited(renderSoyValue) : renderSoyValue.toStatement();
        return stmt;
    }

    private Statement visitLoggingFunction(PrintNode node, FunctionNode fn, LoggingFunction loggingFunction) {
        ArrayList<Expression> printDirectives = new ArrayList<Expression>(node.numChildren());
        for (PrintDirectiveNode child : node.getChildren()) {
            Preconditions.checkState((boolean)child.getArgs().isEmpty());
            printDirectives.add(this.parameterLookup.getRenderContext().getEscapingDirectiveAsFunction(child.getName()));
        }
        Label reattachPoint = new Label();
        SoyFunctionSignature functionSignature = loggingFunction.getClass().getAnnotation(SoyFunctionSignature.class);
        Preconditions.checkNotNull((Object)functionSignature, (String)"LoggingFunction %s must be annotated with @SoyFunctionSignature", (Object)loggingFunction.getClass().getName());
        return this.appendableExpression.appendLoggingFunctionInvocation(functionSignature.name(), loggingFunction.getPlaceholder(), this.exprCompiler.asBasicCompiler(reattachPoint).compileToList(fn.getChildren()), printDirectives).labelStart(reattachPoint).toStatement();
    }

    private SoyExpression compilePrintNodeAsExpression(PrintNode node, Label reattachPoint) {
        ExpressionCompiler.BasicExpressionCompiler basic = this.exprCompiler.asBasicCompiler(reattachPoint);
        SoyExpression value = basic.compile(node.getExpr());
        for (PrintDirectiveNode printDirective : node.getChildren()) {
            value = this.parameterLookup.getRenderContext().applyPrintDirective(printDirective.getPrintDirective(), value, basic.compileToList(printDirective.getArgs()));
        }
        return value;
    }

    private Statement renderIncrementally(Expression soyValueProvider, List<PrintDirectiveNode> directives, Label reattachPoint) {
        Statement initRenderee = Statement.NULL_STATEMENT;
        Statement clearRenderee = Statement.NULL_STATEMENT;
        if (!soyValueProvider.isCheap()) {
            FieldRef currentRendereeField = this.variables.getCurrentRenderee();
            initRenderee = currentRendereeField.putInstanceField(this.thisVar, soyValueProvider);
            clearRenderee = currentRendereeField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE));
            soyValueProvider = currentRendereeField.accessor(this.thisVar);
        }
        initRenderee = initRenderee.labelStart(reattachPoint);
        Statement initAppendable = Statement.NULL_STATEMENT;
        Statement clearAppendable = Statement.NULL_STATEMENT;
        Expression appendable = this.appendableExpression;
        if (!directives.isEmpty()) {
            Label printDirectiveArgumentReattachPoint = new Label();
            SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions wrappedAppendable = PrintDirectives.applyStreamingPrintDirectives(directives, appendable, this.exprCompiler.asBasicCompiler(printDirectiveArgumentReattachPoint), this.parameterLookup.getPluginContext(), this.variables);
            FieldRef currentAppendableField = this.variables.getCurrentAppendable();
            initAppendable = currentAppendableField.putInstanceField(this.thisVar, wrappedAppendable.appendable()).labelStart(printDirectiveArgumentReattachPoint);
            appendable = currentAppendableField.accessor(this.thisVar);
            clearAppendable = currentAppendableField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE));
            if (wrappedAppendable.closeable()) {
                clearAppendable = Statement.concat(currentAppendableField.accessor(this.thisVar).checkedCast(BytecodeUtils.CLOSEABLE_TYPE).invokeVoid(MethodRef.CLOSEABLE_CLOSE, new Expression[0]), clearAppendable);
            }
        }
        Expression callRenderAndResolve = soyValueProvider.invoke(MethodRef.SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE, appendable, BytecodeUtils.constant(false));
        Statement doCall = this.detachState.detachForRender(callRenderAndResolve);
        return Statement.concat(initRenderee, initAppendable, doCall, clearAppendable, clearRenderee);
    }

    private static boolean shouldCheckBuffer(PrintNode node) {
        if (!(node.getExpr().getRoot() instanceof FunctionNode)) {
            return true;
        }
        FunctionNode fn = (FunctionNode)node.getExpr().getRoot();
        if (!(fn.getSoyFunction() instanceof BuiltinFunction)) {
            return true;
        }
        BuiltinFunction bfn = (BuiltinFunction)fn.getSoyFunction();
        return bfn != BuiltinFunction.XID && bfn != BuiltinFunction.CSS;
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        AppendableExpression render = this.appendableExpression.appendString(BytecodeUtils.constant(node.getRawText(), this.variables));
        return this.detachState.detachLimited(render);
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return MethodRef.RUNTIME_DEBUGGER.invokeVoid(BytecodeUtils.constant(node.getSourceLocation().getFilePath()), BytecodeUtils.constant(node.getSourceLocation().getBeginLine()));
    }

    @Override
    protected Statement visitKeyNode(KeyNode node) {
        return Statement.NULL_STATEMENT;
    }

    @Override
    protected Statement visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        MsgNode msg = node.getMsg();
        MsgUtils.MsgPartsAndIds idAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(msg);
        ImmutableList<SoyPrintDirective> escapingDirectives = node.getEscapingDirectives();
        Statement renderDefault = this.getMsgCompiler().compileMessage(idAndParts, msg, escapingDirectives);
        if (node.hasFallbackMsg()) {
            MsgNode fallback = node.getFallbackMsg();
            MsgUtils.MsgPartsAndIds fallbackIdAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(fallback);
            ControlFlow.IfBlock ifAvailableRenderDefault = ControlFlow.IfBlock.create(this.parameterLookup.getRenderContext().usePrimaryMsg(idAndParts.id, fallbackIdAndParts.id), renderDefault);
            return ControlFlow.ifElseChain((List<ControlFlow.IfBlock>)ImmutableList.of((Object)ifAvailableRenderDefault), (Optional<Statement>)Optional.of((Object)this.getMsgCompiler().compileMessage(fallbackIdAndParts, fallback, escapingDirectives)));
        }
        return renderDefault;
    }

    @Override
    protected Statement visitCallDelegateNode(CallDelegateNode node) {
        Label reattachPoint = new Label();
        Expression variantExpr = node.getDelCalleeVariantExpr() == null ? BytecodeUtils.constant("") : this.exprCompiler.compile(node.getDelCalleeVariantExpr(), reattachPoint).coerceToString();
        Expression calleeExpression = this.parameterLookup.getRenderContext().getDeltemplate(node.getDelCalleeName(), variantExpr, node.allowEmptyDefault(), this.prepareParamsHelper(node, reattachPoint), this.parameterLookup.getIjRecord());
        return this.renderCallNode(reattachPoint, node, calleeExpression);
    }

    @Override
    protected Statement visitCallBasicNode(CallBasicNode node) {
        CompiledTemplateMetadata callee = this.registry.getTemplateInfoByTemplateName(node.getCalleeName());
        Label reattachPoint = new Label();
        Expression calleeExpression = callee.constructor().construct(this.prepareParamsHelper(node, reattachPoint), this.parameterLookup.getIjRecord());
        return this.renderCallNode(reattachPoint, node, calleeExpression);
    }

    @Override
    protected Statement visitVeLogNode(VeLogNode node) {
        final Label restartPoint = new Label();
        final SoyExpression veData = this.exprCompiler.compile(node.getVeDataExpression(), restartPoint);
        final Expression hasLogger = this.parameterLookup.getRenderContext().hasLogger();
        final Statement body = Statement.concat(this.visitChildren(node));
        final Statement exitStatement = ControlFlow.IfBlock.create(hasLogger, this.appendableExpression.exitLoggableElement().toStatement()).asStatement();
        if (node.getLogonlyExpression() != null) {
            final SoyExpression logonlyExpression = this.exprCompiler.compile(node.getLogonlyExpression(), restartPoint).unboxAsBoolean();
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    cb.mark(restartPoint);
                    logonlyExpression.gen(cb);
                    Label noLogger = new Label();
                    hasLogger.gen(cb);
                    cb.ifZCmp(153, noLogger);
                    veData.gen(cb);
                    cb.swap();
                    MethodRef.CREATE_LOG_STATEMENT.invokeUnchecked(cb);
                    SoyNodeCompiler.this.appendableExpression.gen(cb);
                    cb.swap();
                    AppendableExpression.ENTER_LOGGABLE_STATEMENT.invokeUnchecked(cb);
                    cb.pop();
                    Label bodyLabel = new Label();
                    cb.goTo(bodyLabel);
                    cb.mark(noLogger);
                    cb.ifZCmp(153, bodyLabel);
                    cb.throwException(BytecodeUtils.ILLEGAL_STATE_EXCEPTION_TYPE, "Cannot set logonly=\"true\" unless there is a logger configured");
                    cb.mark(bodyLabel);
                    body.gen(cb);
                    exitStatement.gen(cb);
                }
            };
        }
        Statement enterStatement = ControlFlow.IfBlock.create(hasLogger, this.appendableExpression.enterLoggableElement(MethodRef.CREATE_LOG_STATEMENT.invoke(veData, BytecodeUtils.constant(false))).toStatement().labelStart(restartPoint)).asStatement();
        return Statement.concat(enterStatement, body, exitStatement);
    }

    private Statement renderCallNode(Label parametersReattachPoint, CallNode node, Expression calleeExpression) {
        Expression appendable;
        Statement initAppendable = Statement.NULL_STATEMENT;
        Statement clearAppendable = Statement.NULL_STATEMENT;
        FieldRef currentCalleeField = this.variables.getCurrentCalleeField();
        if (!PrintDirectives.areAllPrintDirectivesStreamable(node)) {
            calleeExpression = MethodRef.RUNTIME_APPLY_ESCAPERS.invoke(calleeExpression, this.getEscapingDirectivesList(node));
            appendable = this.appendableExpression;
        } else {
            SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions wrappedAppendable = PrintDirectives.applyStreamingEscapingDirectives(node.getEscapingDirectives(), this.appendableExpression, this.parameterLookup.getRenderContext(), this.variables);
            FieldRef currentAppendableField = this.variables.getCurrentAppendable();
            initAppendable = currentAppendableField.putInstanceField(this.thisVar, wrappedAppendable.appendable());
            appendable = currentAppendableField.accessor(this.thisVar);
            clearAppendable = currentAppendableField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE));
            if (wrappedAppendable.closeable()) {
                clearAppendable = Statement.concat(currentAppendableField.accessor(this.thisVar).checkedCast(BytecodeUtils.CLOSEABLE_TYPE).invokeVoid(MethodRef.CLOSEABLE_CLOSE, new Expression[0]), clearAppendable);
            }
        }
        Statement initCallee = currentCalleeField.putInstanceField(this.thisVar, calleeExpression).labelStart(parametersReattachPoint);
        Expression callRender = currentCalleeField.accessor(this.thisVar).invoke(MethodRef.COMPILED_TEMPLATE_RENDER, appendable, this.parameterLookup.getRenderContext());
        Statement callCallee = this.detachState.detachForCall(callRender);
        Statement clearCallee = currentCalleeField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.COMPILED_TEMPLATE_TYPE));
        return Statement.concat(initAppendable, initCallee, callCallee, clearCallee, clearAppendable);
    }

    private Expression getEscapingDirectivesList(CallNode node) {
        ImmutableList<SoyPrintDirective> escapingDirectives = node.getEscapingDirectives();
        ArrayList<Expression> directiveExprs = new ArrayList<Expression>(escapingDirectives.size());
        for (SoyPrintDirective directive : escapingDirectives) {
            directiveExprs.add(this.parameterLookup.getRenderContext().getPrintDirective(directive.getName()));
        }
        return BytecodeUtils.asImmutableList(directiveExprs);
    }

    private Expression prepareParamsHelper(CallNode node, Label reattachPoint) {
        if (node.numChildren() == 0) {
            return this.getDataExpression(node, reattachPoint);
        }
        Expression paramStoreExpression = this.getParamStoreExpression(node, reattachPoint);
        for (CallParamNode child : node.getChildren()) {
            String paramKey = child.getKey().identifier();
            Expression valueExpr = child instanceof CallParamContentNode ? this.lazyClosureCompiler.compileLazyContent("param", (CallParamContentNode)child, paramKey) : this.lazyClosureCompiler.compileLazyExpression("param", child, paramKey, ((CallParamValueNode)child).getExpr());
            paramStoreExpression = MethodRef.PARAM_STORE_SET_FIELD.invoke(paramStoreExpression, BytecodeUtils.constant(paramKey), valueExpr);
        }
        return paramStoreExpression;
    }

    private Expression getParamStoreExpression(CallNode node, Label reattachPoint) {
        Expression paramStoreExpression = node.isPassingData() ? ConstructorRef.AUGMENTED_PARAM_STORE.construct(this.getDataExpression(node, reattachPoint), BytecodeUtils.constant(node.numChildren())) : ConstructorRef.BASIC_PARAM_STORE.construct(BytecodeUtils.constant(node.numChildren()));
        return paramStoreExpression;
    }

    private Expression getDataExpression(CallNode node, Label reattachPoint) {
        if (node.isPassingData()) {
            if (node.isPassingAllData()) {
                return this.parameterLookup.getParamsRecord();
            }
            return this.exprCompiler.compile(node.getDataExpr(), reattachPoint).box().checkedCast(SoyRecord.class);
        }
        return FieldRef.EMPTY_DICT.accessor();
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        return this.compilerWithNewAppendable(AppendableExpression.logger()).visitChildrenInNewScope(node);
    }

    @Override
    protected Statement visitLetValueNode(LetValueNode node) {
        Expression newLetValue = this.lazyClosureCompiler.compileLazyExpression("let", node, node.getVarName(), node.getExpr());
        return this.currentScope.create(node.getVarName(), newLetValue, TemplateVariableManager.SaveStrategy.STORE).initializer();
    }

    @Override
    protected Statement visitLetContentNode(LetContentNode node) {
        Expression newLetValue = this.lazyClosureCompiler.compileLazyContent("let", node, node.getVarName());
        return this.currentScope.create(node.getVarName(), newLetValue, TemplateVariableManager.SaveStrategy.STORE).initializer();
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        return Statement.concat(this.visitChildren(node));
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        throw new UnsupportedOperationException("The jbcsrc backend doesn't support: " + (Object)((Object)node.getKind()) + " nodes yet.");
    }

    private MsgCompiler getMsgCompiler() {
        return new MsgCompiler(this.thisVar, this.detachState, this.variables, this.parameterLookup, this.appendableExpression, new MsgCompiler.PlaceholderCompiler(){

            @Override
            public Expression compileToString(ExprRootNode node, Label reattachPoint) {
                return SoyNodeCompiler.this.exprCompiler.compile(node, reattachPoint).coerceToString();
            }

            @Override
            public Expression compileToInt(ExprRootNode node, Label reattachPoint) {
                return SoyNodeCompiler.this.exprCompiler.compile(node, reattachPoint).box().checkedCast(IntegerData.class);
            }

            @Override
            public Expression compileToSoyValueProvider(String phname, SoyNode.StandaloneNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
                LetContentNode fakeLet = LetContentNode.forVariable(-1, node.getSourceLocation(), "$" + phname, node.getSourceLocation(), null);
                fakeLet.addChild(SoyTreeUtils.cloneWithNewIds(node, new FixedIdGenerator(-1)));
                return SoyNodeCompiler.this.lazyClosureCompiler.compileLazyContent("ph", fakeLet, phname, prefix, suffix);
            }
        });
    }

    private SoyNodeCompiler compilerWithNewAppendable(AppendableExpression appendable) {
        return new SoyNodeCompiler(this.thisVar, this.registry, this.detachState, this.variables, this.parameterLookup, appendable, this.exprCompiler, this.expressionToSoyValueProviderCompiler, this.lazyClosureCompiler);
    }

    @AutoValue
    static abstract class CompiledForeachRangeArgs {
        CompiledForeachRangeArgs() {
        }

        abstract Expression start();

        abstract Expression end();

        abstract Expression step();

        abstract ImmutableList<Statement> initStatements();
    }

    @AutoValue
    static abstract class CompiledMethodBody {
        CompiledMethodBody() {
        }

        static CompiledMethodBody create(Statement body, int numDetaches) {
            return new AutoValue_SoyNodeCompiler_CompiledMethodBody(body, numDetaches);
        }

        abstract Statement body();

        abstract int numberOfDetachStates();
    }
}

