/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.types.SoyType;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

final class JbcSrcValueErrorReporter {
    private static final SoyErrorKind INVALID_RETURN_TYPE_WITH_METHOD = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Return type cannot be represented in Soy.\nMethod: {4}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_RETURN_TYPE_NO_METHOD = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Return type cannot be represented in Soy."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INCOMPATIBLE_RETURN_TYPE_WITH_METHOD = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Type mismatch on return type of {4}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INCOMPATIBLE_RETURN_TYPE_NO_METHOD = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Type mismatch on return type."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAMETER_LENGTH_MISMATCH = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Parameter length mismatch calling {4}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAM_MISMATCH = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Type mismatch on the {4} parameter to {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_PARAM = SoyErrorKind.of(JbcSrcValueErrorReporter.formatWithExpectedAndActual("Passed null to the {4} parameter of {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_RETURN = SoyErrorKind.of(JbcSrcValueErrorReporter.formatPlain("{2}.applyForJavaSource returned null."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_METHOD = SoyErrorKind.of(JbcSrcValueErrorReporter.formatPlain("Passed a null method to JavaValueFactory.{2}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_VALUES = SoyErrorKind.of(JbcSrcValueErrorReporter.formatPlain("Passed a null JavaValue[] to JavaValueFactory.{2} while trying to call method: {3}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INCOMPATIBLE_TYPES = SoyErrorKind.of(JbcSrcValueErrorReporter.formatPlain("Invalid call to {2}, {3} is incompatible with {4}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind VE_PARAM_NOT_SUPPORTED = SoyErrorKind.of(JbcSrcValueErrorReporter.formatPlain("The ve and ve_data types cannot be passed to plugins."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_ERROR = SoyErrorKind.of(JbcSrcValueErrorReporter.formatPlain("{2}"), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter reporter;
    private final FunctionNode fnNode;

    JbcSrcValueErrorReporter(ErrorReporter reporter, FunctionNode fnNode) {
        this.reporter = reporter;
        this.fnNode = fnNode;
    }

    private void report(SoyErrorKind error, Object ... additionalArgs) {
        Object[] args = new Object[additionalArgs.length + 2];
        args[0] = this.fnNode.getFunctionName();
        args[1] = this.fnNode.getSoyFunction().getClass().getName();
        for (int i = 0; i < additionalArgs.length; ++i) {
            args[2 + i] = additionalArgs[i];
        }
        this.reporter.report(this.fnNode.getSourceLocation(), error, args);
    }

    ErrorReporter.Checkpoint checkpoint() {
        return this.reporter.checkpoint();
    }

    boolean errorsSince(ErrorReporter.Checkpoint checkpoint) {
        return this.reporter.errorsSince(checkpoint);
    }

    void invalidReturnType(Class<?> returnType, @Nullable Method method) {
        if (method == null) {
            this.report(INVALID_RETURN_TYPE_NO_METHOD, "soy type of '" + this.fnNode.getType() + "'", "java type of '" + returnType.getName() + "'");
        } else {
            this.report(INVALID_RETURN_TYPE_WITH_METHOD, "soy type of '" + this.fnNode.getType() + "'", "java type of '" + returnType.getName() + "'", JbcSrcValueErrorReporter.simpleMethodName(method));
        }
    }

    void incompatibleReturnType(SoyType actualType, @Nullable Method method) {
        if (method == null) {
            this.report(INCOMPATIBLE_RETURN_TYPE_NO_METHOD, "soy type of '" + this.fnNode.getType() + "'", "soy type of '" + actualType + "'");
        } else {
            this.report(INCOMPATIBLE_RETURN_TYPE_WITH_METHOD, "soy type of '" + this.fnNode.getType() + "'", "soy type of '" + actualType + "'", JbcSrcValueErrorReporter.simpleMethodName(method));
        }
    }

    void incompatibleReturnType(Class<?> actualJavaType, @Nullable Method method) {
        if (method == null) {
            this.report(INCOMPATIBLE_RETURN_TYPE_NO_METHOD, "soy type of '" + this.fnNode.getType() + "'", "java type of '" + actualJavaType.getName() + "'");
        } else {
            this.report(INCOMPATIBLE_RETURN_TYPE_WITH_METHOD, "soy type of '" + this.fnNode.getType() + "'", "java type of '" + actualJavaType.getName() + "'", JbcSrcValueErrorReporter.simpleMethodName(method));
        }
    }

    void invalidParameterLength(Method method, JavaValue[] actualParams) {
        String expected = method.getParameterTypes().length == 1 ? "1 parameter" : method.getParameterTypes().length + " parameters";
        String actual = actualParams.length == 1 ? "1 parameter" : actualParams.length + " parameters";
        this.report(PARAMETER_LENGTH_MISMATCH, expected, actual, JbcSrcValueErrorReporter.simpleMethodName(method));
    }

    void invalidParameterType(Method method, int paramIdx, Class<?> expectedType, Expression actualExpr) {
        Type actualType = actualExpr instanceof SoyExpression ? ((SoyExpression)actualExpr).soyRuntimeType().runtimeType() : actualExpr.resultType();
        Class<?> actualClass = BytecodeUtils.classFromAsmType(actualType);
        this.report(PARAM_MISMATCH, "'" + expectedType.getName() + "'", "'" + actualClass.getName() + "'", paramIdx + JbcSrcValueErrorReporter.getOrdinalSuffix(paramIdx), JbcSrcValueErrorReporter.simpleMethodName(method));
    }

    void invalidParameterType(Method method, int paramIdx, Class<?> expectedType, SoyType allowedSoyType) {
        this.report(PARAM_MISMATCH, "java type of '" + expectedType.getName() + "'", "soy type of '" + allowedSoyType + "'", paramIdx + JbcSrcValueErrorReporter.getOrdinalSuffix(paramIdx), JbcSrcValueErrorReporter.simpleMethodName(method));
    }

    void nonSoyExpressionNotConvertible(Expression expr, SoyType newType, String methodName) {
        Class<?> actualClass = BytecodeUtils.classFromAsmType(expr.resultType());
        this.report(INCOMPATIBLE_TYPES, methodName, "java type of '" + actualClass.getName() + "'", "soy type of '" + newType + "'");
    }

    void nonSoyExpressionNotCoercible(Expression expr, SoyType newType, String methodName) {
        Class<?> actualClass = BytecodeUtils.classFromAsmType(expr.resultType());
        this.report(INCOMPATIBLE_TYPES, methodName, "java type of '" + actualClass.getName() + "'", "soy type of '" + newType + "'");
    }

    void incompatibleSoyType(SoyType allowedType, SoyType newType, String methodName) {
        this.report(INCOMPATIBLE_TYPES, methodName, "soy type of '" + allowedType + "'", "soy type of '" + newType + "'");
    }

    void nullReturn() {
        this.report(NULL_RETURN, this.fnNode.getSoyFunction().getClass().getSimpleName());
    }

    void nullMethod(String methodName) {
        this.report(NULL_METHOD, methodName);
    }

    void nullParamArray(Method method, String methodName) {
        this.report(NULL_VALUES, methodName, JbcSrcValueErrorReporter.simpleMethodName(method));
    }

    void nullParam(Method method, int paramIdx, Class<?> expectedType) {
        this.report(NULL_PARAM, "'" + expectedType.getName() + "'", "null", paramIdx + JbcSrcValueErrorReporter.getOrdinalSuffix(paramIdx), JbcSrcValueErrorReporter.simpleMethodName(method));
    }

    void unexpectedError(Throwable t) {
        this.report(UNEXPECTED_ERROR, Throwables.getStackTraceAsString((Throwable)t));
    }

    void veParam() {
        this.report(VE_PARAM_NOT_SUPPORTED, new Object[0]);
    }

    private static String formatPlain(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\nPlugin implementation: {1}";
    }

    private static String formatWithExpectedAndActual(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\n  expected: {2}, actual: {3}\nPlugin implementation: {1}";
    }

    private static String simpleMethodName(Method method) {
        return "'" + method.getDeclaringClass().getName() + "." + method.getName() + "'";
    }

    private static String getOrdinalSuffix(int ordinal) {
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0);
        if (ordinal / 10 % 10 == 1) {
            return "th";
        }
        switch (ordinal % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }
}

