/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import org.objectweb.asm.Label;

interface ExpressionDetacher {
    public Expression resolveSoyValueProvider(Expression var1);

    public Expression resolveSoyValueProviderList(Expression var1);

    public Expression resolveSoyValueProviderMap(Expression var1);

    public static final class BasicDetacher
    implements ExpressionDetacher {
        static final BasicDetacher INSTANCE = new BasicDetacher(Statement.NULL_STATEMENT);
        private final Statement saveOperation;

        BasicDetacher(Statement saveOperation) {
            this.saveOperation = saveOperation;
        }

        @Override
        public Expression resolveSoyValueProvider(final Expression soyValueProvider) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            return new Expression(BytecodeUtils.SOY_VALUE_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    soyValueProvider.gen(adapter);
                    adapter.dup();
                    MethodRef.SOY_VALUE_PROVIDER_STATUS.invokeUnchecked(adapter);
                    adapter.dup();
                    MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                    Label end = new Label();
                    adapter.ifZCmp(154, end);
                    saveOperation.gen(adapter);
                    adapter.returnValue();
                    adapter.mark(end);
                    adapter.pop();
                    MethodRef.SOY_VALUE_PROVIDER_RESOLVE.invokeUnchecked(adapter);
                }
            };
        }

        @Override
        public Expression resolveSoyValueProviderList(final Expression soyValueProviderList) {
            soyValueProviderList.checkAssignableTo(BytecodeUtils.LIST_TYPE);
            return new Expression(soyValueProviderList.resultType()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    soyValueProviderList.gen(cb);
                    cb.dup();
                    MethodRef.RUNTIME_GET_LIST_STATUS.invokeUnchecked(cb);
                    cb.dup();
                    MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(cb);
                    Label end = new Label();
                    cb.ifZCmp(154, end);
                    saveOperation.gen(cb);
                    cb.returnValue();
                    cb.mark(end);
                    cb.pop();
                }
            };
        }

        @Override
        public Expression resolveSoyValueProviderMap(final Expression soyValueProviderMap) {
            soyValueProviderMap.checkAssignableTo(BytecodeUtils.MAP_TYPE);
            return new Expression(soyValueProviderMap.resultType()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    soyValueProviderMap.gen(cb);
                    cb.dup();
                    MethodRef.RUNTIME_GET_MAP_STATUS.invokeUnchecked(cb);
                    cb.dup();
                    MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(cb);
                    Label end = new Label();
                    cb.ifZCmp(154, end);
                    saveOperation.gen(cb);
                    cb.returnValue();
                    cb.mark(end);
                    cb.pop();
                }
            };
        }
    }

    public static final class NullDetatcher
    implements ExpressionDetacher,
    Factory {
        static final NullDetatcher INSTANCE = new NullDetatcher();

        @Override
        public NullDetatcher createExpressionDetacher(Label reattachPoint) {
            return this;
        }

        @Override
        public Expression resolveSoyValueProvider(Expression soyValueProvider) {
            throw new AssertionError((Object)"shouldn't be called");
        }

        @Override
        public Expression resolveSoyValueProviderList(Expression soyValueProviderList) {
            soyValueProviderList.checkAssignableTo(BytecodeUtils.LIST_TYPE);
            return soyValueProviderList;
        }

        @Override
        public Expression resolveSoyValueProviderMap(Expression soyValueProviderMap) {
            soyValueProviderMap.checkAssignableTo(BytecodeUtils.MAP_TYPE);
            return soyValueProviderMap;
        }
    }

    public static interface Factory {
        public ExpressionDetacher createExpressionDetacher(Label var1);
    }
}

