/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Field {
    private static final Logger logger = Logger.getLogger(Field.class.getName());
    private final Descriptors.FieldDescriptor fieldDesc;
    private final boolean shouldCheckFieldPresenceToEmulateJspbNullability;
    private final String name;

    public static <T extends Field> ImmutableMap<String, T> getFieldsForType(Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions, Factory<T> factory) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) continue;
            T t = factory.create(fieldDescriptor);
            fields.put((Object)((Field)t).getName(), t);
        }
        SetMultimap extensionsBySoyName = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Descriptors.FieldDescriptor fieldDescriptor : extensions) {
            T field = factory.create(fieldDescriptor);
            extensionsBySoyName.put((Object)((Field)field).getName(), field);
        }
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)extensionsBySoyName).entrySet()) {
            Set ambiguousFields = (Set)entry.getValue();
            String fieldName = (String)entry.getKey();
            if (ambiguousFields.size() == 1) {
                fields.put((Object)fieldName, Iterables.getOnlyElement((Iterable)ambiguousFields));
                continue;
            }
            T value = factory.createAmbiguousFieldSet(ambiguousFields);
            logger.severe("Proto " + descriptor.getFullName() + " has multiple extensions with the name \"" + fieldName + "\": " + Field.fullFieldNames(ambiguousFields) + "\nThis field will not be accessible from soy");
            fields.put((Object)fieldName, value);
        }
        return fields.build();
    }

    protected Field(Descriptors.FieldDescriptor fieldDesc) {
        this.fieldDesc = (Descriptors.FieldDescriptor)Preconditions.checkNotNull((Object)fieldDesc);
        this.name = Field.computeSoyName(fieldDesc);
        this.shouldCheckFieldPresenceToEmulateJspbNullability = ProtoUtils.shouldCheckFieldPresenceToEmulateJspbNullability(fieldDesc);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean shouldCheckFieldPresenceToEmulateJspbNullability() {
        return this.shouldCheckFieldPresenceToEmulateJspbNullability;
    }

    public final Descriptors.FieldDescriptor getDescriptor() {
        return this.fieldDesc;
    }

    private static String computeSoyName(Descriptors.FieldDescriptor field) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName()) + Field.fieldSuffix(field);
    }

    private static String fieldSuffix(Descriptors.FieldDescriptor field) {
        if (field.isMapField()) {
            return "Map";
        }
        if (field.isRepeated()) {
            return "List";
        }
        return "";
    }

    protected static RuntimeException ambiguousFieldsError(String name, Set<? extends Field> fields) {
        return new IllegalStateException(String.format("Cannot access %s. It may refer to any one of the following extensions, and Soy doesn't have enough information to decide which.\n%s\nTo resolve ensure that all extension fields accessed from soy have unique names.", name, Field.fullFieldNames(fields)));
    }

    private static ImmutableSet<String> fullFieldNames(Set<? extends Field> fields) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Field field : fields) {
            builder.add((Object)field.getDescriptor().getFullName());
        }
        return builder.build();
    }

    public static interface Factory<T extends Field> {
        public T create(Descriptors.FieldDescriptor var1);

        public T createAmbiguousFieldSet(Set<T> var1);
    }
}

