/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.types.SoyType;
import java.util.List;
import javax.annotation.Nullable;

public final class FunctionNode
extends AbstractParentExprNode {
    private final Identifier name;
    private Object soyFunction;
    @Nullable
    private ImmutableList<SoyType> allowedParamTypes;

    public FunctionNode(Identifier name, Object soyFunction, SourceLocation sourceLocation) {
        this(name, sourceLocation);
        this.setSoyFunction(soyFunction);
    }

    public FunctionNode(Identifier name, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.name = name;
    }

    private FunctionNode(FunctionNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.soyFunction = orig.soyFunction;
        this.allowedParamTypes = orig.allowedParamTypes;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FUNCTION_NODE;
    }

    public String getFunctionName() {
        return this.name.identifier();
    }

    public SourceLocation getFunctionNameLocation() {
        return this.name.location();
    }

    public Object getSoyFunction() {
        Preconditions.checkState((this.soyFunction != null ? 1 : 0) != 0, (Object)"setSoyFunction() hasn't been called yet");
        return this.soyFunction;
    }

    public void setSoyFunction(Object soyFunction) {
        Preconditions.checkNotNull((Object)soyFunction);
        Preconditions.checkState((soyFunction instanceof SoyFunction || soyFunction instanceof SoySourceFunction ? 1 : 0) != 0);
        Preconditions.checkState((this.soyFunction == null ? 1 : 0) != 0, (Object)"setSoyFunction() was already called");
        if (soyFunction instanceof SoyFunction) {
            Preconditions.checkArgument((boolean)this.name.identifier().equals(((SoyFunction)soyFunction).getName()));
        }
        this.soyFunction = soyFunction;
    }

    public void setAllowedParamTypes(List<SoyType> allowedParamTypes) {
        Preconditions.checkState((allowedParamTypes.size() == this.numChildren() ? 1 : 0) != 0, (String)"allowedParamTypes.size (%s) != numChildren (%s)", (int)allowedParamTypes.size(), (int)this.numChildren());
        this.allowedParamTypes = ImmutableList.copyOf(allowedParamTypes);
    }

    @Nullable
    public ImmutableList<SoyType> getAllowedParamTypes() {
        return this.allowedParamTypes;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append(this.getFunctionName()).append('(');
        boolean isFirst = true;
        for (ExprNode child : this.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sourceSb.append(", ");
            }
            sourceSb.append(child.toSourceString());
        }
        sourceSb.append(')');
        return sourceSb.toString();
    }

    @Override
    public FunctionNode copy(CopyState copyState) {
        return new FunctionNode(this, copyState);
    }
}

