/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyEasyList;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyGlobalsValue;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.EasyListImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class SoyValueConverter {
    public static final SoyValueConverter UNCUSTOMIZED_INSTANCE;
    public static final SoyValueConverter INSTANCE;
    public static final SoyDict EMPTY_DICT;
    public static final SoyList EMPTY_LIST;
    public static final SoyMapImpl EMPTY_MAP;
    private final TypeMap cheapConverterMap = new TypeMap();
    private final TypeMap expensiveConverterMap = new TypeMap();

    @Inject
    SoyValueConverter() {
        this.cheapConverterMap.put(SoyValueProvider.class, new Converter<SoyValueProvider>(){

            public SoyValueProvider apply(SoyValueProvider input) {
                return input;
            }
        });
        this.cheapConverterMap.put(String.class, new Converter<String>(){

            public SoyValue apply(String input) {
                return StringData.forValue(input);
            }
        });
        this.cheapConverterMap.put(Boolean.class, new Converter<Boolean>(){

            public SoyValue apply(Boolean input) {
                return BooleanData.forValue(input);
            }
        });
        this.cheapConverterMap.put(Integer.class, new Converter<Integer>(){

            public SoyValue apply(Integer input) {
                return IntegerData.forValue(input.longValue());
            }
        });
        this.cheapConverterMap.put(Long.class, new Converter<Long>(){

            public SoyValue apply(Long input) {
                return IntegerData.forValue(input);
            }
        });
        this.cheapConverterMap.put(Float.class, new Converter<Float>(){

            public SoyValue apply(Float input) {
                return FloatData.forValue(input.doubleValue());
            }
        });
        this.cheapConverterMap.put(Double.class, new Converter<Double>(){

            public SoyValue apply(Double input) {
                return FloatData.forValue(input);
            }
        });
        this.cheapConverterMap.put(Future.class, new Converter<Future<?>>(){

            public SoyValueProvider apply(Future<?> input) {
                return new SoyFutureValueProvider(input);
            }
        });
        this.cheapConverterMap.put(Descriptors.EnumValueDescriptor.class, new Converter<Descriptors.EnumValueDescriptor>(){

            public SoyValue apply(Descriptors.EnumValueDescriptor input) {
                return IntegerData.forValue(input.getNumber());
            }
        });
        this.cheapConverterMap.put(ProtocolMessageEnum.class, new Converter<ProtocolMessageEnum>(){

            public SoyValue apply(ProtocolMessageEnum input) {
                return IntegerData.forValue(input.getNumber());
            }
        });
        this.cheapConverterMap.put(SafeHtml.class, new Converter<SafeHtml>(){

            public SoyValue apply(SafeHtml obj) {
                return SanitizedContents.fromSafeHtml(obj);
            }
        });
        this.cheapConverterMap.put(SafeHtmlProto.class, new Converter<SafeHtmlProto>(){

            public SoyValue apply(SafeHtmlProto obj) {
                return SanitizedContents.fromSafeHtmlProto(obj);
            }
        });
        this.cheapConverterMap.put(SafeScript.class, new Converter<SafeScript>(){

            public SoyValue apply(SafeScript obj) {
                return SanitizedContents.fromSafeScript(obj);
            }
        });
        this.cheapConverterMap.put(SafeScriptProto.class, new Converter<SafeScriptProto>(){

            public SoyValue apply(SafeScriptProto obj) {
                return SanitizedContents.fromSafeScriptProto(obj);
            }
        });
        this.cheapConverterMap.put(SafeStyle.class, new Converter<SafeStyle>(){

            public SoyValue apply(SafeStyle obj) {
                return SanitizedContents.fromSafeStyle(obj);
            }
        });
        this.cheapConverterMap.put(SafeStyleProto.class, new Converter<SafeStyleProto>(){

            public SoyValue apply(SafeStyleProto obj) {
                return SanitizedContents.fromSafeStyleProto(obj);
            }
        });
        this.cheapConverterMap.put(SafeStyleSheet.class, new Converter<SafeStyleSheet>(){

            public SoyValue apply(SafeStyleSheet obj) {
                return SanitizedContents.fromSafeStyleSheet(obj);
            }
        });
        this.cheapConverterMap.put(SafeStyleSheetProto.class, new Converter<SafeStyleSheetProto>(){

            public SoyValue apply(SafeStyleSheetProto obj) {
                return SanitizedContents.fromSafeStyleSheetProto(obj);
            }
        });
        this.cheapConverterMap.put(SafeUrl.class, new Converter<SafeUrl>(){

            public SoyValue apply(SafeUrl obj) {
                return SanitizedContents.fromSafeUrl(obj);
            }
        });
        this.cheapConverterMap.put(SafeUrlProto.class, new Converter<SafeUrlProto>(){

            public SoyValue apply(SafeUrlProto obj) {
                return SanitizedContents.fromSafeUrlProto(obj);
            }
        });
        this.cheapConverterMap.put(TrustedResourceUrl.class, new Converter<TrustedResourceUrl>(){

            public SoyValue apply(TrustedResourceUrl obj) {
                return SanitizedContents.fromTrustedResourceUrl(obj);
            }
        });
        this.cheapConverterMap.put(TrustedResourceUrlProto.class, new Converter<TrustedResourceUrlProto>(){

            public SoyValue apply(TrustedResourceUrlProto obj) {
                return SanitizedContents.fromTrustedResourceUrlProto(obj);
            }
        });
        this.cheapConverterMap.put(Message.Builder.class, new Converter<Message.Builder>(){

            public SoyValueProvider apply(Message.Builder input) {
                return SoyProtoValue.create(input.build());
            }
        });
        this.cheapConverterMap.put(Message.class, new Converter<Message>(){

            public SoyValueProvider apply(Message input) {
                return SoyProtoValue.create(input);
            }
        });
        this.expensiveConverterMap.put(ByteString.class, new Converter<ByteString>(){

            public SoyValue apply(ByteString input) {
                return StringData.forValue(BaseEncoding.base64().encode(input.toByteArray()));
            }
        });
        this.expensiveConverterMap.put(SoyGlobalsValue.class, new Converter<SoyGlobalsValue>(){

            public SoyValueProvider apply(SoyGlobalsValue input) {
                return SoyValueConverter.this.convert(input.getSoyGlobalValue());
            }
        });
        this.expensiveConverterMap.put(Map.class, new Converter<Map<String, ?>>(){

            public SoyValue apply(Map<String, ?> input) {
                return SoyValueConverter.this.newDictFromMap(input);
            }
        });
        this.expensiveConverterMap.put(MarkAsSoyMap.class, new Converter<MarkAsSoyMap>(){

            public SoyValue apply(MarkAsSoyMap input) {
                return SoyValueConverter.this.newSoyMapFromJavaMap(input.delegate());
            }
        });
        this.expensiveConverterMap.put(Collection.class, new Converter<Collection<?>>(){

            public SoyValue apply(Collection<?> input) {
                return SoyValueConverter.this.newListFromIterable(input);
            }
        });
        this.expensiveConverterMap.put(FluentIterable.class, new Converter<FluentIterable<?>>(){

            public SoyValue apply(FluentIterable<?> input) {
                return SoyValueConverter.this.newListFromIterable(input);
            }
        });
    }

    public SoyDict newDictFromMap(Map<String, ?> javaStringMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : javaStringMap.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)this.convertLazy(entry.getValue()));
        }
        return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build(), RuntimeMapTypeTracker.Type.UNKNOWN);
    }

    private SoyMap newSoyMapFromJavaMap(Map<?, ?> javaMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)javaMap.size());
        for (Map.Entry<?, ?> entry : javaMap.entrySet()) {
            map.put(this.convert(entry.getKey()).resolve(), this.convertLazy(entry.getValue()));
        }
        return SoyMapImpl.forProviderMap(map);
    }

    public static Object markAsSoyMap(Map<?, ?> delegate) {
        return new MarkAsSoyMap(delegate);
    }

    @Deprecated
    public SoyEasyList newEasyListFromList(SoyList list) {
        EasyListImpl result = new EasyListImpl();
        for (SoyValueProvider soyValueProvider : list.asJavaList()) {
            result.add(soyValueProvider);
        }
        return result;
    }

    private SoyList newListFromIterable(Iterable<?> items) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object item : items) {
            builder.add((Object)this.convertLazy(item));
        }
        return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
    }

    @Nonnull
    public SoyValueProvider convert(@Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertCheap(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return this.convertNonPrimitive(obj);
    }

    private SoyValueProvider convertNonPrimitive(@Nullable Object obj) {
        SoyValueProvider converted = this.expensiveConverterMap.convert(obj);
        if (converted != null) {
            return converted;
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy value (object type " + obj.getClass().getName() + ").");
    }

    private SoyValueProvider convertLazy(final @Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertCheap(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return SoyValueConverter.this.convertNonPrimitive(obj).resolve();
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    @Nullable
    private SoyValueProvider convertCheap(@Nullable Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        return this.cheapConverterMap.convert(obj);
    }

    static {
        INSTANCE = UNCUSTOMIZED_INSTANCE = new SoyValueConverter();
        EMPTY_DICT = DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)ImmutableMap.of(), RuntimeMapTypeTracker.Type.UNKNOWN);
        EMPTY_LIST = ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)ImmutableList.of());
        EMPTY_MAP = SoyMapImpl.forProviderMap((Map<? extends SoyValue, ? extends SoyValueProvider>)ImmutableMap.of());
    }

    private static final class MarkAsSoyMap {
        final Map<?, ?> delegate;

        MarkAsSoyMap(Map<?, ?> delegate) {
            this.delegate = delegate;
        }

        Map<?, ?> delegate() {
            return this.delegate;
        }
    }

    private static final class TypeMap {
        private static final Object NULL_MARKER = new Object();
        private final Map<Class<?>, Object> map = new ConcurrentHashMap();

        private TypeMap() {
        }

        <T> SoyValueProvider convert(T o) {
            Converter<?> converter = this.getConverter(o.getClass());
            if (converter != null) {
                return (SoyValueProvider)converter.apply(o);
            }
            return null;
        }

        <T> Converter<T> getConverter(Class<T> clz) {
            Object o = this.resolveConverter((Class)Preconditions.checkNotNull(clz));
            if (o == NULL_MARKER) {
                return null;
            }
            return (Converter)o;
        }

        <T> void put(Class<T> clazz, Converter<? extends T> converter) {
            Preconditions.checkState((this.map.put(clazz, Preconditions.checkNotNull(converter)) == null ? 1 : 0) != 0);
        }

        private Object resolveConverter(@Nullable Class<?> clazz) {
            if (clazz == null) {
                return NULL_MARKER;
            }
            Object c = this.map.get(clazz);
            if (c != null) {
                return c;
            }
            c = this.resolveConverter(clazz.getSuperclass());
            if (c == NULL_MARKER) {
                Class<?> iface;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (c = this.resolveConverter(iface = classArray[i])) == NULL_MARKER; ++i) {
                }
            }
            this.map.put(clazz, c);
            return c;
        }
    }

    private static interface Converter<T>
    extends Function<T, SoyValueProvider> {
    }
}

