/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basetree;

import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Map;

public final class CopyState {
    private final IdentityHashMap<Object, Object> mappings = new IdentityHashMap();

    public <T> void updateRefs(T oldObject, T newObject) {
        Preconditions.checkNotNull(oldObject);
        Preconditions.checkNotNull(newObject);
        Preconditions.checkArgument((!(newObject instanceof Listener) ? 1 : 0) != 0);
        Object previousMapping = this.mappings.put(oldObject, newObject);
        if (previousMapping != null) {
            if (previousMapping instanceof Listener) {
                Listener listener = (Listener)previousMapping;
                listener.newVersion(newObject);
            } else {
                throw new IllegalStateException("found multiple remappings for " + oldObject);
            }
        }
    }

    public <T> void registerRefListener(T oldObject, Listener<T> listener) {
        Preconditions.checkNotNull(oldObject);
        Preconditions.checkNotNull(listener);
        Object oldMapping = this.mappings.get(oldObject);
        if (oldMapping == null) {
            this.mappings.put(oldObject, listener);
        } else if (oldMapping instanceof Listener) {
            Listener oldListener = (Listener)oldMapping;
            this.mappings.put(oldObject, CopyState.chainListeners(listener, oldListener));
        } else {
            Object typedValue = oldMapping;
            listener.newVersion(typedValue);
        }
    }

    public void checkAllListenersFired() {
        for (Map.Entry<Object, Object> entry : this.mappings.entrySet()) {
            if (!(entry.getValue() instanceof Listener)) continue;
            throw new IllegalStateException("Listener for " + entry.getKey() + " never fired: " + entry.getValue());
        }
    }

    private static <T> Listener<T> chainListeners(final Listener<T> listener, final Listener<T> oldListener) {
        return new Listener<T>(){

            @Override
            public void newVersion(T newObject) {
                listener.newVersion(newObject);
                oldListener.newVersion(newObject);
            }
        };
    }

    public static interface Listener<T> {
        public void newVersion(T var1);
    }
}

