/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import java.io.Closeable;
import java.io.IOException;
import java.net.URLClassLoader;

public interface PluginLoader
extends Closeable {
    public Class<?> loadPlugin(String var1) throws ClassNotFoundException;

    public static final class Default
    implements PluginLoader {
        private final ClassLoader classLoader;
        private final boolean closeable;

        Default(URLClassLoader classLoader) {
            this.classLoader = classLoader;
            this.closeable = true;
        }

        public Default() {
            this.classLoader = Default.class.getClassLoader();
            this.closeable = false;
        }

        @Override
        public Class<?> loadPlugin(String className) throws ClassNotFoundException {
            return Class.forName(className, true, this.classLoader);
        }

        @Override
        public void close() throws IOException {
            if (this.closeable) {
                ((Closeable)((Object)this.classLoader)).close();
            }
        }
    }
}

