/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import com.google.template.soy.types.VeType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class SoyTypeRegistry {
    private static final ImmutableMap<String, SoyType> BUILTIN_TYPES = ImmutableMap.builder().put((Object)"?", (Object)UnknownType.getInstance()).put((Object)"any", (Object)AnyType.getInstance()).put((Object)"null", (Object)NullType.getInstance()).put((Object)"bool", (Object)BoolType.getInstance()).put((Object)"int", (Object)IntType.getInstance()).put((Object)"float", (Object)FloatType.getInstance()).put((Object)"string", (Object)StringType.getInstance()).put((Object)"number", (Object)SoyTypes.NUMBER_TYPE).put((Object)"html", (Object)SanitizedType.HtmlType.getInstance()).put((Object)"attributes", (Object)SanitizedType.AttributesType.getInstance()).put((Object)"css", (Object)SanitizedType.StyleType.getInstance()).put((Object)"uri", (Object)SanitizedType.UriType.getInstance()).put((Object)"trusted_resource_uri", (Object)SanitizedType.TrustedResourceUriType.getInstance()).put((Object)"js", (Object)SanitizedType.JsType.getInstance()).put((Object)"ve_data", (Object)VeDataType.getInstance()).build();
    private static final ImmutableMap<String, SanitizedType> SAFE_PROTO_TO_SANITIZED_TYPE = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)SanitizedType.HtmlType.getInstance()).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)SanitizedType.JsType.getInstance()).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)SanitizedType.StyleType.getInstance()).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)SanitizedType.StyleType.getInstance()).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)SanitizedType.UriType.getInstance()).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)SanitizedType.TrustedResourceUriType.getInstance()).build();
    public static final SoyTypeRegistry DEFAULT_UNKNOWN = new SoyTypeRegistry(){

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            SoyType type = super.getType(typeName);
            if (type == null) {
                return UnknownType.getInstance();
            }
            return type;
        }
    };
    private final Object lock = new Object();
    private final Interner<ListType> listTypes = Interners.newStrongInterner();
    private final Interner<MapType> mapTypes = Interners.newStrongInterner();
    private final Interner<LegacyObjectMapType> legacyObjectMapTypes = Interners.newStrongInterner();
    private final Interner<UnionType> unionTypes = Interners.newStrongInterner();
    private final Interner<RecordType> recordTypes = Interners.newStrongInterner();
    private final Interner<VeType> veTypes = Interners.newStrongInterner();
    @GuardedBy(value="lock")
    private ImmutableList<String> lazyAllSortedTypeNames;
    @GuardedBy(value="lock")
    private final Map<String, SoyType> protoTypeCache;
    private final ImmutableMap<String, Descriptors.GenericDescriptor> descriptors;
    private final ImmutableSetMultimap<String, Descriptors.FieldDescriptor> extensions;

    private SoyTypeRegistry(Builder builder) {
        DescriptorVisitor visitor = new DescriptorVisitor();
        try {
            builder.accept(visitor);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException("Malformed descriptor set", e);
        }
        this.descriptors = ImmutableMap.copyOf(visitor.descriptors);
        this.extensions = ImmutableSetMultimap.copyOf(visitor.extensions);
        this.protoTypeCache = new HashMap<String, SanitizedType>((Map<String, SanitizedType>)SAFE_PROTO_TO_SANITIZED_TYPE);
        Preconditions.checkState((this.unionTypes.intern((Object)((UnionType)SoyTypes.NUMBER_TYPE)) == SoyTypes.NUMBER_TYPE ? 1 : 0) != 0);
    }

    public SoyTypeRegistry() {
        this(new Builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SoyType getType(String typeName) {
        SoyType result = (SoyType)BUILTIN_TYPES.get((Object)typeName);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.protoTypeCache.get(typeName);
            if (result == null) {
                Descriptors.GenericDescriptor descriptor = (Descriptors.GenericDescriptor)this.descriptors.get((Object)typeName);
                if (descriptor == null) {
                    return null;
                }
                result = descriptor instanceof Descriptors.EnumDescriptor ? new SoyProtoEnumType((Descriptors.EnumDescriptor)descriptor) : new SoyProtoType(this, (Descriptors.Descriptor)descriptor, (Set<Descriptors.FieldDescriptor>)this.extensions.get((Object)typeName));
                this.protoTypeCache.put(typeName, result);
            }
        }
        return result;
    }

    public String findTypeWithMatchingNamespace(String prefix) {
        prefix = prefix + ".";
        for (String name : this.getAllSortedTypeNames()) {
            if (!name.startsWith(prefix)) continue;
            return name;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getAllSortedTypeNames() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lazyAllSortedTypeNames == null) {
                this.lazyAllSortedTypeNames = (ImmutableList)Stream.concat(BUILTIN_TYPES.keySet().stream(), this.descriptors.keySet().stream()).sorted().collect(ImmutableList.toImmutableList());
            }
            return this.lazyAllSortedTypeNames;
        }
    }

    public ListType getOrCreateListType(SoyType elementType) {
        return (ListType)this.listTypes.intern((Object)ListType.of(elementType));
    }

    public LegacyObjectMapType getOrCreateLegacyObjectMapType(SoyType keyType, SoyType valueType) {
        return (LegacyObjectMapType)this.legacyObjectMapTypes.intern((Object)LegacyObjectMapType.of(keyType, valueType));
    }

    public MapType getOrCreateMapType(SoyType keyType, SoyType valueType) {
        return (MapType)this.mapTypes.intern((Object)MapType.of(keyType, valueType));
    }

    public SoyType getOrCreateUnionType(Collection<SoyType> members) {
        SoyType type = UnionType.of(members);
        if (type.getKind() == SoyType.Kind.UNION) {
            type = (SoyType)this.unionTypes.intern((Object)((UnionType)type));
        }
        return type;
    }

    public SoyType getOrCreateUnionType(SoyType ... members) {
        return this.getOrCreateUnionType(Arrays.asList(members));
    }

    public RecordType getOrCreateRecordType(Map<String, SoyType> fields) {
        return (RecordType)this.recordTypes.intern((Object)RecordType.of(fields));
    }

    public VeType getOrCreateVeType(String dataType) {
        return (VeType)this.veTypes.intern((Object)VeType.of(dataType));
    }

    private static final class DescriptorVisitor {
        final Set<String> visited = new HashSet<String>();
        final Map<String, Descriptors.GenericDescriptor> descriptors = new LinkedHashMap<String, Descriptors.GenericDescriptor>();
        final SetMultimap<String, Descriptors.FieldDescriptor> extensions = MultimapBuilder.linkedHashKeys().treeSetValues(Comparator.comparingInt(Descriptors.FieldDescriptor::getNumber).thenComparing(left -> left.getContainingType().getFullName())).build();

        private DescriptorVisitor() {
        }

        void visitGeneric(Descriptors.GenericDescriptor descriptor, boolean onlyVisitingFiles) {
            if (descriptor instanceof Descriptors.FileDescriptor) {
                this.visitFile((Descriptors.FileDescriptor)descriptor, onlyVisitingFiles);
            } else if (descriptor instanceof Descriptors.Descriptor) {
                this.visitMessage((Descriptors.Descriptor)descriptor, true, onlyVisitingFiles);
            } else if (descriptor instanceof Descriptors.FieldDescriptor) {
                this.visitField((Descriptors.FieldDescriptor)descriptor, true, onlyVisitingFiles);
            } else if (descriptor instanceof Descriptors.EnumDescriptor) {
                this.visitEnum((Descriptors.EnumDescriptor)descriptor, onlyVisitingFiles);
            }
        }

        private void visitFiles(List<Descriptors.FileDescriptor> descriptors, boolean onlyVisitingFiles) {
            int size = descriptors.size();
            for (int i = 0; i < size; ++i) {
                this.visitFile(descriptors.get(i), onlyVisitingFiles);
            }
        }

        void visitFile(Descriptors.FileDescriptor fileDescriptor, boolean onlyVisitingFiles) {
            if (!this.shouldVisitDescriptor((Descriptors.GenericDescriptor)fileDescriptor, onlyVisitingFiles)) {
                return;
            }
            this.visitFiles(fileDescriptor.getDependencies(), onlyVisitingFiles);
            this.visitMessages(fileDescriptor.getMessageTypes(), false, onlyVisitingFiles);
            this.visitFields(fileDescriptor.getExtensions(), false, onlyVisitingFiles);
            this.visitEnums(fileDescriptor.getEnumTypes(), onlyVisitingFiles);
        }

        private void visitMessages(List<Descriptors.Descriptor> descriptors, boolean exploreDependencies, boolean onlyVisitingFiles) {
            int size = descriptors.size();
            for (int i = 0; i < size; ++i) {
                this.visitMessage(descriptors.get(i), exploreDependencies, onlyVisitingFiles);
            }
        }

        private void visitMessage(Descriptors.Descriptor messageDescriptor, boolean exploreDependencies, boolean onlyVisitingFiles) {
            if (!this.shouldVisitDescriptor((Descriptors.GenericDescriptor)messageDescriptor, onlyVisitingFiles)) {
                return;
            }
            this.descriptors.put(messageDescriptor.getFullName(), (Descriptors.GenericDescriptor)messageDescriptor);
            this.visitEnums(messageDescriptor.getEnumTypes(), onlyVisitingFiles);
            this.visitFields(messageDescriptor.getExtensions(), exploreDependencies, onlyVisitingFiles);
            this.visitMessages(messageDescriptor.getNestedTypes(), exploreDependencies, onlyVisitingFiles);
            if (exploreDependencies) {
                this.visitFields(messageDescriptor.getFields(), exploreDependencies, onlyVisitingFiles);
            }
        }

        private void visitEnums(List<Descriptors.EnumDescriptor> enumDescriptors, boolean onlyVisitingFiles) {
            int size = enumDescriptors.size();
            for (int i = 0; i < size; ++i) {
                this.visitEnum(enumDescriptors.get(i), onlyVisitingFiles);
            }
        }

        private void visitEnum(Descriptors.EnumDescriptor enumDescriptor, boolean onlyVisitingFiles) {
            if (!this.shouldVisitDescriptor((Descriptors.GenericDescriptor)enumDescriptor, onlyVisitingFiles)) {
                return;
            }
            this.descriptors.put(enumDescriptor.getFullName(), (Descriptors.GenericDescriptor)enumDescriptor);
        }

        private void visitFields(List<Descriptors.FieldDescriptor> fieldDescriptors, boolean exploreDependencies, boolean onlyVisitingFiles) {
            int size = fieldDescriptors.size();
            for (int i = 0; i < size; ++i) {
                this.visitField(fieldDescriptors.get(i), exploreDependencies, onlyVisitingFiles);
            }
        }

        private void visitField(Descriptors.FieldDescriptor fieldDescriptor, boolean exploreDependencies, boolean onlyVisitingFiles) {
            if (!this.shouldVisitDescriptor((Descriptors.GenericDescriptor)fieldDescriptor, onlyVisitingFiles)) {
                return;
            }
            if (exploreDependencies && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                this.visitMessage(fieldDescriptor.getMessageType(), exploreDependencies, onlyVisitingFiles);
            }
            if (exploreDependencies && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                this.visitEnum(fieldDescriptor.getEnumType(), onlyVisitingFiles);
            }
            if (fieldDescriptor.isExtension() && !ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) {
                this.extensions.put((Object)fieldDescriptor.getContainingType().getFullName(), (Object)fieldDescriptor);
            }
        }

        private boolean shouldVisitDescriptor(Descriptors.GenericDescriptor descriptor, boolean onlyVisitingFiles) {
            if (onlyVisitingFiles && !(descriptor instanceof Descriptors.FileDescriptor)) {
                return true;
            }
            return this.visited.add(descriptor.getFullName());
        }
    }

    public static final class Builder {
        private final Map<String, DescriptorProtos.FileDescriptorProto> nameToProtos = new LinkedHashMap<String, DescriptorProtos.FileDescriptorProto>();
        private final List<Descriptors.GenericDescriptor> descriptors = new ArrayList<Descriptors.GenericDescriptor>();
        private boolean areAllDescriptorsFileDescriptors = true;

        @Deprecated
        public Builder addFileDescriptorSetFromFile(File descriptorFile) throws IOException {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(descriptorFile));){
                for (DescriptorProtos.FileDescriptorProto file : DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream, (ExtensionRegistryLite)ProtoUtils.REGISTRY).getFileList()) {
                    this.nameToProtos.put(file.getName(), file);
                }
            }
            return this;
        }

        public Builder addDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptorsToAdd) {
            for (Descriptors.GenericDescriptor genericDescriptor : descriptorsToAdd) {
                if (this.areAllDescriptorsFileDescriptors && !(genericDescriptor instanceof Descriptors.FileDescriptor)) {
                    this.areAllDescriptorsFileDescriptors = false;
                }
                this.descriptors.add(genericDescriptor);
            }
            return this;
        }

        private void accept(DescriptorVisitor visitor) throws Descriptors.DescriptorValidationException {
            HashMap<String, Descriptors.FileDescriptor> parsedDescriptors = new HashMap<String, Descriptors.FileDescriptor>();
            for (String name : this.nameToProtos.keySet()) {
                visitor.visitFile(Builder.buildDescriptor(null, name, parsedDescriptors, this.nameToProtos), this.areAllDescriptorsFileDescriptors);
            }
            for (Descriptors.GenericDescriptor descriptor : this.descriptors) {
                visitor.visitGeneric(descriptor, this.areAllDescriptorsFileDescriptors);
            }
        }

        private static Descriptors.FileDescriptor buildDescriptor(String requestor, String name, Map<String, Descriptors.FileDescriptor> descriptors, Map<String, DescriptorProtos.FileDescriptorProto> protos) throws Descriptors.DescriptorValidationException {
            Descriptors.FileDescriptor file = descriptors.get(name);
            if (file != null) {
                return file;
            }
            DescriptorProtos.FileDescriptorProto proto = protos.get(name);
            if (proto == null) {
                throw new IllegalStateException("Cannot find proto descriptor for " + name + " which is a dependency of " + requestor);
            }
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[proto.getDependencyCount()];
            for (int i = 0; i < proto.getDependencyCount(); ++i) {
                deps[i] = Builder.buildDescriptor(name, proto.getDependency(i), descriptors, protos);
            }
            file = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)proto, (Descriptors.FileDescriptor[])deps);
            descriptors.put(name, file);
            return file;
        }

        public SoyTypeRegistry build() {
            return new SoyTypeRegistry(this);
        }
    }
}

