/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.SoyDocParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class TemplateNodeBuilder<T extends TemplateNodeBuilder<T>> {
    private static final boolean DISABLE_MIXED_PARAMS_ERROR_FOR_MIGRATION = Boolean.getBoolean("DISABLE_MIXED_PARAMS_ERROR_FOR_MIGRATION");
    private static final SoyErrorKind INVALID_SOYDOC_PARAM = SoyErrorKind.of("Found invalid soydoc param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PARAM_NAMED_IJ = SoyErrorKind.of("Invalid param name ''ij'' (''ij'' is for injected data).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind KIND_BUT_NOT_STRICT = SoyErrorKind.of("kind=\"...\" attribute is only valid with autoescape=\"strict\".", SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind LEGACY_COMPATIBLE_PARAM_TAG = SoyErrorKind.of("Found invalid SoyDoc param tag ''{0}''. The proper soydoc @param syntax is: ''@param <name> <optional comment>''. Soy does not understand JsDoc style type declarations in SoyDoc.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_ALREADY_DECLARED = SoyErrorKind.of("Param ''{0}'' already declared.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MIXED_PARAM_STYLES = SoyErrorKind.of("Cannot mix SoyDoc params and header params in the same template. Please  migrate to the '''{@param <name>: <type>}''' syntax.", new SoyErrorKind.StyleAllowance[0]);
    protected final TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo;
    protected final ErrorReporter errorReporter;
    protected Integer id;
    protected String cmdText;
    private String templateName;
    private String partialTemplateName;
    protected Visibility visibility;
    protected WhitespaceMode whitespaceMode = WhitespaceMode.JOIN;
    private AutoescapeMode autoescapeMode;
    private ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
    private String cssBaseNamespace;
    private SanitizedContentKind contentKind;
    protected String soyDoc;
    protected String soyDocDesc;
    @Nullable
    protected ImmutableList<TemplateParam> params;
    protected boolean strictHtmlDisabled;
    SourceLocation sourceLocation;
    SourceLocation openTagLocation;
    protected static final ImmutableSet<String> COMMON_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"autoescape", (Object)"kind", (Object)"requirecss", (Object)"cssbase", (Object)"stricthtml", (Object)"whitespace", (Object[])new String[0]);
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);
    private static final Pattern SOY_DOC_DECL_PATTERN = Pattern.compile("( @param[?]? ) \\s+ ( \\S+ )", 4);
    private static final Pattern SOY_DOC_PARAM_TEXT_PATTERN = Pattern.compile("[a-zA-Z_]\\w*", 4);

    protected TemplateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.errorReporter = errorReporter;
    }

    public T setId(int id) {
        Preconditions.checkState((this.id == null ? 1 : 0) != 0);
        this.id = id;
        return (T)this;
    }

    public T setSourceLocation(SourceLocation location) {
        Preconditions.checkState((this.sourceLocation == null ? 1 : 0) != 0);
        this.sourceLocation = (SourceLocation)Preconditions.checkNotNull((Object)location);
        return (T)this;
    }

    public T setOpenTagLocation(SourceLocation location) {
        Preconditions.checkState((this.openTagLocation == null ? 1 : 0) != 0);
        this.openTagLocation = (SourceLocation)Preconditions.checkNotNull((Object)location);
        return (T)this;
    }

    public abstract T setCommandValues(Identifier var1, List<CommandTagAttribute> var2);

    protected void setCommonCommandValues(List<CommandTagAttribute> attrs) {
        AutoescapeMode autoescapeMode = this.soyFileHeaderInfo.defaultAutoescapeMode;
        SanitizedContentKind kind = null;
        SourceLocation kindLocation = null;
        for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            switch (name.identifier()) {
                case "autoescape": {
                    autoescapeMode = attribute.valueAsAutoescapeMode(this.errorReporter);
                    break;
                }
                case "kind": {
                    kind = attribute.valueAsContentKind(this.errorReporter);
                    kindLocation = attribute.getValueLocation();
                    if (kind != SanitizedContentKind.HTML) break;
                    this.errorReporter.report(kindLocation, CommandTagAttribute.EXPLICIT_DEFAULT_ATTRIBUTE, "kind", "html");
                    break;
                }
                case "requirecss": {
                    this.setRequiredCssNamespaces(attribute.valueAsRequireCss(this.errorReporter));
                    break;
                }
                case "cssbase": {
                    this.setCssBaseNamespace(attribute.valueAsCssBase(this.errorReporter));
                    break;
                }
                case "stricthtml": {
                    this.strictHtmlDisabled = attribute.valueAsDisabled(this.errorReporter);
                    break;
                }
                case "whitespace": {
                    this.whitespaceMode = attribute.valueAsWhitespaceMode(this.errorReporter);
                    break;
                }
            }
        }
        this.setAutoescapeInfo(autoescapeMode, kind, kindLocation);
    }

    public T setSoyDoc(String soyDoc, SourceLocation soyDocLocation) {
        Preconditions.checkState((this.soyDoc == null ? 1 : 0) != 0);
        Preconditions.checkState((this.cmdText != null ? 1 : 0) != 0);
        this.soyDoc = soyDoc;
        Preconditions.checkArgument((soyDoc.startsWith("/**") && soyDoc.endsWith("*/") ? 1 : 0) != 0);
        String cleanedSoyDoc = TemplateNodeBuilder.cleanSoyDocHelper(soyDoc);
        this.soyDocDesc = TemplateNodeBuilder.parseSoyDocDescHelper(cleanedSoyDoc);
        this.addParams(this.parseSoyDocDeclsHelper(soyDoc, cleanedSoyDoc, soyDocLocation));
        return (T)this;
    }

    public T addParams(Iterable<? extends TemplateParam> newParams) {
        HashSet<String> seenParamKeys = new HashSet<String>();
        boolean hasTemplateHeaderParams = false;
        if (this.params == null) {
            this.params = ImmutableList.copyOf(newParams);
        } else {
            for (TemplateParam oldParam : this.params) {
                seenParamKeys.add(oldParam.name());
                hasTemplateHeaderParams |= oldParam.declLoc() == TemplateParam.DeclLoc.HEADER;
            }
            this.params = ImmutableList.builder().addAll(this.params).addAll(newParams).build();
        }
        for (TemplateParam param : newParams) {
            hasTemplateHeaderParams |= param.declLoc() == TemplateParam.DeclLoc.HEADER;
            if (param.name().equals("ij")) {
                this.errorReporter.report(param.nameLocation(), INVALID_PARAM_NAMED_IJ, new Object[0]);
            }
            if (seenParamKeys.add(param.name())) continue;
            this.errorReporter.report(param.nameLocation(), PARAM_ALREADY_DECLARED, param.name());
        }
        if (hasTemplateHeaderParams) {
            for (TemplateParam param : this.params) {
                if (param.declLoc() != TemplateParam.DeclLoc.SOY_DOC || DISABLE_MIXED_PARAMS_ERROR_FOR_MIGRATION) continue;
                this.errorReporter.report(param.nameLocation(), MIXED_PARAM_STYLES, param.nameLocation().getFilePath());
            }
        }
        return (T)this;
    }

    public abstract TemplateNode build();

    protected void setAutoescapeInfo(AutoescapeMode autoescapeMode, @Nullable SanitizedContentKind contentKind, @Nullable SourceLocation kindLocation) {
        Preconditions.checkArgument((autoescapeMode != null ? 1 : 0) != 0);
        this.autoescapeMode = autoescapeMode;
        if (contentKind == null && autoescapeMode == AutoescapeMode.STRICT) {
            contentKind = SanitizedContentKind.HTML;
        } else if (contentKind != null && autoescapeMode != AutoescapeMode.STRICT) {
            this.errorReporter.report(kindLocation, KIND_BUT_NOT_STRICT, new Object[0]);
        }
        this.contentKind = contentKind;
    }

    Integer getId() {
        return this.id;
    }

    String getCmdText() {
        return this.cmdText;
    }

    String getSoyDoc() {
        return this.soyDoc;
    }

    String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    protected AutoescapeMode getAutoescapeMode() {
        Preconditions.checkState((this.autoescapeMode != null ? 1 : 0) != 0);
        return this.autoescapeMode;
    }

    @Nullable
    public SanitizedContentKind getContentKind() {
        Preconditions.checkState((this.autoescapeMode != null ? 1 : 0) != 0);
        return this.contentKind;
    }

    public WhitespaceMode getWhitespaceMode() {
        return this.whitespaceMode;
    }

    protected ImmutableList<String> getRequiredCssNamespaces() {
        return (ImmutableList)Preconditions.checkNotNull(this.requiredCssNamespaces);
    }

    protected void setRequiredCssNamespaces(ImmutableList<String> requiredCssNamespaces) {
        this.requiredCssNamespaces = (ImmutableList)Preconditions.checkNotNull(requiredCssNamespaces);
    }

    protected String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    protected void setCssBaseNamespace(String cssBaseNamespace) {
        this.cssBaseNamespace = cssBaseNamespace;
    }

    protected final void setTemplateNames(String templateName, @Nullable String partialTemplateName) {
        this.templateName = templateName;
        this.partialTemplateName = partialTemplateName;
    }

    protected boolean getStrictHtmlDisabled() {
        return this.strictHtmlDisabled;
    }

    protected String getTemplateName() {
        return this.templateName;
    }

    @Nullable
    protected String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    private static String cleanSoyDocHelper(String soyDoc) {
        soyDoc = NEWLINE.matcher(soyDoc).replaceAll("\n");
        soyDoc = soyDoc.replace("@deprecated", "&#64;deprecated");
        soyDoc = SOY_DOC_START.matcher(soyDoc).replaceFirst("");
        soyDoc = SOY_DOC_END.matcher(soyDoc).replaceFirst("");
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)NEWLINE).split((CharSequence)soyDoc));
        TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        if (TemplateNodeBuilder.removeCommonStartCharHelper(lines, '*', false) == 1) {
            TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        }
        return Joiner.on((char)'\n').join((Iterable)lines);
    }

    private static int removeCommonStartCharHelper(List<String> lines, char charToRemove, boolean shouldRemoveMultiple) {
        int numCharsToRemove = 0;
        boolean isStillCounting = true;
        do {
            boolean areAllLinesEmpty = true;
            for (String line : lines) {
                if (line.length() == 0) continue;
                areAllLinesEmpty = false;
                if (line.length() > numCharsToRemove && line.charAt(numCharsToRemove) == charToRemove) continue;
                isStillCounting = false;
                break;
            }
            if (areAllLinesEmpty) {
                isStillCounting = false;
            }
            if (!isStillCounting) continue;
            ++numCharsToRemove;
        } while (isStillCounting && shouldRemoveMultiple);
        if (numCharsToRemove > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.length() == 0) continue;
                lines.set(i, line.substring(numCharsToRemove));
            }
        }
        return numCharsToRemove;
    }

    private static String parseSoyDocDescHelper(String cleanedSoyDoc) {
        Matcher paramMatcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        int endOfDescPos = paramMatcher.find() ? paramMatcher.start() : cleanedSoyDoc.length();
        String soyDocDesc = cleanedSoyDoc.substring(0, endOfDescPos);
        return CharMatcher.whitespace().trimTrailingFrom((CharSequence)soyDocDesc);
    }

    private List<SoyDocParam> parseSoyDocDeclsHelper(String originalSoyDoc, String cleanedSoyDoc, SourceLocation soyDocSourceLocation) {
        ArrayList<SoyDocParam> params = new ArrayList<SoyDocParam>();
        RawTextNode originalSoyDocAsNode = new RawTextNode(-1, originalSoyDoc, soyDocSourceLocation);
        Matcher matcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        boolean isFound = matcher.find();
        while (isFound) {
            String declKeyword = matcher.group(1);
            String declText = matcher.group(2);
            String fullMatch = matcher.group();
            int indexOfParamName = originalSoyDoc.indexOf(declText, originalSoyDoc.indexOf(fullMatch));
            SourceLocation paramLocation = originalSoyDocAsNode.substringLocation(indexOfParamName, indexOfParamName + declText.length());
            int descStart = matcher.end();
            isFound = matcher.find();
            int descEnd = isFound ? matcher.start() : cleanedSoyDoc.length();
            String desc = cleanedSoyDoc.substring(descStart, descEnd).trim();
            if (declKeyword.equals("@param") || declKeyword.equals("@param?")) {
                if (SOY_DOC_PARAM_TEXT_PATTERN.matcher(declText).matches()) {
                    params.add(new SoyDocParam(declText, declKeyword.equals("@param"), desc, paramLocation));
                    continue;
                }
                if (declText.startsWith("{")) {
                    this.errorReporter.report(paramLocation, LEGACY_COMPATIBLE_PARAM_TAG, declText);
                    continue;
                }
                this.errorReporter.report(paramLocation, INVALID_SOYDOC_PARAM, declText);
                continue;
            }
            throw new AssertionError();
        }
        return params;
    }
}

