/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.soytree.AutoValue_TemplateMetadata;
import com.google.template.soy.soytree.AutoValue_TemplateMetadata_DataAllCallSituation;
import com.google.template.soy.soytree.AutoValue_TemplateMetadata_Parameter;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

@AutoValue
public abstract class TemplateMetadata {
    public static TemplateMetadata fromTemplate(TemplateNode template) {
        Builder builder = TemplateMetadata.builder().setTemplateName(template.getTemplateName()).setSourceLocation(template.getSourceLocation()).setSoyFileKind(SoyFileKind.SRC).setContentKind(template.getContentKind()).setStrictHtml(template.isStrictHtml()).setDelPackageName(template.getDelPackageName()).setVisibility(template.getVisibility()).setParameters(Parameter.directParametersFromTemplate(template)).setDataAllCallSituations(DataAllCallSituation.fromTemplate(template));
        boolean hasSoyDocParams = false;
        for (TemplateParam param : template.getAllParams()) {
            if (param.declLoc() != TemplateParam.DeclLoc.SOY_DOC) continue;
            hasSoyDocParams = true;
            break;
        }
        builder.setHasSoyDocParams(hasSoyDocParams);
        switch (template.getKind()) {
            case TEMPLATE_BASIC_NODE: {
                builder.setTemplateKind(Kind.BASIC);
                break;
            }
            case TEMPLATE_DELEGATE_NODE: {
                builder.setTemplateKind(Kind.DELTEMPLATE);
                TemplateDelegateNode deltemplate = (TemplateDelegateNode)template;
                builder.setDelTemplateName(deltemplate.getDelTemplateName());
                builder.setDelTemplateVariant(deltemplate.getDelTemplateVariant());
                break;
            }
            case TEMPLATE_ELEMENT_NODE: {
                builder.setTemplateKind(Kind.ELEMENT);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected template kind: " + (Object)((Object)template.getKind())));
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new AutoValue_TemplateMetadata.Builder();
    }

    public abstract SoyFileKind getSoyFileKind();

    public abstract SourceLocation getSourceLocation();

    public abstract Kind getTemplateKind();

    public abstract String getTemplateName();

    @Nullable
    public abstract String getDelTemplateName();

    @Nullable
    public abstract String getDelTemplateVariant();

    @Nullable
    public abstract SanitizedContentKind getContentKind();

    public abstract boolean isStrictHtml();

    public abstract Visibility getVisibility();

    @Nullable
    public abstract String getDelPackageName();

    @Nullable
    public abstract TemplateNode getTemplateNode();

    public abstract ImmutableList<Parameter> getParameters();

    public abstract boolean getHasSoyDocParams();

    public abstract ImmutableList<DataAllCallSituation> getDataAllCallSituations();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSoyFileKind(SoyFileKind var1);

        public abstract Builder setSourceLocation(SourceLocation var1);

        public abstract Builder setTemplateKind(Kind var1);

        public abstract Builder setTemplateName(String var1);

        public abstract Builder setDelTemplateName(String var1);

        public abstract Builder setDelTemplateVariant(String var1);

        public abstract Builder setContentKind(@Nullable SanitizedContentKind var1);

        public abstract Builder setTemplateNode(@Nullable TemplateNode var1);

        public abstract Builder setStrictHtml(boolean var1);

        public abstract Builder setDelPackageName(@Nullable String var1);

        public abstract Builder setVisibility(Visibility var1);

        public abstract Builder setParameters(ImmutableList<Parameter> var1);

        public abstract Builder setHasSoyDocParams(boolean var1);

        public abstract Builder setDataAllCallSituations(ImmutableList<DataAllCallSituation> var1);

        public final TemplateMetadata build() {
            TemplateMetadata built = this.autobuild();
            if (built.getTemplateKind() == Kind.DELTEMPLATE) {
                Preconditions.checkState((built.getDelTemplateName() != null ? 1 : 0) != 0, (Object)"Deltemplates must have a deltemplateName");
                Preconditions.checkState((built.getDelTemplateVariant() != null ? 1 : 0) != 0, (Object)"Deltemplates must have a deltemplateName");
            } else {
                Preconditions.checkState((built.getDelTemplateVariant() == null ? 1 : 0) != 0, (Object)"non-Deltemplates must not have a variant");
                Preconditions.checkState((built.getDelTemplateName() == null ? 1 : 0) != 0, (Object)"non-Deltemplates must not have a deltemplateName");
            }
            return built;
        }

        abstract TemplateMetadata autobuild();
    }

    public static enum Kind {
        BASIC,
        DELTEMPLATE,
        ELEMENT;

    }

    @AutoValue
    public static abstract class DataAllCallSituation {
        static ImmutableList<DataAllCallSituation> fromTemplate(TemplateNode node) {
            ImmutableSet.Builder calls = ImmutableSet.builder();
            for (CallNode call : SoyTreeUtils.getAllNodesOfType(node, CallNode.class)) {
                if (!call.isPassingAllData()) continue;
                Builder builder = DataAllCallSituation.builder();
                ImmutableSet.Builder explicitlyPassedParams = ImmutableSet.builder();
                for (CallParamNode param : call.getChildren()) {
                    explicitlyPassedParams.add((Object)param.getKey().identifier());
                }
                builder.setExplicitlyPassedParameters((ImmutableSet<String>)explicitlyPassedParams.build());
                switch (call.getKind()) {
                    case CALL_BASIC_NODE: {
                        builder.setDelCall(false).setTemplateName(((CallBasicNode)call).getCalleeName());
                        break;
                    }
                    case CALL_DELEGATE_NODE: {
                        builder.setDelCall(true).setTemplateName(((CallDelegateNode)call).getDelCalleeName());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected call kind: " + (Object)((Object)call.getKind())));
                    }
                }
                calls.add((Object)builder.build());
            }
            return calls.build().asList();
        }

        public static Builder builder() {
            return new AutoValue_TemplateMetadata_DataAllCallSituation.Builder();
        }

        public abstract String getTemplateName();

        public abstract boolean isDelCall();

        public abstract ImmutableSet<String> getExplicitlyPassedParameters();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setTemplateName(String var1);

            public abstract Builder setDelCall(boolean var1);

            public abstract Builder setExplicitlyPassedParameters(ImmutableSet<String> var1);

            public abstract DataAllCallSituation build();
        }
    }

    @AutoValue
    public static abstract class Parameter {
        static ImmutableList<Parameter> directParametersFromTemplate(TemplateNode node) {
            ImmutableList.Builder params = ImmutableList.builder();
            for (TemplateParam param : node.getParams()) {
                params.add((Object)Parameter.builder().setName(param.name()).setType(param.type()).setRequired(param.isRequired()).build());
            }
            return params.build();
        }

        public static Builder builder() {
            return new AutoValue_TemplateMetadata_Parameter.Builder();
        }

        public abstract String getName();

        public SoyType getType() {
            return this.getTypeWrapper().getType();
        }

        abstract LazyTypeWrapper getTypeWrapper();

        public abstract boolean isRequired();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public Builder setTypeLazily(Supplier<SoyType> typeSupplier) {
                return this.setTypeWrapper(LazyTypeWrapper.fromSupplier(typeSupplier));
            }

            public Builder setType(SoyType type) {
                return this.setTypeWrapper(LazyTypeWrapper.constant(type));
            }

            abstract Builder setTypeWrapper(LazyTypeWrapper var1);

            public abstract Builder setRequired(boolean var1);

            public abstract Parameter build();
        }

        static abstract class LazyTypeWrapper {
            LazyTypeWrapper() {
            }

            static LazyTypeWrapper constant(final SoyType type) {
                return new LazyTypeWrapper(){

                    @Override
                    SoyType getType() {
                        return type;
                    }
                };
            }

            static LazyTypeWrapper fromSupplier(final Supplier<SoyType> typeSupplier) {
                return new LazyTypeWrapper(){
                    @LazyInit
                    SoyType type;

                    @Override
                    SoyType getType() {
                        SoyType local = this.type;
                        if (local == null) {
                            local = (SoyType)typeSupplier.get();
                            if (local == null) {
                                throw new IllegalStateException("typeSupplier returned null");
                            }
                            this.type = local;
                        }
                        return local;
                    }
                };
            }

            @ForOverride
            abstract SoyType getType();

            public final int hashCode() {
                return this.getType().hashCode();
            }

            public final boolean equals(Object other) {
                return other instanceof LazyTypeWrapper && ((LazyTypeWrapper)other).getType().equals(this.getType());
            }

            public String toString() {
                return this.getType().toString();
            }
        }
    }
}

