/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import java.util.List;
import java.util.Set;

public final class TemplateElementNodeBuilder
extends TemplateNodeBuilder<TemplateElementNodeBuilder> {
    private static final SoyErrorKind DUPLICATE_DECLARATION = SoyErrorKind.of("Param ''{0}'' is a duplicate of state var ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    protected static final ImmutableSet<String> BANNED_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"autoescape", (Object)"kind", (Object)"stricthtml", (Object)"visibility");
    private static final SoyErrorKind BANNED_ATTRIBUTE_NAMES_ERROR = SoyErrorKind.of("Attribute ''{0}'' is not allowed on Soy elements.", new SoyErrorKind.StyleAllowance[0]);
    private List<CommandTagAttribute> attrs = ImmutableList.of();
    private ImmutableList<TemplateStateVar> stateVars = ImmutableList.of();

    public TemplateElementNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
        this.setAutoescapeInfo(AutoescapeMode.STRICT, SanitizedContentKind.HTML, this.sourceLocation);
    }

    @Override
    public TemplateElementNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.attrs = attrs;
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.setTemplateNames(this.soyFileHeaderInfo.namespace + templateName.identifier(), templateName.identifier());
        return this;
    }

    public TemplateElementNodeBuilder setStateVars(List<TemplateStateVar> newStateVars) {
        this.stateVars = ImmutableList.copyOf(newStateVars);
        TemplateElementNodeBuilder.checkDuplicateHeaderVars((ImmutableList<? extends TemplateHeaderVarDefn>)this.params, this.stateVars, this.errorReporter);
        return this;
    }

    @Override
    public TemplateElementNodeBuilder addParams(Iterable<? extends TemplateParam> allParams) {
        super.addParams(allParams);
        TemplateElementNodeBuilder.checkDuplicateHeaderVars((ImmutableList<? extends TemplateHeaderVarDefn>)this.params, this.stateVars, this.errorReporter);
        return this;
    }

    @Override
    public TemplateElementNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        for (CommandTagAttribute attr : this.attrs) {
            if (!BANNED_ATTRIBUTE_NAMES.contains((Object)attr.getName().identifier())) continue;
            this.errorReporter.report(this.sourceLocation, BANNED_ATTRIBUTE_NAMES_ERROR, attr.getName().identifier());
        }
        return new TemplateElementNode(this, this.soyFileHeaderInfo, (ImmutableList<TemplateParam>)this.params, this.stateVars);
    }

    @VisibleForTesting
    static void checkDuplicateHeaderVars(ImmutableList<? extends TemplateHeaderVarDefn> params, ImmutableList<? extends TemplateHeaderVarDefn> stateVars, ErrorReporter errorReporter) {
        Set stateVarNames = (Set)stateVars.stream().map(VarDefn::name).collect(ImmutableSet.toImmutableSet());
        Iterable duplicateVars = Iterables.filter(params, param -> stateVarNames.contains(param.name()));
        for (TemplateHeaderVarDefn duplicateVar : duplicateVars) {
            errorReporter.report(duplicateVar.nameLocation(), DUPLICATE_DECLARATION, duplicateVar.name());
        }
    }
}

