/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MessagePlaceholders;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    private static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprRootNode expr;
    @Nullable
    private final String userSuppliedPlaceholderName;
    @Nullable
    private final String userSuppliedPlaceholderExample;
    @Nullable
    private HtmlContext htmlContext;

    public PrintNode(int id, SourceLocation location, boolean isImplicit, ExprNode expr, Iterable<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, isImplicit ? "" : "print");
        this.isImplicit = isImplicit;
        this.expr = new ExprRootNode(expr);
        String placeholderName = null;
        String placeholderExample = null;
        block8: for (CommandTagAttribute attribute : attributes) {
            switch (attribute.getName().identifier()) {
                case "phname": {
                    placeholderName = MessagePlaceholders.validatePlaceholderName(attribute.getValue(), attribute.getValueLocation(), errorReporter);
                    continue block8;
                }
                case "phex": {
                    placeholderExample = MessagePlaceholders.validatePlaceholderExample(attribute.getValue(), attribute.getValueLocation(), errorReporter);
                    continue block8;
                }
            }
            errorReporter.report(attribute.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attribute.getName().identifier(), "print", ImmutableList.of((Object)"phname", (Object)"phex"));
        }
        this.userSuppliedPlaceholderName = placeholderName;
        this.userSuppliedPlaceholderExample = placeholderExample;
    }

    private PrintNode(PrintNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isImplicit = orig.isImplicit;
        this.expr = orig.expr.copy(copyState);
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.userSuppliedPlaceholderExample = orig.userSuppliedPlaceholderExample;
        this.htmlContext = orig.htmlContext;
    }

    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor or InferenceEngine."));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhExample() {
        return this.userSuppliedPlaceholderExample;
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        return MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(this.expr.getRoot(), FALLBACK_BASE_PLACEHOLDER_NAME);
    }

    @Override
    public Object genSamenessKey() {
        return new SamenessKey(this);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public String getCommandText() {
        return this.doGetCommandText(true);
    }

    private String doGetCommandText(boolean includePhExample) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr.toSourceString());
        for (PrintDirectiveNode child : this.getChildren()) {
            sb.append(' ').append(child.toSourceString());
        }
        if (this.userSuppliedPlaceholderName != null) {
            sb.append(" phname=\"").append(this.userSuppliedPlaceholderName).append('\"');
        }
        if (includePhExample && this.userSuppliedPlaceholderExample != null) {
            sb.append(" phex=\"").append(this.userSuppliedPlaceholderExample).append('\"');
        }
        return sb.toString();
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public PrintNode copy(CopyState copyState) {
        return new PrintNode(this, copyState);
    }

    static final class PrintEquivalence
    extends Equivalence<PrintNode> {
        private static final PrintEquivalence INSTANCE = new PrintEquivalence();

        PrintEquivalence() {
        }

        static PrintEquivalence get() {
            return INSTANCE;
        }

        protected boolean doEquivalent(PrintNode a, PrintNode b) {
            ExprEquivalence exprEquivalence = ExprEquivalence.get();
            if (!exprEquivalence.equivalent(a.getExpr(), b.getExpr())) {
                return false;
            }
            List aDirectives = a.getChildren();
            List bDirectives = b.getChildren();
            if (aDirectives.size() != bDirectives.size()) {
                return false;
            }
            for (int i = 0; i < aDirectives.size(); ++i) {
                PrintDirectiveNode aDirective = (PrintDirectiveNode)aDirectives.get(i);
                PrintDirectiveNode bDirective = (PrintDirectiveNode)bDirectives.get(i);
                if (!aDirective.getName().equals(bDirective.getName())) {
                    return false;
                }
                ImmutableList<ExprRootNode> one = aDirective.getExprList();
                ImmutableList<ExprRootNode> two = bDirective.getExprList();
                if (exprEquivalence.pairwise().equivalent(one, two)) continue;
                return false;
            }
            return true;
        }

        protected int doHash(PrintNode t) {
            ExprEquivalence exprEquivalence = ExprEquivalence.get();
            int hc = exprEquivalence.hash(t.getExpr());
            for (PrintDirectiveNode child : t.getChildren()) {
                ImmutableList<ExprRootNode> list = child.getExprList();
                hc = 31 * hc + child.getName().hashCode();
                hc = 31 * hc + exprEquivalence.pairwise().hash(list);
            }
            return hc;
        }
    }

    private static final class SamenessKey {
        final PrintNode node;

        SamenessKey(PrintNode node) {
            this.node = node;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SamenessKey)) {
                return false;
            }
            PrintNode other = ((SamenessKey)obj).node;
            return Objects.equals(this.node.getUserSuppliedPhName(), other.getUserSuppliedPhName()) && PrintEquivalence.get().equivalent(this.node, other);
        }

        public int hashCode() {
            return Objects.hash(this.node.getUserSuppliedPhName(), PrintEquivalence.get().wrap(this.node));
        }
    }
}

