/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.SoyNode;

public final class ForNode
extends AbstractParentCommandNode<SoyNode.BlockNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode.BlockNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private final ExprRootNode expr;

    public ForNode(int id, SourceLocation location, ExprNode expr) {
        super(id, location, "for");
        this.expr = new ExprRootNode(expr);
    }

    private ForNode(ForNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    public boolean hasIfEmptyBlock() {
        return this.numChildren() > 1;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public String getCommandText() {
        return "$" + ((ForNonemptyNode)this.getChild(0)).getVarName() + " in " + this.expr.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public ForNode copy(CopyState copyState) {
        return new ForNode(this, copyState);
    }
}

