/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.Flags;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnionType;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TofuTypeChecks {
    private static final Logger logger = Logger.getLogger(TofuTypeChecks.class.getName());

    public static final boolean isInstance(SoyType type, SoyValue value, SourceLocation location) {
        switch (type.getKind()) {
            case ANY: 
            case UNKNOWN: {
                return true;
            }
            case ATTRIBUTES: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.ATTRIBUTES);
            }
            case CSS: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.CSS);
            }
            case BOOL: {
                return value instanceof BooleanData;
            }
            case FLOAT: {
                return value instanceof FloatData;
            }
            case HTML: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.HTML);
            }
            case INT: {
                return value instanceof IntegerData;
            }
            case JS: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.JS);
            }
            case LIST: {
                return value instanceof SoyList;
            }
            case MAP: {
                return value instanceof SoyMap;
            }
            case LEGACY_OBJECT_MAP: {
                return value instanceof SoyLegacyObjectMap;
            }
            case NULL: {
                return value == NullData.INSTANCE || value == UndefinedData.INSTANCE;
            }
            case PROTO: {
                return value instanceof SoyProtoValue && ((SoyProtoValue)value).getProto().getDescriptorForType() == ((SoyProtoType)type).getDescriptor();
            }
            case PROTO_ENUM: {
                return value instanceof IntegerData;
            }
            case RECORD: {
                return value instanceof SoyRecord;
            }
            case STRING: {
                if (Flags.stringIsNotSanitizedContent()) {
                    return value instanceof SoyString;
                }
                if (value instanceof SoyString && value instanceof SanitizedContent && ((SanitizedContent)value).getContentKind() != SanitizedContent.ContentKind.TEXT && logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, String.format("Passing in sanitized content into a template that accepts only string is forbidden. Please modify the template at %s to take in %s instead of just %s.", new Object[]{location != null ? location.toString() : "unknown", ((SanitizedContent)value).getContentKind(), type.toString()}));
                }
                return value instanceof SoyString || value instanceof SanitizedContent;
            }
            case TRUSTED_RESOURCE_URI: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
            }
            case UNION: {
                for (SoyType memberType : ((UnionType)type).getMembers()) {
                    if (!TofuTypeChecks.isInstance(memberType, value, location)) continue;
                    return true;
                }
                return false;
            }
            case URI: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.URI);
            }
            case VE: 
            case VE_DATA: {
                return value == NullData.INSTANCE;
            }
        }
        throw new AssertionError((Object)("invalid type: " + type));
    }

    private static boolean isSanitizedofKind(SoyValue value, SanitizedContent.ContentKind kind) {
        return value instanceof SanitizedContent && ((SanitizedContent)value).getContentKind() == kind;
    }
}

