/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RenderableThunk
implements SoyValueProvider {
    private String content;
    private SoyValue resolved;
    @Nullable
    private final SanitizedContent.ContentKind kind;

    protected RenderableThunk(@Nullable SanitizedContent.ContentKind kind) {
        this.kind = kind;
    }

    @Override
    public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
        if (this.content == null) {
            this.doResolveOnto(new TeeAppendable(appendable));
        } else {
            appendable.append(this.content);
        }
        return RenderResult.done();
    }

    @Override
    @Nonnull
    public SoyValue resolve() {
        if (this.resolved == null) {
            try {
                this.doResolveOnto(new StringBuilder());
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.resolved;
    }

    @Override
    @Nonnull
    public RenderResult status() {
        this.resolve();
        return RenderResult.done();
    }

    void doResolveOnto(Appendable appendable) throws IOException {
        this.doRender(appendable);
        this.content = appendable.toString();
        this.resolved = this.kind == null ? StringData.forValue(this.content) : UnsafeSanitizedContentOrdainer.ordainAsSafe(this.content, this.kind);
    }

    protected abstract void doRender(Appendable var1) throws IOException;

    private static final class TeeAppendable
    implements Appendable {
        final StringBuilder buffer = new StringBuilder();
        final Appendable delegate;

        TeeAppendable(Appendable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

