/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherAccumulatorNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherBlockNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherConditionNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraph;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherTagNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class HtmlTagMatchingPass {
    private static final SoyErrorKind INVALID_CLOSE_TAG = SoyErrorKind.of("''{0}'' tag is a void element and must not specify a close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_SELF_CLOSING_TAG = SoyErrorKind.of("''{0}'' tag is not allowed to be self-closing.", new SoyErrorKind.StyleAllowance[0]);
    private static final String UNEXPECTED_CLOSE_TAG = "Unexpected HTML close tag.";
    private static final String UNEXPECTED_CLOSE_TAG_KNOWN = "Unexpected HTML close tag. Expected to match the ''<{0}>'' at {1}.";
    private static final String NESTED_SVG = "Nested SVG tags are disallowed.";
    private static final String BLOCK_QUALIFIER = " Tags within a %s must be internally balanced.";
    private static final String UNEXPECTED_OPEN_TAG_ALWAYS = "This HTML open tag is never matched with a close tag.";
    private static final String UNEXPECTED_OPEN_TAG_SOMETIMES = "This HTML open tag does not consistently match with a close tag.";
    private static final Optional<HtmlTagNode> INVALID_NODE = Optional.absent();
    private final ErrorReporter errorReporter;
    private final IdGenerator idGenerator;
    private final boolean inCondition;
    private final boolean inForeignContent;
    @Nullable
    private final String parentBlockType;
    HashMultimap<HtmlTagNode, Optional<HtmlTagNode>> annotationMap = HashMultimap.create();

    public HtmlTagMatchingPass(ErrorReporter errorReporter, IdGenerator idGenerator, boolean inCondition, boolean inForeignContent, String parentBlockType) {
        this.inForeignContent = inForeignContent;
        this.parentBlockType = parentBlockType;
        this.errorReporter = errorReporter;
        this.idGenerator = idGenerator;
        this.inCondition = inCondition;
    }

    private SoyErrorKind makeSoyErrorKind(String soyError) {
        return SoyErrorKind.of(soyError + (this.parentBlockType != null ? String.format(BLOCK_QUALIFIER, this.parentBlockType) : ""), new SoyErrorKind.StyleAllowance[0]);
    }

    public void run(HtmlMatcherGraph htmlMatcherGraph) {
        if (!htmlMatcherGraph.getRootNode().isPresent()) {
            return;
        }
        this.visit((HtmlMatcherGraphNode)htmlMatcherGraph.getRootNode().get());
        for (HtmlTagNode tag : this.annotationMap.keySet()) {
            HtmlOpenTagNode openTag;
            if (!(tag instanceof HtmlOpenTagNode) || !this.annotationMap.containsEntry((Object)(openTag = (HtmlOpenTagNode)tag), INVALID_NODE)) continue;
            if (this.annotationMap.get((Object)openTag).size() == 1) {
                this.errorReporter.report(openTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_OPEN_TAG_ALWAYS), new Object[0]);
                continue;
            }
            this.errorReporter.report(openTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_OPEN_TAG_SOMETIMES), new Object[0]);
        }
        if (!this.errorReporter.getErrors().isEmpty() && this.inCondition) {
            return;
        }
        for (HtmlTagNode openTag : this.annotationMap.keySet()) {
            for (Optional closeTag : this.annotationMap.get((Object)openTag)) {
                if (!closeTag.isPresent()) continue;
                openTag.addTagPair((HtmlTagNode)closeTag.get());
                ((HtmlTagNode)closeTag.get()).addTagPair(openTag);
            }
        }
    }

    private void injectCloseTag(HtmlOpenTagNode optionalOpenTag, HtmlTagNode destinationTag, IdGenerator idGenerator) {
        SoyNode.StandaloneNode openTagCopy = optionalOpenTag.getTagName().getNode().copy(new CopyState());
        HtmlCloseTagNode syntheticClose = new HtmlCloseTagNode(idGenerator.genId(), openTagCopy, optionalOpenTag.getSourceLocation(), HtmlTagNode.TagExistence.SYNTHETIC);
        if (destinationTag == null) {
            int i = optionalOpenTag.getParent().getChildren().size();
            optionalOpenTag.getParent().addChild(i, syntheticClose);
        } else {
            ParentNode openTagParent = destinationTag.getParent();
            int i = openTagParent.getChildIndex(destinationTag);
            openTagParent.addChild(i, syntheticClose);
        }
        this.annotationMap.put((Object)optionalOpenTag, (Object)Optional.of((Object)syntheticClose));
        this.annotationMap.put((Object)syntheticClose, (Object)Optional.of((Object)optionalOpenTag));
    }

    private void visit(HtmlMatcherTagNode tagNode, Map<Equivalence.Wrapper<ExprNode>, Boolean> exprValueMap, HtmlStack stack) {
        HtmlTagNode tag = (HtmlTagNode)tagNode.getSoyNode().get();
        TagName openTagName = tag.getTagName();
        HtmlStack prev = stack;
        block0 : switch (tagNode.getTagKind()) {
            case VOID_TAG: {
                HtmlOpenTagNode voidTag = (HtmlOpenTagNode)tag;
                if (stack.inForeignContent || openTagName.isDefinitelyVoid() || !voidTag.isSelfClosing() || !openTagName.isStatic()) break;
                this.errorReporter.report(voidTag.getSourceLocation(), INVALID_SELF_CLOSING_TAG, openTagName.getStaticTagName());
                break;
            }
            case OPEN_TAG: {
                HtmlOpenTagNode optionalTag;
                HtmlOpenTagNode openTag = (HtmlOpenTagNode)tag;
                if (openTagName.isForeignContent() && stack.inForeignContent) {
                    this.errorReporter.report(openTag.getSourceLocation(), this.makeSoyErrorKind(NESTED_SVG), new Object[0]);
                }
                if (!prev.isEmpty() && (optionalTag = stack.tagNode).getTagName().isDefinitelyOptional() && TagName.checkOpenTagClosesOptional(openTag.getTagName(), optionalTag.getTagName())) {
                    this.injectCloseTag(optionalTag, openTag, this.idGenerator);
                    prev = prev.pop();
                }
                prev = prev.push(openTag, stack.inForeignContent || openTag.getTagName().isForeignContent());
                break;
            }
            case CLOSE_TAG: {
                HtmlCloseTagNode closeTag = (HtmlCloseTagNode)tag;
                if (closeTag.getTagName().isDefinitelyVoid()) {
                    this.errorReporter.report(closeTag.getTagName().getTagLocation(), INVALID_CLOSE_TAG, closeTag.getTagName().getStaticTagName());
                    break;
                }
                if (stack.isEmpty()) {
                    this.errorReporter.report(closeTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_CLOSE_TAG), new Object[0]);
                    break;
                }
                prev = stack;
                while (!prev.isEmpty()) {
                    HtmlOpenTagNode nextOpenTag = prev.tagNode;
                    if (nextOpenTag.getTagName().equals(closeTag.getTagName())) {
                        this.annotationMap.put((Object)nextOpenTag, (Object)Optional.of((Object)closeTag));
                        this.annotationMap.put((Object)closeTag, (Object)Optional.of((Object)nextOpenTag));
                        prev = prev.pop();
                        break block0;
                    }
                    if (nextOpenTag.getTagName().isDefinitelyOptional() && TagName.checkCloseTagClosesOptional(closeTag.getTagName(), nextOpenTag.getTagName())) {
                        this.injectCloseTag(nextOpenTag, closeTag, this.idGenerator);
                        prev = prev.pop();
                        continue;
                    }
                    this.annotationMap.put((Object)nextOpenTag, INVALID_NODE);
                    this.errorReporter.report(closeTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_CLOSE_TAG_KNOWN), nextOpenTag.getTagName(), nextOpenTag.getSourceLocation());
                    prev = prev.pop();
                }
                break;
            }
        }
        Optional<HtmlMatcherGraphNode> nextNode = tagNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        if (nextNode.isPresent()) {
            this.visit((HtmlMatcherGraphNode)nextNode.get(), exprValueMap, prev);
        } else {
            this.checkUnusedTags(prev);
        }
    }

    private void visit(HtmlMatcherBlockNode blockNode, Map<Equivalence.Wrapper<ExprNode>, Boolean> exprValueMap, HtmlStack stack) {
        Optional<HtmlMatcherGraphNode> nextNode;
        if (blockNode.getGraph().getRootNode().isPresent()) {
            new HtmlTagMatchingPass(this.errorReporter, this.idGenerator, false, stack.inForeignContent, blockNode.getParentBlockType()).run(blockNode.getGraph());
        }
        if ((nextNode = blockNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE)).isPresent()) {
            this.visit((HtmlMatcherGraphNode)nextNode.get(), exprValueMap, stack);
        } else {
            this.checkUnusedTags(stack);
        }
    }

    private void visit(HtmlMatcherConditionNode condNode, Map<Equivalence.Wrapper<ExprNode>, Boolean> exprValueMap, HtmlStack stack) {
        Equivalence.Wrapper condition = ExprEquivalence.get().wrap(condNode.getExpression());
        Boolean originalState = exprValueMap.getOrDefault(condition, null);
        Optional<HtmlMatcherGraphNode> nextNode = condNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        Optional<HtmlMatcherGraphNode> nextAltNode = condNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.FALSE_EDGE);
        if (!condNode.isInternallyBalanced(stack.inForeignContent, this.idGenerator) && nextNode.isPresent() && !Boolean.FALSE.equals(originalState)) {
            HashMap<Equivalence.Wrapper<ExprNode>, Boolean> lMap = new HashMap<Equivalence.Wrapper<ExprNode>, Boolean>(exprValueMap);
            lMap.put((Equivalence.Wrapper<ExprNode>)condition, true);
            this.visit((HtmlMatcherGraphNode)nextNode.get(), lMap, stack);
        }
        if (nextAltNode.isPresent() && !Boolean.TRUE.equals(originalState)) {
            HashMap<Equivalence.Wrapper<ExprNode>, Boolean> rMap = new HashMap<Equivalence.Wrapper<ExprNode>, Boolean>(exprValueMap);
            rMap.put((Equivalence.Wrapper<ExprNode>)condition, false);
            this.visit((HtmlMatcherGraphNode)nextAltNode.get(), rMap, stack);
        }
    }

    private void visit(HtmlMatcherAccumulatorNode accNode, Map<Equivalence.Wrapper<ExprNode>, Boolean> exprValueMap, HtmlStack stack) {
        Optional<HtmlMatcherGraphNode> nextNode = accNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        if (nextNode.isPresent()) {
            this.visit((HtmlMatcherGraphNode)nextNode.get(), exprValueMap, stack);
        } else {
            this.checkUnusedTags(stack);
        }
    }

    public void visit(HtmlMatcherGraphNode node) {
        this.visit(node, new HashMap<Equivalence.Wrapper<ExprNode>, Boolean>(), new HtmlStack(null, this.inForeignContent, null));
    }

    private void visit(HtmlMatcherGraphNode node, Map<Equivalence.Wrapper<ExprNode>, Boolean> exprValueMap, HtmlStack stack) {
        if (node instanceof HtmlMatcherTagNode) {
            this.visit((HtmlMatcherTagNode)node, exprValueMap, stack);
        } else if (node instanceof HtmlMatcherConditionNode) {
            this.visit((HtmlMatcherConditionNode)node, exprValueMap, stack);
        } else if (node instanceof HtmlMatcherAccumulatorNode) {
            this.visit((HtmlMatcherAccumulatorNode)node, exprValueMap, stack);
        } else if (node instanceof HtmlMatcherBlockNode) {
            this.visit((HtmlMatcherBlockNode)node, exprValueMap, stack);
        } else {
            throw new UnsupportedOperationException("No implementation for: " + node);
        }
    }

    private void checkUnusedTags(HtmlStack stack) {
        while (!stack.isEmpty()) {
            if (stack.tagNode.getTagName().isDefinitelyOptional() && !this.inCondition) {
                this.injectCloseTag(stack.tagNode, null, this.idGenerator);
            } else {
                this.annotationMap.put((Object)stack.tagNode, INVALID_NODE);
            }
            stack = stack.pop();
        }
    }

    class HtmlStack {
        final HtmlOpenTagNode tagNode;
        final boolean inForeignContent;
        final HtmlStack prev;

        HtmlStack(HtmlOpenTagNode tagNode, boolean inForeignContent, HtmlStack prev) {
            this.tagNode = tagNode;
            this.inForeignContent = inForeignContent;
            this.prev = prev;
        }

        HtmlStack push(HtmlOpenTagNode tagNode, boolean inForeignContent) {
            return new HtmlStack(tagNode, inForeignContent, this);
        }

        HtmlStack pop() {
            return this.prev;
        }

        boolean isEmpty() {
            return this.tagNode == null;
        }

        public String toString() {
            if (this.prev == null) {
                return "[START]";
            }
            return this.prev + "->" + this.tagNode.getTagName();
        }
    }
}

