/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraph;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.passes.htmlmatcher.HtmlTagMatchingPass;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class HtmlMatcherConditionNode
extends HtmlMatcherGraphNode {
    private final SoyNode soyNode;
    private HtmlMatcherGraphNode.EdgeKind activeEdge = HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE;
    private final ExprNode expression;
    private final HtmlMatcherGraph graph;
    @Nullable
    private HtmlMatcherGraphNode trueBranchNode = null;
    @Nullable
    private HtmlMatcherGraphNode falseBranchNode = null;
    private Optional<Boolean> isInternallyBalancedForForeignContent = Optional.absent();
    private Optional<Boolean> isInternallyBalanced = Optional.absent();

    public HtmlMatcherConditionNode(SoyNode soyNode, ExprNode expression, HtmlMatcherGraph graph) {
        this.soyNode = soyNode;
        this.expression = expression;
        this.graph = graph;
    }

    public HtmlMatcherConditionNode(SoyNode soyNode, ExprNode expression) {
        this.soyNode = soyNode;
        this.expression = expression;
        this.graph = null;
    }

    public ExprNode getExpression() {
        return this.expression;
    }

    public boolean isInternallyBalanced(boolean inForeignContent, IdGenerator idGenerator) {
        ErrorReporter errorReporter = ErrorReporter.createForTest();
        HtmlTagMatchingPass pass = new HtmlTagMatchingPass(errorReporter, idGenerator, true, inForeignContent, "condition");
        if (inForeignContent) {
            if (!this.isInternallyBalancedForForeignContent.isPresent()) {
                pass.run(this.graph);
                this.isInternallyBalancedForForeignContent = Optional.of((Object)errorReporter.getErrors().isEmpty());
            }
            return (Boolean)this.isInternallyBalancedForForeignContent.get();
        }
        if (!this.isInternallyBalanced.isPresent()) {
            pass.run(this.graph);
            this.isInternallyBalanced = Optional.of((Object)errorReporter.getErrors().isEmpty());
        }
        return (Boolean)this.isInternallyBalanced.get();
    }

    @Override
    public Optional<SoyNode> getSoyNode() {
        return Optional.of((Object)this.soyNode);
    }

    @Override
    public HtmlMatcherGraphNode.EdgeKind getActiveEdgeKind() {
        return this.activeEdge;
    }

    @Override
    public void setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        this.activeEdge = edgeKind;
    }

    @Override
    public void linkEdgeToNode(HtmlMatcherGraphNode.EdgeKind edgeKind, HtmlMatcherGraphNode node) {
        Preconditions.checkState((!this.equals(node) ? 1 : 0) != 0, (Object)"Cannot link a node to itself.");
        switch (edgeKind) {
            case TRUE_EDGE: {
                this.trueBranchNode = node;
                break;
            }
            case FALSE_EDGE: {
                this.falseBranchNode = node;
            }
        }
    }

    @Override
    public Optional<HtmlMatcherGraphNode> getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        switch (edgeKind) {
            case TRUE_EDGE: {
                return Optional.fromNullable((Object)this.trueBranchNode);
            }
            case FALSE_EDGE: {
                return Optional.fromNullable((Object)this.falseBranchNode);
            }
        }
        return Optional.absent();
    }
}

