/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.AbstractNode;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.VeType;

final class VeLogValidationPass
extends CompilerFilePass {
    private static final SoyErrorKind UNEXPECTED_DATA = SoyErrorKind.of("Unexpected data argument. The VE is type ''{0}'' which means there cannot be any data. The data is typed ''{1}'' and must match with the VE.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind WRONG_TYPE = SoyErrorKind.of("Expected an expression of type ''{0}'', instead got ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LOGONLY_DISALLOWED_IN_MSG = SoyErrorKind.of("The logonly attribute may not be set on '''{velog}''' nodes in '''{msg}''' context. Consider moving the logonly content into another template and calling it, or refactoring your '''{msg}''' into multiple distinct messages.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REQUIRE_STRICTHTML = SoyErrorKind.of("The '{'velog ...'}' command can only be used in templates with stricthtml=\"true\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_LOGGING_FUNCTION_LOCATION = SoyErrorKind.of("The logging function ''{0}'' can only be evaluated in a print command that is the only direct child of an html attribute value.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NO_PRINT_DIRECTIVES = SoyErrorKind.of("The logging function ''{0}'' can only be evaluated in a print command with no print directives.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNKNOWN_PROTO = SoyErrorKind.of("Unknown proto type ''{0}'' configured for use with this VE.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_DATA_TYPE = SoyErrorKind.of("Illegal VE metadata type ''{0}'' for this VE. The metadata must be a proto.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VE = SoyErrorKind.of("The velog command requires a VE identifier, an expression of the ''ve'' type or an expression of the ''ve_data'' type. Found an expression of type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VE_UNION_WITH_DATA = SoyErrorKind.of("It is illegal to set the data parameter if the ve type is a union (''{0}'').", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter reporter;
    private final SoyTypeRegistry typeRegistry;

    VeLogValidationPass(ErrorReporter reporter, SoyTypeRegistry typeRegistry) {
        this.reporter = reporter;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            for (AbstractNode node : SoyTreeUtils.getAllFunctionInvocations(template, BuiltinFunction.VE_DATA)) {
                this.validateVeDataFunctionNode((FunctionNode)node);
            }
            for (AbstractNode node : SoyTreeUtils.getAllNodesOfType(template, VeLogNode.class)) {
                if (template.isStrictHtml()) {
                    this.validateVeLogNode((VeLogNode)node);
                    continue;
                }
                this.reporter.report(((VeLogNode)node).getVeDataExpression().getSourceLocation(), REQUIRE_STRICTHTML, new Object[0]);
            }
            for (SoyNode.ExprHolderNode holderNode : SoyTreeUtils.getAllNodesOfType(template, SoyNode.ExprHolderNode.class)) {
                for (ExprRootNode rootNode : holderNode.getExprList()) {
                    for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(rootNode, FunctionNode.class)) {
                        if (!(function.getSoyFunction() instanceof LoggingFunction)) continue;
                        this.validateLoggingFunction(holderNode, function);
                    }
                }
            }
        }
    }

    private void validateLoggingFunction(SoyNode.ExprHolderNode holderNode, FunctionNode function) {
        if (function.getParent().getKind() != ExprNode.Kind.EXPR_ROOT_NODE) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It is part of complex expression.");
            return;
        }
        if (holderNode.getKind() != SoyNode.Kind.PRINT_NODE) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It isn't in a print node.");
            return;
        }
        PrintNode printNode = (PrintNode)holderNode;
        if (printNode.numChildren() != 0) {
            this.reporter.report(((PrintDirectiveNode)printNode.getChild(0)).getSourceLocation(), NO_PRINT_DIRECTIVES, function.getFunctionName());
        }
        if (holderNode.getParent().getKind() != SoyNode.Kind.HTML_ATTRIBUTE_VALUE_NODE) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It isn't the direct child of an attribute value.");
            return;
        }
        if (holderNode.getParent().numChildren() > 1) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It has sibling nodes in the attribute value.");
            return;
        }
    }

    private void validateVeLogNode(VeLogNode node) {
        if (node.getVeDataExpression().getRoot().getType().getKind() != SoyType.Kind.VE_DATA) {
            this.reporter.report(node.getVeDataExpression().getSourceLocation(), INVALID_VE, node.getVeDataExpression().getRoot().getType());
        }
        if (node.getLogonlyExpression() != null) {
            SoyType type;
            if (VeLogValidationPass.isInMsgNode(node)) {
                this.reporter.report(node.getLogonlyExpression().getSourceLocation(), LOGONLY_DISALLOWED_IN_MSG, new Object[0]);
            }
            if ((type = node.getLogonlyExpression().getType()).getKind() != SoyType.Kind.BOOL) {
                this.reporter.report(node.getLogonlyExpression().getSourceLocation(), WRONG_TYPE, BoolType.getInstance(), type);
            }
        }
    }

    private void validateVeDataFunctionNode(FunctionNode node) {
        if (node.numChildren() < 1 || node.numChildren() > 2) {
            return;
        }
        ExprNode veExpr = node.getChild(0);
        ExprNode dataExpr = node.getChild(1);
        if (veExpr.getType().getKind() == SoyType.Kind.ERROR) {
            return;
        }
        if (veExpr.getType().getKind() == SoyType.Kind.VE) {
            if (dataExpr.getType().getKind() != SoyType.Kind.NULL) {
                VeType veType = (VeType)veExpr.getType();
                SoyType dataType = dataExpr.getType();
                if (!veType.getDataType().isPresent()) {
                    this.reporter.report(dataExpr.getSourceLocation(), UNEXPECTED_DATA, veType, dataType);
                } else {
                    SoyType veDataType = this.typeRegistry.getType((String)veType.getDataType().get());
                    if (veDataType == null) {
                        this.reporter.report(veExpr.getSourceLocation(), UNKNOWN_PROTO, veType.getDataType().get());
                    } else if (veDataType.getKind() != SoyType.Kind.PROTO) {
                        this.reporter.report(veExpr.getSourceLocation(), BAD_DATA_TYPE, veDataType);
                    } else if (!dataType.equals(veDataType)) {
                        this.reporter.report(dataExpr.getSourceLocation(), WRONG_TYPE, veType.getDataType().get(), dataType);
                    }
                }
            }
        } else if (SoyTypes.isKindOrUnionOfKind(veExpr.getType(), SoyType.Kind.VE)) {
            if (dataExpr.getType().getKind() != SoyType.Kind.NULL) {
                this.reporter.report(dataExpr.getSourceLocation(), VE_UNION_WITH_DATA, veExpr.getType());
            }
        } else {
            this.reporter.report(veExpr.getSourceLocation(), WRONG_TYPE, "ve", veExpr.getType());
        }
    }

    private static boolean isInMsgNode(SoyNode node) {
        if (node instanceof MsgNode) {
            return true;
        }
        ParentNode parent = node.getParent();
        if (parent instanceof SoyNode.MsgBlockNode || parent instanceof SoyNode.MsgSubstUnitNode) {
            return VeLogValidationPass.isInMsgNode((SoyNode)((Object)parent));
        }
        return false;
    }
}

