/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.ast.TypeNodeConverter;

final class ResolveHeaderParamTypesPass
extends CompilerFilePass {
    private final TypeNodeConverter converter;

    ResolveHeaderParamTypesPass(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter) {
        this.converter = new TypeNodeConverter(errorReporter, typeRegistry);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            for (TemplateParam param : template.getAllParams()) {
                HeaderParam hp;
                if (!(param instanceof HeaderParam) || (hp = (HeaderParam)param).getTypeNode() == null) continue;
                hp.setType(this.converter.getOrCreateType(hp.getTypeNode()));
            }
            if (!(template instanceof TemplateElementNode)) continue;
            for (TemplateStateVar state : ((TemplateElementNode)template).getStateVars()) {
                if (state.getTypeNode() == null) continue;
                state.setType(this.converter.getOrCreateType(state.getTypeNode()));
            }
        }
    }
}

