/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.plugin.java.internal.PluginInstanceFinder;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyDeprecated;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.Map;
import java.util.Set;

public final class PluginResolver {
    private static final SoyErrorKind UNKNOWN_PLUGIN = SoyErrorKind.of("Unknown {0} ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DEPRECATED_PLUGIN = SoyErrorKind.of("{0} is deprecated: {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION, SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind INCORRECT_NUM_ARGS = SoyErrorKind.of("{0} called with {1} arguments (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLUGIN_NAME_NOT_ALLOWED = SoyErrorKind.of("Plugins named ''{0}'' are not allowed, since they conflict with Soy''s {0}() literal syntax.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DIFFERENT_IMPLS_REGISTERED = SoyErrorKind.of("Plugin named ''{0}'' has two different implementations registered: ''{1}'' and ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_FUNCTION_SIGNATURE = SoyErrorKind.of("Plugin class ''{0}'' has no @SoyFunctionSignature annotation. Classes implementing SoySourceFunction must be annotated with @SoyFunctionSignature.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_PLUGIN_INSTANCES = SoyErrorKind.of("Plugin class ''{0}'' uses callInstanceMethod for methods on multiple classes {1}. SoyJavaSourceFunctions must only use a single class for callInstanceMethod.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoySourceFunction ERROR_PLACEHOLDER_FUNCTION = new SoySourceFunction(){};
    private final Mode mode;
    private final ImmutableMap<String, SoyPrintDirective> printDirectives;
    private final ImmutableMap<String, Object> functions;
    private final ErrorReporter reporter;

    public static PluginResolver nullResolver(Mode mode, ErrorReporter reporter) {
        return new PluginResolver(mode, (ImmutableMap<String, SoyPrintDirective>)ImmutableMap.of(), (ImmutableMap<String, SoyFunction>)ImmutableMap.of(), (ImmutableMap<String, SoySourceFunction>)ImmutableMap.of(), reporter);
    }

    public PluginResolver(Mode mode, ImmutableMap<String, SoyPrintDirective> soyPrintDirectives, ImmutableMap<String, SoyFunction> soyFunctions, ImmutableMap<String, SoySourceFunction> sourceFunctions, ErrorReporter reporter) {
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        this.printDirectives = (ImmutableMap)Preconditions.checkNotNull(soyPrintDirectives);
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
        for (String illegalName : BaseUtils.ILLEGAL_PLUGIN_NAMES) {
            if (!soyFunctions.containsKey((Object)illegalName) && !sourceFunctions.containsKey((Object)illegalName)) continue;
            reporter.report(SourceLocation.UNKNOWN, PLUGIN_NAME_NOT_ALLOWED, illegalName);
        }
        ImmutableMap.Builder mergedFunctions = ImmutableMap.builder();
        for (Map.Entry entry : soyFunctions.entrySet()) {
            SoySourceFunction source = (SoySourceFunction)sourceFunctions.get(entry.getKey());
            if (source != null) {
                if (source == entry.getValue()) continue;
                reporter.report(SourceLocation.UNKNOWN, DIFFERENT_IMPLS_REGISTERED, entry.getKey(), entry.getValue(), source);
                continue;
            }
            mergedFunctions.put(entry.getKey(), entry.getValue());
        }
        mergedFunctions.putAll(sourceFunctions);
        this.functions = mergedFunctions.build();
        for (Object function : this.functions.values()) {
            Set<Class<?>> instances;
            if (!(function instanceof SoySourceFunction)) continue;
            if (!function.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                reporter.report(SourceLocation.UNKNOWN, MISSING_FUNCTION_SIGNATURE, function.getClass().getName());
                continue;
            }
            if (!(function instanceof SoyJavaSourceFunction) || (instances = PluginInstanceFinder.find((SoyJavaSourceFunction)function)).size() <= 1) continue;
            reporter.report(SourceLocation.UNKNOWN, MULTIPLE_PLUGIN_INSTANCES, function.getClass().getName(), instances);
        }
    }

    public SoyPrintDirective lookupPrintDirective(String name, int numArgs, SourceLocation location) {
        SoyPrintDirective soyPrintDirective = (SoyPrintDirective)this.printDirectives.get((Object)name);
        if (soyPrintDirective == null) {
            this.reportMissing(location, "print directive", name, (Set<String>)this.printDirectives.keySet());
            soyPrintDirective = PluginResolver.createPlaceholderPrintDirective(name, numArgs);
        }
        this.checkNumArgs("print directive", soyPrintDirective.getValidArgsSizes(), numArgs, location);
        this.warnIfDeprecated(name, soyPrintDirective, location);
        return soyPrintDirective;
    }

    public Object lookupSoyFunction(String name, int numArgs, SourceLocation location) {
        Object soyFunction = this.functions.get((Object)name);
        if (soyFunction == null) {
            this.reportMissing(location, "function", name, (Set<String>)this.functions.keySet());
            return ERROR_PLACEHOLDER_FUNCTION;
        }
        Set<Integer> validArgsSize = soyFunction instanceof SoyFunction ? ((SoyFunction)soyFunction).getValidArgsSizes() : PluginResolver.getValidArgsSizes(soyFunction.getClass().getAnnotation(SoyFunctionSignature.class).value());
        this.checkNumArgs("function", validArgsSize, numArgs, location);
        this.warnIfDeprecated(name, soyFunction, location);
        return soyFunction;
    }

    private void reportMissing(SourceLocation location, String type, String name, Set<String> alternatives) {
        String didYouMean = SoyErrors.getDidYouMeanMessage(alternatives, name);
        switch (this.mode) {
            case REQUIRE_DEFINITIONS: {
                this.reporter.report(location, UNKNOWN_PLUGIN, type, name, didYouMean);
                break;
            }
            case ALLOW_UNDEFINED_AND_WARN: {
                this.reporter.warn(location, UNKNOWN_PLUGIN, type, name, didYouMean);
                break;
            }
        }
    }

    private static Set<Integer> getValidArgsSizes(Signature[] signatures) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Signature signature : signatures) {
            builder.add((Object)signature.parameterTypes().length);
        }
        return builder.build();
    }

    private void checkNumArgs(String pluginKind, Set<Integer> arities, int actualNumArgs, SourceLocation location) {
        if (!arities.contains(actualNumArgs)) {
            this.reporter.report(location, INCORRECT_NUM_ARGS, pluginKind, actualNumArgs, Joiner.on((String)" or ").join(arities));
        }
    }

    private void warnIfDeprecated(String name, Object plugin, SourceLocation location) {
        SoyDeprecated deprecatedNotice = plugin.getClass().getAnnotation(SoyDeprecated.class);
        if (deprecatedNotice != null) {
            this.reporter.warn(location, DEPRECATED_PLUGIN, name, deprecatedNotice.value());
        }
    }

    private static SoyPrintDirective createPlaceholderPrintDirective(final String name, int arity) {
        final ImmutableSet validArgSizes = ImmutableSet.of((Object)arity);
        return new SoyPrintDirective(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return validArgSizes;
            }
        };
    }

    public static enum Mode {
        ALLOW_UNDEFINED,
        ALLOW_UNDEFINED_AND_WARN,
        REQUIRE_DEFINITIONS;

    }
}

