/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.AddDebugAttributesPass;
import com.google.template.soy.passes.AssertStrictAutoescapingPass;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.BasicHtmlValidationPass;
import com.google.template.soy.passes.CalculateMsgSubstitutionInfoPass;
import com.google.template.soy.passes.CheckBadContextualUsagePass;
import com.google.template.soy.passes.CheckDeclaredTypesPass;
import com.google.template.soy.passes.CheckDelegatesPass;
import com.google.template.soy.passes.CheckEscapingSanityFilePass;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CheckNonEmptyMsgNodesPass;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CheckTemplateHeaderVarsPass;
import com.google.template.soy.passes.CheckTemplateVisibilityPass;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.CompilerPass;
import com.google.template.soy.passes.ContentSecurityPolicyNonceInjectionPass;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.passes.InsertMsgPlaceholderNodesPass;
import com.google.template.soy.passes.KeyCommandPass;
import com.google.template.soy.passes.MsgWithIdFunctionPass;
import com.google.template.soy.passes.OptimizationPass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolveHeaderParamTypesPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePackageRelativeCssNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RewriteGenderMsgsPass;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RewriteRemaindersPass;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.passes.StrictDepsPass;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.passes.V1ExpressionPass;
import com.google.template.soy.passes.ValidateAliasesPass;
import com.google.template.soy.passes.VeLogRewritePass;
import com.google.template.soy.passes.VeLogValidationPass;
import com.google.template.soy.passes.VeRewritePass;
import com.google.template.soy.passes.XidPass;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Map;

public final class PassManager {
    @VisibleForTesting
    final ImmutableList<CompilerFilePass> singleFilePasses;
    @VisibleForTesting
    final ImmutableList<CompilerFileSetPass> crossTemplateCheckingPasses;

    private PassManager(ImmutableList<CompilerFilePass> singleFilePasses, ImmutableList<CompilerFileSetPass> crossTemplateCheckingPasses) {
        this.singleFilePasses = singleFilePasses;
        this.crossTemplateCheckingPasses = crossTemplateCheckingPasses;
    }

    public void runSingleFilePasses(SoyFileNode file, IdGenerator nodeIdGen) {
        for (CompilerFilePass pass : this.singleFilePasses) {
            pass.run(file, nodeIdGen);
        }
    }

    public void runWholeFilesetPasses(SoyFileSetNode soyTree, TemplateRegistry templateRegistry) {
        CompilerFileSetPass pass;
        CompilerFileSetPass.Result result;
        ImmutableList sourceFiles = ImmutableList.copyOf(soyTree.getChildren());
        IdGenerator idGenerator = soyTree.getNodeIdGenerator();
        UnmodifiableIterator unmodifiableIterator = this.crossTemplateCheckingPasses.iterator();
        while (unmodifiableIterator.hasNext() && (result = (pass = (CompilerFileSetPass)unmodifiableIterator.next()).run((ImmutableList<SoyFileNode>)sourceFiles, idGenerator, templateRegistry)) != CompilerFileSetPass.Result.STOP) {
        }
    }

    public static final class Builder {
        private SoyTypeRegistry registry;
        private PluginResolver pluginResolver;
        private ImmutableMap<String, ? extends SoyPrintDirective> soyPrintDirectives;
        private ErrorReporter errorReporter;
        private SoyGeneralOptions options;
        private boolean allowUnknownGlobals;
        private boolean allowV1Expression;
        private boolean disableAllTypeChecking;
        private boolean desugarHtmlNodes = true;
        private boolean optimize = true;
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ValidatedLoggingConfig loggingConfig = ValidatedLoggingConfig.EMPTY;
        private boolean autoescaperEnabled = true;
        private boolean addHtmlAttributesForDebugging = true;
        private final Map<String, PassContinuationRule> passContinuationRegistry = Maps.newHashMap();
        private boolean building;

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
            return this;
        }

        public Builder setSoyPrintDirectiveMap(ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
            this.soyPrintDirectives = (ImmutableMap)Preconditions.checkNotNull(printDirectives);
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry registry) {
            this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)registry);
            return this;
        }

        public Builder setPluginResolver(PluginResolver pluginResolver) {
            this.pluginResolver = pluginResolver;
            return this;
        }

        public Builder setGeneralOptions(SoyGeneralOptions options) {
            this.options = options;
            return this;
        }

        public Builder disableAllTypeChecking() {
            this.disableAllTypeChecking = true;
            return this;
        }

        public Builder allowUnknownGlobals() {
            this.allowUnknownGlobals = true;
            return this;
        }

        public Builder allowV1Expression() {
            this.allowV1Expression = true;
            return this;
        }

        public Builder desugarHtmlNodes(boolean desugarHtmlNodes) {
            this.desugarHtmlNodes = desugarHtmlNodes;
            return this;
        }

        public Builder optimize(boolean optimize) {
            this.optimize = optimize;
            return this;
        }

        public Builder addHtmlAttributesForDebugging(boolean addHtmlAttributesForDebugging) {
            this.addHtmlAttributesForDebugging = addHtmlAttributesForDebugging;
            return this;
        }

        public Builder setConformanceConfig(ValidatedConformanceConfig conformanceConfig) {
            this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
            return this;
        }

        public Builder setLoggingConfig(ValidatedLoggingConfig loggingConfig) {
            this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)loggingConfig);
            return this;
        }

        public Builder setAutoescaperEnabled(boolean autoescaperEnabled) {
            this.autoescaperEnabled = autoescaperEnabled;
            return this;
        }

        public Builder addPassContinuationRule(String passName, PassContinuationRule rule) {
            Preconditions.checkNotNull((Object)((Object)rule));
            this.passContinuationRegistry.put(passName, rule);
            return this;
        }

        public PassManager build() {
            this.building = true;
            ImmutableList.Builder singleFilePassesBuilder = ImmutableList.builder();
            this.addPass(new ResolveHeaderParamTypesPass(this.registry, this.errorReporter), singleFilePassesBuilder);
            this.addPass(new BasicHtmlValidationPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new ResolvePluginsPass(this.pluginResolver, this.registry), singleFilePassesBuilder);
            this.addPass(new SoyConformancePass(this.conformanceConfig, this.errorReporter), singleFilePassesBuilder);
            this.addPass(new ContentSecurityPolicyNonceInjectionPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new InsertMsgPlaceholderNodesPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new RewriteRemaindersPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new RewriteGenderMsgsPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new CalculateMsgSubstitutionInfoPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new CheckNonEmptyMsgNodesPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new VeRewritePass(), singleFilePassesBuilder);
            this.addPass(new RewriteGlobalsPass(this.registry, this.options.getCompileTimeGlobals(), this.errorReporter), singleFilePassesBuilder);
            this.addPass(new XidPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new V1ExpressionPass(this.allowV1Expression, this.errorReporter), singleFilePassesBuilder);
            this.addPass(new ResolveNamesPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new MsgWithIdFunctionPass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new CheckEscapingSanityFilePass(this.errorReporter), singleFilePassesBuilder);
            this.addPass(new StrictHtmlValidationPass(this.errorReporter), singleFilePassesBuilder);
            if (this.addHtmlAttributesForDebugging) {
                this.addPass(new AddDebugAttributesPass(), singleFilePassesBuilder);
            }
            if (!this.disableAllTypeChecking) {
                this.addPass(new CheckDeclaredTypesPass(this.errorReporter), singleFilePassesBuilder);
                this.addPass(new ResolveExpressionTypesPass(this.registry, this.errorReporter, this.loggingConfig), singleFilePassesBuilder);
                this.addPass(new VeLogRewritePass(), singleFilePassesBuilder);
                this.addPass(new VeLogValidationPass(this.errorReporter, this.registry), singleFilePassesBuilder);
            }
            this.addPass(new ResolvePackageRelativeCssNamesPass(this.errorReporter), singleFilePassesBuilder);
            if (!this.allowUnknownGlobals) {
                this.addPass(new CheckGlobalsPass(this.errorReporter), singleFilePassesBuilder);
            }
            this.addPass(new ValidateAliasesPass(this.registry, this.errorReporter, this.options, this.loggingConfig), singleFilePassesBuilder);
            if (this.options.isStrictAutoescapingRequired() == TriState.ENABLED) {
                this.addPass(new AssertStrictAutoescapingPass(this.errorReporter), singleFilePassesBuilder);
            }
            this.addPass(new KeyCommandPass(this.errorReporter, this.disableAllTypeChecking), singleFilePassesBuilder);
            this.addPass(new SoyElementPass(this.errorReporter), singleFilePassesBuilder);
            ImmutableList.Builder crossTemplateCheckingPassesBuilder = ImmutableList.builder();
            this.addPass(new CheckTemplateHeaderVarsPass(this.errorReporter), crossTemplateCheckingPassesBuilder);
            if (!this.disableAllTypeChecking) {
                this.addPass(new CheckTemplateCallsPass(this.errorReporter), crossTemplateCheckingPassesBuilder);
            }
            this.addPass(new CheckTemplateVisibilityPass(this.errorReporter), crossTemplateCheckingPassesBuilder);
            this.addPass(new CheckDelegatesPass(this.errorReporter), crossTemplateCheckingPassesBuilder);
            if (this.options.allowExternalCalls() == TriState.DISABLED) {
                this.addPass(new StrictDepsPass(this.errorReporter), crossTemplateCheckingPassesBuilder);
            }
            if (this.autoescaperEnabled) {
                this.addPass(new AutoescaperPass(this.errorReporter, this.soyPrintDirectives), crossTemplateCheckingPassesBuilder);
                if (!this.disableAllTypeChecking) {
                    this.addPass(new CheckBadContextualUsagePass(this.errorReporter), crossTemplateCheckingPassesBuilder);
                }
            }
            if (this.desugarHtmlNodes) {
                this.addPass(new DesugarHtmlNodesPass(), crossTemplateCheckingPassesBuilder);
            }
            if (this.optimize && this.options.isOptimizerEnabled()) {
                this.addPass(new OptimizationPass(), crossTemplateCheckingPassesBuilder);
            }
            this.addPass(new CombineConsecutiveRawTextNodesPass(), crossTemplateCheckingPassesBuilder);
            this.building = false;
            if (!this.passContinuationRegistry.isEmpty()) {
                throw new IllegalStateException("The following continuation rules don't match any pass: " + this.passContinuationRegistry);
            }
            return new PassManager(singleFilePassesBuilder.build(), crossTemplateCheckingPassesBuilder.build());
        }

        <T extends CompilerPass> void addPass(T pass, ImmutableList.Builder<T> builder) {
            PassContinuationRule rule = this.passContinuationRegistry.remove(pass.name());
            if (!this.building) {
                return;
            }
            if (rule == null) {
                builder.add(pass);
                return;
            }
            switch (rule) {
                case STOP_AFTER_PASS: {
                    builder.add(pass);
                }
                case STOP_BEFORE_PASS: {
                    this.building = false;
                    return;
                }
            }
            throw new AssertionError((Object)("unhandled rule: " + (Object)((Object)rule)));
        }
    }

    public static enum PassContinuationRule {
        STOP_BEFORE_PASS,
        STOP_AFTER_PASS;

    }
}

