/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class CheckTemplateHeaderVarsPass
extends CompilerFileSetPass {
    private static final SoyErrorKind UNDECLARED_DATA_KEY = SoyErrorKind.of("Unknown data key ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNUSED_PARAM = SoyErrorKind.of("Param ''{0}'' unused in template body.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNUSED_STATE = SoyErrorKind.of("State var ''{0}'' unused in template body.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckTemplateHeaderVarsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode fileNode : sourceFiles) {
            for (TemplateNode templateNode : fileNode.getChildren()) {
                this.checkTemplate(templateNode, registry);
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplate(TemplateNode node, TemplateRegistry templateRegistry) {
        ArrayListMultimap dataKeys = ArrayListMultimap.create();
        for (VarRefNode varRefNode : SoyTreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
            if (!varRefNode.isPossibleHeaderVar().booleanValue()) continue;
            dataKeys.put((Object)varRefNode.getName(), (Object)varRefNode.getSourceLocation());
        }
        IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(templateRegistry).calculateIndirectParams(templateRegistry.getMetadata(node));
        HashSet<String> allHeaderVarNames = new HashSet<String>();
        ArrayList<TemplateHeaderVarDefn> unusedParams = new ArrayList<TemplateHeaderVarDefn>();
        for (TemplateParam param : node.getAllParams()) {
            allHeaderVarNames.add(param.name());
            if (dataKeys.containsKey((Object)param.name())) {
                dataKeys.removeAll((Object)param.name());
                continue;
            }
            if (ipi.paramKeyToCalleesMultimap.containsKey((Object)param.name()) || ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) continue;
            unusedParams.add(param);
        }
        ArrayList<TemplateHeaderVarDefn> unusedStateVars = new ArrayList<TemplateHeaderVarDefn>();
        if (node instanceof TemplateElementNode) {
            TemplateElementNode el = (TemplateElementNode)node;
            for (TemplateStateVar stateVar : el.getStateVars()) {
                allHeaderVarNames.add(stateVar.name());
                if (dataKeys.containsKey((Object)stateVar.name())) {
                    dataKeys.removeAll((Object)stateVar.name());
                    continue;
                }
                unusedStateVars.add(stateVar);
            }
        }
        for (Map.Entry undeclared : dataKeys.entries()) {
            String extraErrorMessage = SoyErrors.getDidYouMeanMessage(allHeaderVarNames, (String)undeclared.getKey());
            this.errorReporter.report((SourceLocation)undeclared.getValue(), UNDECLARED_DATA_KEY, undeclared.getKey(), extraErrorMessage);
        }
        if (node instanceof TemplateBasicNode) {
            CheckTemplateHeaderVarsPass.reportUnusedHeaderVars(this.errorReporter, unusedParams, UNUSED_PARAM);
        }
        if (node instanceof TemplateElementNode) {
            CheckTemplateHeaderVarsPass.reportUnusedHeaderVars(this.errorReporter, unusedStateVars, UNUSED_STATE);
        }
    }

    private static void reportUnusedHeaderVars(ErrorReporter errorReporter, List<TemplateHeaderVarDefn> unusedHeaderVars, SoyErrorKind soyError) {
        for (TemplateHeaderVarDefn unusedVar : unusedHeaderVars) {
            errorReporter.report(unusedVar.nameLocation(), soyError, unusedVar.name());
        }
    }
}

