/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

final class CheckTemplateCallsPass
extends CompilerFileSetPass {
    static final SoyErrorKind ARGUMENT_TYPE_MISMATCH = SoyErrorKind.of("Type mismatch on param {0}: expected: {1}, actual: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_PARAM = SoyErrorKind.of("Duplicate param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSES_UNUSED_PARAM = SoyErrorKind.of("''{0}'' is not a declared parameter of {1} or any indirect callee.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSING_PROTOBUF_FROM_STRICT_TO_NON_STRICT = SoyErrorKind.of("Passing protobuf {0} of type {1} to an untyped template is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_HTML = SoyErrorKind.of("Found call to non stricthtml template. Strict HTML template can only call other strict HTML templates from an HTML context.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private static final ImmutableTable<SoyType, SoyType, BuiltinFunction> AVAILABLE_CALL_SITE_COERCIONS = new ImmutableTable.Builder().put((Object)IntType.getInstance(), (Object)FloatType.getInstance(), (Object)BuiltinFunction.TO_FLOAT).build();

    CheckTemplateCallsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        CheckCallsHelper helper = new CheckCallsHelper(registry);
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getChildren()) {
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallBasicNode.class)) {
                    helper.checkCall(template, (CallBasicNode)callNode);
                }
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    helper.checkCall(template, (CallDelegateNode)callNode);
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private final class CheckCallsHelper {
        private final TemplateRegistry templateRegistry;
        private final Map<TemplateMetadata, TemplateParamTypes> paramTypesMap = new HashMap<TemplateMetadata, TemplateParamTypes>();

        CheckCallsHelper(TemplateRegistry registry) {
            this.templateRegistry = registry;
        }

        void checkCall(TemplateNode callerTemplate, CallBasicNode node) {
            TemplateMetadata callee = this.templateRegistry.getBasicTemplateOrElement(node.getCalleeName());
            if (callee != null) {
                Predicate<String> paramsToRuntimeCheck = this.checkCallParamTypes(callerTemplate, node, callee);
                node.setParamsToRuntimeCheck(paramsToRuntimeCheck);
                this.checkCallParamNames(node, callee);
                this.checkPassesUnusedParams(node, callee);
            }
            this.checkStrictHtml(callerTemplate, node, callee);
        }

        void checkCall(TemplateNode callerTemplate, CallDelegateNode node) {
            ImmutableMap.Builder paramsToCheckByTemplate = ImmutableMap.builder();
            ImmutableList potentialCallees = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName());
            for (TemplateMetadata delTemplate : potentialCallees) {
                Predicate<String> params = this.checkCallParamTypes(callerTemplate, node, delTemplate);
                paramsToCheckByTemplate.put((Object)delTemplate.getTemplateName(), params);
                this.checkCallParamNames(node, delTemplate);
            }
            node.setParamsToRuntimeCheck((ImmutableMap<String, Predicate<String>>)paramsToCheckByTemplate.build());
            if (!potentialCallees.isEmpty()) {
                this.checkStrictHtml(callerTemplate, node, (TemplateMetadata)potentialCallees.get(0));
            }
        }

        private Predicate<String> checkCallParamTypes(TemplateNode callerTemplate, CallNode call, TemplateMetadata callee) {
            Collection declaredParamTypes;
            String paramName;
            TemplateParamTypes calleeParamTypes = this.getTemplateParamTypes(callee);
            HashSet<String> explicitParams = new HashSet<String>();
            HashSet paramNamesToRuntimeCheck = new HashSet(calleeParamTypes.params.keySet());
            paramNamesToRuntimeCheck.removeAll(calleeParamTypes.indirectParamNames);
            for (Object callerParam : call.getChildren()) {
                paramName = ((CallParamNode)callerParam).getKey().identifier();
                declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                SoyType argType = null;
                if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_VALUE_NODE) {
                    CallParamValueNode node = (CallParamValueNode)callerParam;
                    ExprRootNode expr = node.getExpr();
                    if (expr != null) {
                        argType = this.maybeCoerceType(node, expr.getType(), declaredParamTypes);
                    }
                } else if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_CONTENT_NODE) {
                    SanitizedContentKind contentKind = ((CallParamContentNode)callerParam).getContentKind();
                    argType = contentKind == null ? StringType.getInstance() : SanitizedType.getTypeForContentKind(contentKind);
                } else {
                    throw new AssertionError();
                }
                if (argType != null && argType.getKind() != SoyType.Kind.ERROR) {
                    boolean staticTypeSafe = true;
                    for (SoyType formalType : declaredParamTypes) {
                        staticTypeSafe &= this.checkArgumentAgainstParamType(((AbstractSoyNode)callerParam).getSourceLocation(), paramName, argType, formalType, calleeParamTypes);
                    }
                    if (staticTypeSafe) {
                        paramNamesToRuntimeCheck.remove(paramName);
                    }
                }
                explicitParams.add(paramName);
            }
            if (call.isPassingData() && call.isPassingAllData()) {
                for (Object callerParam : callerTemplate.getParams()) {
                    if (!(callerParam instanceof HeaderParam) || explicitParams.contains(paramName = ((TemplateParam)callerParam).name())) continue;
                    declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                    boolean staticTypeSafe = true;
                    for (SoyType formalType : declaredParamTypes) {
                        staticTypeSafe &= this.checkArgumentAgainstParamType(call.getSourceLocation(), paramName, ((TemplateParam)callerParam).type(), formalType, calleeParamTypes);
                    }
                    if (!staticTypeSafe) continue;
                    paramNamesToRuntimeCheck.remove(paramName);
                }
            }
            return arg_0 -> ((ImmutableSet)ImmutableSet.copyOf(paramNamesToRuntimeCheck)).contains(arg_0);
        }

        @CheckReturnValue
        private SoyType maybeCoerceType(CallParamValueNode paramNode, SoyType argType, Collection<SoyType> declaredTypes) {
            if (AVAILABLE_CALL_SITE_COERCIONS.row((Object)argType).isEmpty()) {
                return argType;
            }
            for (SoyType formalType : declaredTypes) {
                if (!formalType.isAssignableFrom(argType)) continue;
                return argType;
            }
            for (SoyType coercionTargetType : AVAILABLE_CALL_SITE_COERCIONS.row((Object)argType).keySet()) {
                BuiltinFunction function = null;
                for (SoyType formalType : declaredTypes) {
                    if (!formalType.isAssignableFrom(coercionTargetType)) continue;
                    if (function == null) {
                        function = (BuiltinFunction)AVAILABLE_CALL_SITE_COERCIONS.get((Object)argType, (Object)coercionTargetType);
                        continue;
                    }
                    function = null;
                    break;
                }
                if (function == null) continue;
                ExprRootNode root = paramNode.getExpr();
                FunctionNode newParam = new FunctionNode(Identifier.create(function.getName(), root.getRoot().getSourceLocation()), function, root.getRoot().getSourceLocation());
                newParam.setType(coercionTargetType);
                newParam.addChild(root.getRoot());
                root.addChild(newParam);
                return coercionTargetType;
            }
            return argType;
        }

        private boolean checkArgumentAgainstParamType(SourceLocation location, String paramName, SoyType argType, SoyType formalType, TemplateParamTypes calleeParams) {
            if (!calleeParams.isStrictlyTyped && formalType.getKind() == SoyType.Kind.UNKNOWN || formalType.getKind() == SoyType.Kind.ANY) {
                if (argType.getKind() == SoyType.Kind.PROTO) {
                    CheckTemplateCallsPass.this.errorReporter.report(location, PASSING_PROTOBUF_FROM_STRICT_TO_NON_STRICT, paramName, argType);
                }
            } else if (!(argType.getKind() == SoyType.Kind.UNKNOWN && SoyTypes.tryRemoveNull(formalType).getKind() != SoyType.Kind.MAP && SoyTypes.tryRemoveNull(formalType).getKind() != SoyType.Kind.VE && SoyTypes.tryRemoveNull(formalType).getKind() != SoyType.Kind.VE_DATA || formalType.isAssignableFrom(argType))) {
                if (calleeParams.isIndirect(paramName) && argType.getKind() == SoyType.Kind.UNION && ((UnionType)argType).isNullable() && SoyTypes.makeNullable(formalType).isAssignableFrom(argType)) {
                    return false;
                }
                CheckTemplateCallsPass.this.errorReporter.report(location, ARGUMENT_TYPE_MISMATCH, paramName, formalType, argType);
            }
            return true;
        }

        private TemplateParamTypes getTemplateParamTypes(TemplateMetadata callee) {
            TemplateParamTypes paramTypes = this.paramTypesMap.get(callee);
            if (paramTypes == null) {
                paramTypes = new TemplateParamTypes();
                paramTypes.isStrictlyTyped = !callee.getHasSoyDocParams();
                for (TemplateMetadata.Parameter param : callee.getParameters()) {
                    paramTypes.params.put((Object)param.getName(), (Object)param.getType());
                }
                IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(this.templateRegistry).calculateIndirectParams(callee);
                for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                    if (paramTypes.params.containsKey((Object)indirectParamName)) continue;
                    paramTypes.params.putAll((Object)indirectParamName, (Iterable)ipi.indirectParamTypes.get((Object)indirectParamName));
                    paramTypes.indirectParamNames.add(indirectParamName);
                }
                this.paramTypesMap.put(callee, paramTypes);
            }
            return paramTypes;
        }

        private void checkStrictHtml(TemplateNode callerTemplate, CallNode caller, @Nullable TemplateMetadata callee) {
            if (callerTemplate.isStrictHtml() && caller.getIsPcData() && callee != null && callee.getContentKind() == SanitizedContentKind.HTML && !callee.isStrictHtml()) {
                CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), STRICT_HTML, new Object[0]);
            }
        }

        private void checkCallParamNames(CallNode caller, TemplateMetadata callee) {
            if (callee != null) {
                HashSet callerParamKeys = Sets.newHashSet();
                for (CallParamNode callerParam : caller.getChildren()) {
                    boolean isUnique = callerParamKeys.add(callerParam.getKey().identifier());
                    if (isUnique) continue;
                    CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), DUPLICATE_PARAM, callerParam.getKey().identifier());
                }
                if (!caller.isPassingData()) {
                    ArrayList missingParamKeys = Lists.newArrayListWithCapacity((int)2);
                    for (TemplateMetadata.Parameter calleeParam : callee.getParameters()) {
                        if (!calleeParam.isRequired() || callerParamKeys.contains(calleeParam.getName())) continue;
                        missingParamKeys.add(calleeParam.getName());
                    }
                    if (!missingParamKeys.isEmpty()) {
                        String errorMsgEnd = missingParamKeys.size() == 1 ? "param '" + (String)missingParamKeys.get(0) + "'" : "params " + missingParamKeys;
                        CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), MISSING_PARAM, errorMsgEnd);
                    }
                }
            }
        }

        private void checkPassesUnusedParams(CallNode caller, TemplateMetadata callee) {
            if (caller.numChildren() == 0) {
                return;
            }
            HashSet paramNames = Sets.newHashSet();
            for (TemplateMetadata.Parameter param : callee.getParameters()) {
                paramNames.add(param.getName());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = null;
            for (CallParamNode callerParam : caller.getChildren()) {
                String paramName = callerParam.getKey().identifier();
                if (paramNames.contains(paramName)) continue;
                if (ipi == null) {
                    ipi = new IndirectParamsCalculator(this.templateRegistry).calculateIndirectParams(callee);
                    if (ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) {
                        return;
                    }
                }
                if (ipi.indirectParams.containsKey((Object)paramName)) continue;
                ImmutableSet allParams = ImmutableSet.builder().addAll((Iterable)paramNames).addAll((Iterable)ipi.indirectParams.keySet()).build();
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), PASSES_UNUSED_PARAM, paramName, callee.getTemplateName(), SoyErrors.getDidYouMeanMessage((Iterable<String>)allParams, paramName));
            }
        }

        private class TemplateParamTypes {
            public boolean isStrictlyTyped = true;
            public final Multimap<String, SoyType> params = HashMultimap.create();
            public final Set<String> indirectParamNames = new HashSet<String>();

            private TemplateParamTypes() {
            }

            public boolean isIndirect(String paramName) {
                return this.indirectParamNames.contains(paramName);
            }
        }
    }
}

